/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui.player;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.BlockColor;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.gui.player.PlayerMenu;
import com.betafase.mcmanager.utils.Text;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerInventoryMenu
extends Menu {
    Player pl;

    public PlayerInventoryMenu(Player pl, String lang) {
        super(new Text("mcm.gui.player_inv.title", lang, pl.getName()).toString(), 54, lang);
        int i;
        this.pl = pl;
        MenuItem empty = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.BLACK, " ");
        for (i = 0; i < 54; ++i) {
            this.getInventory().setItem(i, new ItemStack(Material.AIR));
        }
        for (i = 36; i < 45; ++i) {
            this.setItem(i, empty);
        }
        this.setItem(51, empty);
        this.setItem(49, GUIUtils.backOld(lang));
        this.setItem(50, new MenuItem(Material.CHEST, new Text("mcm.gui.player_inv.save", lang).toString()));
        ItemStack[] contents = pl.getInventory().getStorageContents();
        for (int i2 = 0; i2 < 45; ++i2) {
            try {
                this.setItem(i2, new MenuItem(contents[i2]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ItemStack[] armor = pl.getInventory().getArmorContents();
        int y = 0;
        for (int i3 = 45; i3 < 49; ++i3) {
            try {
                this.setItem(i3, new MenuItem(armor[y]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++y;
        }
        this.setItem(52, new MenuItem(pl.getInventory().getItemInOffHand()));
        this.setItem(53, new MenuItem(pl.getInventory().getItemInMainHand()));
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        this.setAutoCancel(true);
        Player p = (Player)e.getWhoClicked();
        if (e.getSlot() == 49) {
            new PlayerMenu((OfflinePlayer)this.pl, this.lang).open(p);
        } else if (e.getSlot() < 36) {
            this.setAutoCancel(false);
            if (e.getSlot() < 9 && e.getSlot() == this.pl.getInventory().getHeldItemSlot()) {
                try {
                    this.setItem(53, new MenuItem(this.getInventory().getItem(e.getSlot())));
                }
                catch (Exception ex) {
                    this.setItem(53, new MenuItem(Material.AIR));
                }
            }
        } else if (e.getSlot() == 50) {
            this.pl.getInventory().setStorageContents(Arrays.copyOf(e.getInventory().getContents(), this.pl.getInventory().getStorageContents().length));
            this.pl.getInventory().setArmorContents(Arrays.copyOfRange(e.getInventory().getContents(), 45, 49));
            if (e.getInventory().getItem(52) != null) {
                this.pl.getInventory().setItemInOffHand(e.getInventory().getItem(52));
            } else {
                this.pl.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
            }
            if (MCManager.getConfiguration().getBoolean("player_inv.warn")) {
                this.pl.sendMessage(MCManager.getPrefix() + new Text("mcm.gui.player_inv.warn", Text.getLanguage(this.pl), p.getDisplayName()));
            }
        } else if (e.getSlot() == 53) {
            this.setAutoCancel(false);
            try {
                this.setItem(this.pl.getInventory().getHeldItemSlot(), new MenuItem(this.getInventory().getItem(e.getSlot())));
            }
            catch (Exception ex) {
                this.setItem(this.pl.getInventory().getHeldItemSlot(), new MenuItem(Material.AIR));
            }
        } else if (e.getSlot() == 52 || e.getSlot() >= 45 && e.getSlot() < 49) {
            this.setAutoCancel(false);
        }
    }
}

