/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui.player;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.BlockColor;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.api.NotificationPrompt;
import com.betafase.mcmanager.api.SignInputHandler;
import com.betafase.mcmanager.gui.MainMenu;
import com.betafase.mcmanager.gui.player.PlayerMenu;
import com.betafase.mcmanager.utils.Text;
import com.betafase.mcmanager.utils.Utils;
import java.util.LinkedList;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MainPlayerMenu
extends Menu {
    private final int page;
    private final boolean offline;
    private OfflinePlayer[] loader = null;

    public MainPlayerMenu(String lang, int page, boolean offline) {
        this(lang, page, offline, () -> offline ? Bukkit.getOfflinePlayers() : Bukkit.getOnlinePlayers().toArray(new OfflinePlayer[Bukkit.getOnlinePlayers().size()]));
    }

    private MainPlayerMenu(String lang, int pg, boolean offl, final PlayerLoader ld) {
        super(new Text(offl ? "mcm.gui.players.title2" : "mcm.gui.players.title", lang).toString(), 36, lang);
        this.page = pg;
        this.offline = offl;
        MenuItem black = GUIUtils.black();
        for (int i = 0; i < 9; ++i) {
            this.setItem(i, black);
            this.setItem(27 + i, black);
        }
        this.setItem(9, black);
        this.setItem(18, black);
        this.setItem(17, black);
        this.setItem(26, black);
        if (this.page > 0) {
            this.setItem(30, GUIUtils.previous_page(lang, this.page));
        }
        this.setItem(31, GUIUtils.back(lang));
        MenuItem change = this.offline ? new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.LIME, new Text("mcm.gui.players.online", lang).toString()) : new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.RED, new Text("mcm.gui.players.offline", lang).toString());
        this.setItem(28, change);
        MenuItem search = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.BROWN, new Text("mcm.gui.players.search", lang).toString());
        this.setItem(27, search);
        new BukkitRunnable(){

            public void run() {
                if (!MainPlayerMenu.this.getInventory().getViewers().isEmpty()) {
                    if (MainPlayerMenu.this.loader == null) {
                        MainPlayerMenu.access$002(MainPlayerMenu.this, ld.loadPlayers());
                    }
                    MainPlayerMenu.this.refresh();
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)MCManager.getInstance(), 5L, 20L);
    }

    public void refresh() {
        int size;
        int counter = -this.page * 14;
        for (OfflinePlayer a : this.loader) {
            if (counter >= 0) {
                if (counter == 14) {
                    this.setItem(32, GUIUtils.next_page(this.lang, this.page + 2));
                    break;
                }
                if (a.isOnline()) {
                    Player o = (Player)a;
                    MenuItem player = new MenuItem(Material.SKULL_ITEM, 1, 3, "\u00a7a\u00a7l" + o.getDisplayName(), new Text("mcm.gui.player.health", this.getLanguage(), Utils.makeHealthReadable(o.getHealth())).toString(), new Text("mcm.gui.player.food", this.getLanguage(), o.getFoodLevel()).toString(), new Text("mcm.gui.player.gamemode", this.getLanguage(), o.getGameMode().toString()).toString());
                    SkullMeta meta = (SkullMeta)player.getItemMeta();
                    meta.setOwner(a.getName());
                    player.setItemMeta((ItemMeta)meta);
                    this.setItem(GUIUtils.convertCounterSlot(counter), player);
                } else {
                    MenuItem player = new MenuItem(Material.SKULL_ITEM, 1, 0, (a.isOnline() ? "\u00a7a\u00a7l" : "\u00a7c\u00a7l") + a.getName(), "\u00a77Last seen: \u00a76" + Utils.makeDateReadable(a.getLastPlayed()), new Text("mcm.gui.player.status", this.lang, a.isBanned() ? "\u00a7cBANNED" : (a.isOp() ? "\u00a76OPERATOR" : "\u00a76PLAYER")).toString());
                    SkullMeta meta = (SkullMeta)player.getItemMeta();
                    meta.setOwner(a.getName());
                    player.setItemMeta((ItemMeta)meta);
                    this.setItem(GUIUtils.convertCounterSlot(counter), player);
                }
            }
            ++counter;
        }
        MenuItem info = new MenuItem(Material.SKULL_ITEM, (size = Bukkit.getOnlinePlayers().size()) < 65 ? size : 1, 3, new Text("mcm.gui.players.online_size", this.lang, size).toString());
        this.setItem(4, info);
    }

    @Override
    public void onClick(final InventoryClickEvent e) {
        int slot = e.getSlot();
        final Player p = (Player)e.getWhoClicked();
        switch (slot) {
            case 31: {
                new MainMenu(p, this.getLanguage()).open(p);
                break;
            }
            case 28: {
                new MainPlayerMenu(this.lang, this.page, !this.offline).open(p);
                break;
            }
            case 27: {
                new BukkitRunnable(){

                    public void run() {
                        if (!MCManager.requestInput(p, new SignInputHandler(){

                            @Override
                            public void handleTextInput(String[] lines) {
                                String match = lines[0];
                                LinkedList<OfflinePlayer> result = new LinkedList<OfflinePlayer>();
                                for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
                                    if (!StringUtils.containsIgnoreCase((String)p.getName(), (String)match)) continue;
                                    result.add(p);
                                }
                                if (result.isEmpty()) {
                                    final 1 handler = this;
                                    new NotificationPrompt(new Text("mcm.gui.players.search_e_t", MainPlayerMenu.this.lang).toString(), NotificationPrompt.Type.ERROR, new Text("mcm.gui.plugin.search_e_nf", MainPlayerMenu.this.lang).toString(), MainPlayerMenu.this.lang){

                                        @Override
                                        public void onBack(Player p, String lang) {
                                            MCManager.requestInput(p, handler);
                                        }

                                        @Override
                                        public void onContinue(Player p, String lang) {
                                            MainPlayerMenu.this.open(p);
                                        }
                                    }.open(p);
                                } else if (result.size() == 1) {
                                    new PlayerMenu((OfflinePlayer)result.get(0), MainPlayerMenu.this.lang).open(p);
                                } else {
                                    new MainPlayerMenu(MainPlayerMenu.this.lang, 0, true, () -> result.toArray(new OfflinePlayer[result.size()])).open(p);
                                }
                            }

                            @Override
                            public String[] getDefault() {
                                return null;
                            }
                        })) {
                            new NotificationPrompt(e.getInventory().getTitle(), NotificationPrompt.Type.ERROR, "ProtocolLib is not installed. You need to have it installed for this function to work.", MainPlayerMenu.this.lang){

                                @Override
                                public void onBack(Player p, String lang) {
                                    MainPlayerMenu.this.open(p);
                                }

                                @Override
                                public void onContinue(Player p, String lang) {
                                    e.getView().close();
                                }
                            }.open(p);
                        }
                    }
                }.runTaskAsynchronously((Plugin)MCManager.getInstance());
                break;
            }
            case 30: {
                if (e.getCurrentItem().getDurability() != BlockColor.WHITE.toShort()) break;
                new MainPlayerMenu(this.getLanguage(), this.page - 1, this.offline, () -> this.loader).open(p);
                break;
            }
            case 32: {
                if (e.getCurrentItem().getDurability() != BlockColor.WHITE.toShort()) break;
                new MainPlayerMenu(this.getLanguage(), this.page - 1, this.offline, () -> this.loader).open(p);
                break;
            }
            default: {
                int conv = GUIUtils.convertInventorySlot(slot);
                if (conv < 0 || e.getCurrentItem().getType() != Material.SKULL_ITEM) break;
                new PlayerMenu(Bukkit.getOfflinePlayer((String)ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName())), this.getLanguage()).open(p);
            }
        }
    }

    static /* synthetic */ OfflinePlayer[] access$002(MainPlayerMenu x0, OfflinePlayer[] x1) {
        x0.loader = x1;
        return x1;
    }

    private static interface PlayerLoader {
        public OfflinePlayer[] loadPlayers();
    }
}

