/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui.backup;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.BlockColor;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.gui.MainMenu;
import com.betafase.mcmanager.gui.backup.BackupSettingsMenu;
import com.betafase.mcmanager.gui.backup.EditBackupMenu;
import com.betafase.mcmanager.security.ModuleManager;
import com.betafase.mcmanager.utils.Text;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BackupsMenu
extends Menu {
    File[] files;
    int page;

    public BackupsMenu(String lang) {
        this(lang, 0);
    }

    public BackupsMenu(final String lang, final int page) {
        super(new Text("mcm.gui.backup.title", lang).toString(), 36, lang);
        this.page = page;
        MenuItem black = GUIUtils.black();
        for (int i = 0; i < 9; ++i) {
            this.setItem(i, black);
            this.setItem(27 + i, black);
        }
        this.setItem(9, black);
        this.setItem(18, black);
        this.setItem(17, black);
        this.setItem(26, black);
        this.setItem(31, GUIUtils.back(lang));
        if (page != 0) {
            this.setItem(30, GUIUtils.previous_page(lang, page));
        }
        this.setItem(4, new MenuItem(Material.ENDER_CHEST, new Text("mcm.gui.backup.quick", lang).toString()));
        this.setItem(35, new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.BLUE, new Text("mcm.gui.backup.settings", lang).toString()));
        new BukkitRunnable(){

            public void run() {
                int counter = -page * 14;
                BackupsMenu.this.files = new File(MCManager.getConfiguration().getString("backup.folder")).listFiles((dir, name) -> name.startsWith("worlds-") || name.startsWith("plugindata-"));
                Arrays.sort(BackupsMenu.this.files, (o1, o2) -> {
                    if (o1.lastModified() < o2.lastModified()) {
                        return 1;
                    }
                    return -1;
                });
                for (File f : BackupsMenu.this.files) {
                    if (counter >= 0) {
                        if (counter == 14) {
                            BackupsMenu.this.setItem(32, GUIUtils.next_page(lang, page + 2));
                            break;
                        }
                        MenuItem backup = new MenuItem(Material.STAINED_CLAY);
                        backup.setDurability((short)new Random().nextInt(16));
                        ItemMeta bMeta = backup.getItemMeta();
                        LinkedList<String> lore = new LinkedList<String>();
                        if (f.getName().startsWith("plugindata-")) {
                            backup.setType(Material.STAINED_GLASS);
                        }
                        bMeta.setDisplayName(new Text(f.getName().startsWith("worlds-") ? "mcm.gui.backup.world" : "mcm.gui.backup.plugindata", lang, new SimpleDateFormat("dd.MM.yy HH:mm").format(new Date(f.lastModified()))).toString());
                        if (f.isDirectory()) {
                            lore.add(new Text("mcm.gui.backup.uncompressed", lang).toString());
                            lore.add(new Text("mcm.gui.file.size", lang, FileUtils.byteCountToDisplaySize(FileUtils.sizeOfDirectory(f))).toString());
                            lore.add(" ");
                            lore.add(new Text("mcm.gui.backup.edit", lang).toString());
                        } else if (f.getName().endsWith(".zip")) {
                            lore.add(new Text("mcm.gui.backup.compressed", lang).toString());
                            lore.add(new Text("mcm.gui.file.size", lang, FileUtils.byteCountToDisplaySize(FileUtils.sizeOf(f))).toString());
                            lore.add(" ");
                            lore.add(new Text("mcm.gui.backup.edit", lang).toString());
                        } else {
                            lore.add("\u00a7cInvalid data format. Data could not be parsed.");
                            backup.setType(Material.BARRIER);
                        }
                        bMeta.setLore(lore);
                        backup.setItemMeta(bMeta);
                        BackupsMenu.this.setItem(GUIUtils.convertCounterSlot(counter), backup);
                    }
                    ++counter;
                }
            }
        }.runTaskAsynchronously((Plugin)MCManager.getInstance());
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        switch (e.getSlot()) {
            case 4: {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)MCManager.getInstance(), () -> {
                    MCManager.getBackupManager().backupData();
                    new BackupsMenu(this.lang).open(p);
                });
                break;
            }
            case 31: {
                new MainMenu(p, this.lang).open(p);
                break;
            }
            case 35: {
                if (e.getCurrentItem().getDurability() != BlockColor.BLUE.toShort()) break;
                if (ModuleManager.isValid(p, "backup.settings")) {
                    new BackupSettingsMenu(this.lang).open(p);
                    break;
                }
                GUIUtils.showNoAccess(e, this.lang);
                break;
            }
            case 30: {
                if (e.getCurrentItem().getDurability() != BlockColor.WHITE.toShort()) break;
                new BackupsMenu(this.lang, this.page - 1).open(p);
                break;
            }
            case 32: {
                if (e.getCurrentItem().getDurability() != BlockColor.WHITE.toShort()) break;
                new BackupsMenu(this.lang, this.page + 1).open(p);
                break;
            }
            default: {
                int conv;
                if (e.getCurrentItem().getType() != Material.STAINED_CLAY && e.getCurrentItem().getType() != Material.STAINED_GLASS || (conv = GUIUtils.convertInventorySlot(e.getSlot())) == -1) break;
                new EditBackupMenu(this.files[conv], e.getCurrentItem().getDurability(), this.lang).open(p);
            }
        }
    }
}

