/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui.backup;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.api.NotificationPrompt;
import com.betafase.mcmanager.api.SignInputHandler;
import com.betafase.mcmanager.gui.backup.BackupsMenu;
import com.betafase.mcmanager.utils.Text;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class BackupSettingsMenu
extends Menu {
    public BackupSettingsMenu(String lang) {
        super(new Text("mcm.gui.backup.set_title", lang).toString(), 36, lang);
        MenuItem black = GUIUtils.black();
        for (int i = 0; i < 9; ++i) {
            this.setItem(i, black);
            this.setItem(27 + i, black);
        }
        this.setItem(9, black);
        this.setItem(18, black);
        this.setItem(17, black);
        this.setItem(26, black);
        this.setItem(31, GUIUtils.back(lang));
        FileConfiguration cfg = MCManager.getConfiguration();
        this.setItem(10, new MenuItem(Material.ENDER_CHEST, new Text("mcm.gui.backup.set_auto_t", lang).toString(), new Text("mcm.gui.backup.set_auto_d", lang).wordWrapAsArray(40, ChatColor.GRAY)));
        this.setItem(19, GUIUtils.displayBoolean(cfg.getBoolean("backup.enabled"), lang));
        this.setItem(11, new MenuItem(Material.SKULL_ITEM, new Text("mcm.gui.backup.set_empty_t", lang).toString(), new Text("mcm.gui.backup.set_empty_d", lang).wordWrapAsArray(40, ChatColor.GRAY)));
        this.setItem(20, GUIUtils.displayBoolean(cfg.getBoolean("backup.empty"), lang));
        this.setItem(12, new MenuItem(Material.DRAGON_EGG, new Text("mcm.gui.backup.set_zip_t", lang).toString(), new Text("mcm.gui.backup.set_zip_d", lang).wordWrapAsArray(40, ChatColor.GRAY)));
        this.setItem(21, GUIUtils.displayBoolean(cfg.getBoolean("backup.zip"), lang));
        this.setItem(13, new MenuItem(Material.GOLDEN_APPLE, new Text("mcm.gui.backup.set_exp_t", lang).toString(), new Text("mcm.gui.backup.set_exp_d", lang).wordWrapAsArray(40, ChatColor.GRAY)));
        this.setItem(22, GUIUtils.displayBoolean(cfg.getBoolean("backup.experimental"), lang));
        this.setItem(14, new MenuItem(Material.ANVIL, new Text("mcm.gui.backup.set_int_t", lang).toString(), new Text("mcm.gui.backup.set_int_d", lang).wordWrapAsArray(40, ChatColor.GRAY)));
        this.setItem(23, GUIUtils.displayInteger(cfg.getInt("backup.interval"), lang));
        this.setItem(15, new MenuItem(Material.BUCKET, new Text("mcm.gui.backup.set_amount_t", lang).toString(), new Text("mcm.gui.backup.set_amount_d", lang).wordWrapAsArray(40, ChatColor.GRAY)));
        this.setItem(24, GUIUtils.displayInteger(cfg.getInt("backup.amount"), lang));
        this.setItem(16, new MenuItem(Material.NAME_TAG, new Text("mcm.gui.backup.set_folder_t", lang).toString(), new Text("mcm.gui.backup.set_folder_d", lang).wordWrapAsArray(40, ChatColor.GRAY)));
        this.setItem(25, GUIUtils.displayString(cfg.getString("backup.folder"), lang));
    }

    @Override
    public void onClick(final InventoryClickEvent e) {
        final Player p = (Player)e.getWhoClicked();
        switch (e.getSlot()) {
            case 31: {
                new BackupsMenu(this.lang).open(p);
                break;
            }
            case 19: {
                if (MCManager.getConfiguration().getBoolean("backup.enabled")) {
                    MCManager.getConfiguration().set("backup.enabled", (Object)false);
                    MCManager.saveConfiguration();
                    if (MCManager.getBackupManager() != null && MCManager.getBackupManager().isActive()) {
                        MCManager.getBackupManager().cancel();
                    }
                    e.setCurrentItem((ItemStack)GUIUtils.disabled(this.lang));
                    break;
                }
                MCManager.getConfiguration().set("backup.enabled", (Object)true);
                MCManager.saveConfiguration();
                MCManager.getBackupManager().restart();
                e.setCurrentItem((ItemStack)GUIUtils.enabled(this.lang));
                break;
            }
            case 20: {
                if (MCManager.getConfiguration().getBoolean("backup.empty")) {
                    MCManager.getConfiguration().set("backup.empty", (Object)false);
                    MCManager.saveConfiguration();
                    e.setCurrentItem((ItemStack)GUIUtils.disabled(this.lang));
                    break;
                }
                MCManager.getConfiguration().set("backup.empty", (Object)true);
                MCManager.saveConfiguration();
                e.setCurrentItem((ItemStack)GUIUtils.enabled(this.lang));
                break;
            }
            case 21: {
                if (MCManager.getConfiguration().getBoolean("backup.zip")) {
                    MCManager.getConfiguration().set("backup.zip", (Object)false);
                    MCManager.saveConfiguration();
                    e.setCurrentItem((ItemStack)GUIUtils.disabled(this.lang));
                    break;
                }
                MCManager.getConfiguration().set("backup.zip", (Object)true);
                MCManager.saveConfiguration();
                e.setCurrentItem((ItemStack)GUIUtils.enabled(this.lang));
                break;
            }
            case 22: {
                if (MCManager.getConfiguration().getBoolean("backup.experimental")) {
                    MCManager.getConfiguration().set("backup.experimental", (Object)false);
                    MCManager.saveConfiguration();
                    e.setCurrentItem((ItemStack)GUIUtils.disabled(this.lang));
                    break;
                }
                MCManager.getConfiguration().set("backup.experimental", (Object)true);
                MCManager.saveConfiguration();
                e.setCurrentItem((ItemStack)GUIUtils.enabled(this.lang));
                break;
            }
            case 23: {
                if (MCManager.requestInput(p, new SignInputHandler(){

                    @Override
                    public void handleTextInput(String[] lines) {
                        try {
                            int i = Integer.parseInt(lines[0]);
                            if (i < -1) {
                                throw new NumberFormatException();
                            }
                            MCManager.getConfiguration().set("backup.interval", (Object)i);
                            MCManager.saveConfiguration();
                            e.setCurrentItem((ItemStack)GUIUtils.displayInteger(i, BackupSettingsMenu.this.lang));
                            BackupSettingsMenu.this.open(p);
                        }
                        catch (NumberFormatException ex) {
                            final 1 handler = this;
                            new NotificationPrompt(BackupSettingsMenu.this.getInventory().getTitle(), NotificationPrompt.Type.ERROR, new Text("mcm.gui.backup.set_invalid_n", BackupSettingsMenu.this.lang).toString(), BackupSettingsMenu.this.lang){

                                @Override
                                public void onBack(Player p, String lang) {
                                    MCManager.requestInput(p, handler);
                                }

                                @Override
                                public void onContinue(Player p, String lang) {
                                    BackupSettingsMenu.this.open(p);
                                }
                            }.open(p);
                        }
                    }

                    @Override
                    public String[] getDefault() {
                        return null;
                    }
                })) break;
                new NotificationPrompt(this.getInventory().getTitle(), NotificationPrompt.Type.ERROR, new Text("mcm.gui.backup.set_no_sign", this.lang).toString(), this.lang){

                    @Override
                    public void onBack(Player p, String lang) {
                        this.open(p);
                    }

                    @Override
                    public void onContinue(Player p, String lang) {
                        this.onBack(p, lang);
                    }
                }.open(p);
                break;
            }
            case 24: {
                if (MCManager.requestInput(p, new SignInputHandler(){

                    @Override
                    public void handleTextInput(String[] lines) {
                        try {
                            int i = Integer.parseInt(lines[0]);
                            if (i < 1) {
                                throw new NumberFormatException();
                            }
                            MCManager.getConfiguration().set("backup.amount", (Object)i);
                            MCManager.saveConfiguration();
                            e.setCurrentItem((ItemStack)GUIUtils.displayInteger(i, BackupSettingsMenu.this.lang));
                            BackupSettingsMenu.this.open(p);
                        }
                        catch (NumberFormatException ex) {
                            final 3 handler = this;
                            new NotificationPrompt(BackupSettingsMenu.this.getInventory().getTitle(), NotificationPrompt.Type.ERROR, new Text("mcm.gui.backup.set_invalid_n", BackupSettingsMenu.this.lang).toString(), BackupSettingsMenu.this.lang){

                                @Override
                                public void onBack(Player p, String lang) {
                                    MCManager.requestInput(p, handler);
                                }

                                @Override
                                public void onContinue(Player p, String lang) {
                                    BackupSettingsMenu.this.open(p);
                                }
                            }.open(p);
                        }
                    }

                    @Override
                    public String[] getDefault() {
                        return null;
                    }
                })) break;
                new NotificationPrompt(this.getInventory().getTitle(), NotificationPrompt.Type.ERROR, new Text("mcm.gui.backup.set_no_sign", this.lang).toString(), this.lang){

                    @Override
                    public void onBack(Player p, String lang) {
                        this.open(p);
                    }

                    @Override
                    public void onContinue(Player p, String lang) {
                        this.onBack(p, lang);
                    }
                }.open(p);
                break;
            }
            case 25: {
                if (MCManager.requestInput(p, new SignInputHandler(){

                    @Override
                    public void handleTextInput(String[] lines) {
                        try {
                            if (lines[0].isEmpty()) {
                                throw new Exception("Folder name is empty!");
                            }
                            MCManager.getConfiguration().set("backup.folder", (Object)lines[0]);
                            MCManager.saveConfiguration();
                            e.setCurrentItem((ItemStack)GUIUtils.displayString(lines[0], BackupSettingsMenu.this.lang));
                            BackupSettingsMenu.this.open(p);
                        }
                        catch (Exception ex) {
                            final 5 handler = this;
                            new NotificationPrompt("\u00a7c" + ex.getClass().getSimpleName(), NotificationPrompt.Type.ERROR, ex.getMessage(), BackupSettingsMenu.this.lang){

                                @Override
                                public void onBack(Player p, String lang) {
                                    MCManager.requestInput(p, handler);
                                }

                                @Override
                                public void onContinue(Player p, String lang) {
                                    BackupSettingsMenu.this.open(p);
                                }
                            }.open(p);
                        }
                    }

                    @Override
                    public String[] getDefault() {
                        return null;
                    }
                })) break;
                new NotificationPrompt(this.getInventory().getTitle(), NotificationPrompt.Type.ERROR, new Text("mcm.gui.backup.set_no_sign", this.lang).toString(), this.lang){

                    @Override
                    public void onBack(Player p, String lang) {
                        this.open(p);
                    }

                    @Override
                    public void onContinue(Player p, String lang) {
                        this.onBack(p, lang);
                    }
                }.open(p);
            }
        }
    }
}

