/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.BlockColor;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.command.WgetCommand;
import com.betafase.mcmanager.utils.Text;
import com.betafase.mcmanager.utils.spiget.SpigetPlugin;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.ChatPaginator;

public class SpigotMenu
extends Menu {
    int page;
    final PluginDataLoader loader;

    public SpigotMenu(final String lang, final int page, final PluginDataLoader loader) {
        super(new Text("mcm.gui.spigot.title", lang).toString(), 36, lang);
        this.page = page;
        this.loader = loader;
        MenuItem black = GUIUtils.black();
        for (int i = 0; i < 9; ++i) {
            this.setItem(i, black);
            this.setItem(27 + i, black);
        }
        this.setItem(9, black);
        this.setItem(18, black);
        this.setItem(17, black);
        this.setItem(26, black);
        this.setItem(31, new MenuItem(GUIUtils.back(lang)));
        if (page > 0) {
            this.setItem(30, new MenuItem(GUIUtils.previous_page(lang, page)));
        }
        MenuItem loading = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.YELLOW, "\u00a7eLoading data from spiget.org...");
        this.setItem(4, loading);
        new BukkitRunnable(){

            public void run() {
                int counter = -page * 14;
                if (loader.requireLoading()) {
                    loader.publishData();
                }
                MenuItem loading = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.YELLOW, "\u00a7eReading results...");
                SpigotMenu.this.setItem(4, loading);
                for (SpigetPlugin d : loader.display) {
                    if (counter >= 0) {
                        if (counter == 14) {
                            SpigotMenu.this.setItem(32, new MenuItem(GUIUtils.next_page(lang, page + 2)));
                            break;
                        }
                        try {
                            d.loadInformation();
                            String[] tag = ChatPaginator.wordWrap((String)d.getTag(), (int)40);
                            ArrayList<String> lore = new ArrayList<String>(7);
                            for (String s : tag) {
                                lore.add("\u00a77" + ChatColor.stripColor((String)s));
                            }
                            lore.add(new Text("mcm.gui.spigot.author", lang, d.getAuthor()).toString());
                            lore.add(new Text("mcm.gui.spigot.rating", lang, d.getRating()).toString());
                            lore.add(new Text("mcm.gui.spigot.downloads", lang, d.getDownloads()).toString());
                            lore.add(new Text("mcm.gui.spigot.last_update", lang, d.getLastUpdate()).toString());
                            lore.add(" ");
                            lore.add(loader.getActionCall(d, lang));
                            MenuItem plugin_view = new MenuItem(Material.MAGMA_CREAM, "\u00a76\u00a7l" + d.getName(), lore.toArray(new String[lore.size()]));
                            SpigotMenu.this.setItem(GUIUtils.convertCounterSlot(counter), plugin_view);
                        }
                        catch (Exception ex) {
                            MenuItem error = new MenuItem(Material.STAINED_GLASS_PANE, 1, 14, new Text("mcm.gui.spigot.error", lang).toString(), "\u00a77" + ex.getMessage());
                            SpigotMenu.this.setItem(GUIUtils.convertCounterSlot(counter), error);
                            ex.printStackTrace();
                        }
                    }
                    ++counter;
                }
                MenuItem loaded = new MenuItem(Material.STAINED_GLASS_PANE, 1, 5, "\u00a7a" + new Text("mcm.gui.spigot.all_loaded", lang));
                SpigotMenu.this.setItem(4, loaded);
            }
        }.runTaskAsynchronously((Plugin)MCManager.getInstance());
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        int slot = e.getSlot();
        Player p = (Player)e.getWhoClicked();
        switch (slot) {
            case 30: {
                if (e.getCurrentItem().getDurability() != BlockColor.WHITE.toShort()) break;
                new SpigotMenu(this.lang, this.page - 1, this.loader).open(p);
                break;
            }
            case 31: {
                this.loader.onBack(p);
                break;
            }
            case 32: {
                if (e.getCurrentItem().getDurability() == BlockColor.WHITE.toShort()) {
                    new SpigotMenu(this.lang, this.page + 1, this.loader).open(p);
                }
            }
            default: {
                int id;
                int converted = GUIUtils.convertInventorySlot(slot);
                if (converted == -1 || (id = converted + this.page * 14) >= this.loader.display.length) break;
                SpigetPlugin d = this.loader.display[id];
                this.loader.onClick(p, d, this.lang, e);
            }
        }
    }

    public static abstract class PluginDataLoader {
        public SpigetPlugin[] display;

        public boolean requireLoading() {
            return this.display == null;
        }

        public void publishData() {
            this.display = this.loadData();
        }

        public abstract SpigetPlugin[] loadData();

        public abstract void onBack(Player var1);

        public String getActionCall(SpigetPlugin plugin, String lang) {
            return new Text("mcm.gui.spigot.download", lang, plugin.isExternalDownload() ? "(External)" : "\u00a76(" + plugin.getFileSize() + ")").toString();
        }

        public void onClick(Player p, SpigetPlugin plugin, String lang, InventoryClickEvent e) {
            e.getView().close();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)MCManager.getInstance(), () -> {
                if (plugin.hasDirectDownload()) {
                    p.sendMessage(MCManager.getPrefix() + "\u00a7aCached Download from spiget.org found. Downloading directly...");
                    plugin.downloadDirectly(p, "plugins/SpigotPlugin_" + plugin.getID() + ".jar");
                } else if (plugin.isExternalDownload()) {
                    p.sendMessage(MCManager.getPrefix() + "\u00a7eThis Plugin has an external download. You must download it manually: \u00a7n" + plugin.getDownloadURL());
                } else {
                    p.sendMessage(MCManager.getPrefix() + "\u00a7aDownload started. Please wait...");
                    WgetCommand.downloadFile(plugin.getDownloadURL(), "plugins/SpigotPlugin_" + plugin.getID() + ".jar", p);
                }
            });
        }
    }
}

