/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.gui.MainMenu;
import com.betafase.mcmanager.utils.Text;
import java.io.Reader;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SettingsMenu
extends Menu {
    public SettingsMenu(final String lang) {
        super(new Text("mcm.gui.settings.title", lang).toString(), 36, lang);
        MenuItem black = GUIUtils.black();
        for (int i = 0; i < 9; ++i) {
            this.setItem(i, black);
            this.setItem(27 + i, black);
        }
        this.setItem(9, black);
        this.setItem(18, black);
        this.setItem(17, black);
        this.setItem(26, black);
        this.setItem(31, GUIUtils.back(lang));
        new BukkitRunnable(){

            public void run() {
                FileConfiguration cfg = MCManager.getConfiguration();
                SettingsMenu.this.setItem(13, new MenuItem(Material.BOOK, new Text("mcm.gui.settings.lang_t", lang).toString(), new Text("mcm.gui.settings.lang_d", lang).wordWrapAsArray(40, ChatColor.GRAY)));
                SettingsMenu.this.setItem(22, new MenuItem(Material.IRON_PICKAXE, new Text("mcm.gui.settings.lang_c", lang).toString()));
            }
        }.runTaskAsynchronously((Plugin)MCManager.getInstance());
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        switch (e.getSlot()) {
            case 22: {
                new LanguageSettingsMenu(this.lang).open(p);
                break;
            }
            case 31: {
                new MainMenu(p, this.lang).open(p);
            }
        }
    }

    private static class LanguageSettingsMenu
    extends Menu {
        public LanguageSettingsMenu(String lang) {
            super(new Text("mcm.gui.lang_settings.title", lang).toString(), 36, lang);
            MenuItem black = GUIUtils.black();
            for (int i = 0; i < 9; ++i) {
                this.setItem(i, black);
                this.setItem(27 + i, black);
            }
            this.setItem(9, black);
            this.setItem(18, black);
            this.setItem(17, black);
            this.setItem(26, black);
            this.setItem(31, GUIUtils.back(lang));
            MenuItem english = new MenuItem(Material.BOOK, new Text("mcm.gui.lang_settings.english", lang).toString());
            this.setItem(13, english);
            this.setItem(22, GUIUtils.displayBoolean(lang.equalsIgnoreCase("en_US") || lang.equalsIgnoreCase("default"), lang));
            this.setItem(10, new MenuItem(Material.BOOK, new Text("mcm.gui.lang_settings.german", lang).toString()));
            this.setItem(19, GUIUtils.displayBoolean(lang.equalsIgnoreCase("de_DE"), lang));
            this.setItem(16, new MenuItem(Material.BOOK, new Text("mcm.gui.lang_settings.custom", lang).toString()));
            this.setItem(25, GUIUtils.displayString(MCManager.getConfiguration().getString("language"), lang));
        }

        @Override
        public void onClick(InventoryClickEvent e) {
            Player p = (Player)e.getWhoClicked();
            switch (e.getSlot()) {
                case 22: {
                    Text.setPerUserLanguage(false);
                    MCManager.getConfiguration().set("language", (Object)"en_US");
                    MCManager.saveConfiguration();
                    new LanguageSettingsMenu("en_US").open(p);
                    break;
                }
                case 19: {
                    Text.addLanguage((FileConfiguration)YamlConfiguration.loadConfiguration((Reader)MCManager.getInstance().getTheDamnTextResource("texts/de_DE.yml")));
                    Text.setPerUserLanguage(true);
                    Text.setPlayerLanguageExecutor(n -> "de_DE");
                    MCManager.getConfiguration().set("language", (Object)"de_DE");
                    MCManager.saveConfiguration();
                    new LanguageSettingsMenu("de_DE").open(p);
                    break;
                }
                case 25: {
                    p.sendMessage(MCManager.getPrefix() + "\u00a7cThis is unfortunatly currently impossible in this interface.");
                    break;
                }
                case 31: {
                    new SettingsMenu(this.lang).open(p);
                }
            }
        }
    }
}

