/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.BlockColor;
import com.betafase.mcmanager.api.ExecutableMenuItem;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.api.PluginHook;
import com.betafase.mcmanager.api.RawMenuItem;
import com.betafase.mcmanager.api.SignInputHandler;
import com.betafase.mcmanager.gui.InfoMenu;
import com.betafase.mcmanager.gui.SettingsMenu;
import com.betafase.mcmanager.gui.plugin.MainPluginMenu;
import com.betafase.mcmanager.security.ModuleManager;
import com.betafase.mcmanager.utils.SpigotUpdater;
import com.betafase.mcmanager.utils.Text;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.ChatPaginator;

public class MainMenu
extends Menu {
    private static int builds_behind = 0;
    private static long last_check = 0L;

    private int convertConfigSlot(int config) {
        int slot = config % 7;
        int row = 1 + (config - slot) / 7;
        return row * 10 + slot;
    }

    private int convertMenuSlot(int menu) {
        if (menu >= 9 && menu < 27 && menu % 9 < 8 && menu % 9 > 0) {
            int slot = menu % 9 - 1;
            if (slot < 0 || slot > 7) {
                return -1;
            }
            int row = (menu - slot + 1) / 9 - 1;
            return row * 6 + slot;
        }
        return -1;
    }

    public MainMenu(Player p, final String lang) {
        super(new Text("mcm.gui.main.title", lang).toString(), 36, lang);
        MenuItem black = GUIUtils.black();
        for (int i = 0; i < 9; ++i) {
            this.setItem(i, black);
            this.setItem(27 + i, black);
        }
        this.setItem(9, black);
        this.setItem(18, black);
        this.setItem(17, black);
        this.setItem(26, black);
        MenuItem info = new MenuItem(Material.NETHER_STAR, new Text("mcm.gui.main.overview", lang).toString());
        this.setItem(4, info);
        for (Map.Entry<Integer, ExecutableMenuItem> en : MCManager.getMenuDesign().entrySet()) {
            this.setItem(this.convertConfigSlot(en.getKey()), en.getValue().getDisplayItem(lang));
        }
        if (ModuleManager.isValid("spigot_update")) {
            this.setItem(27, GUIUtils.loading(lang));
            new BukkitRunnable(){

                public void run() {
                    MenuItem spigot;
                    if (System.currentTimeMillis() - last_check > 2160000L) {
                        last_check = System.currentTimeMillis();
                        SpigotUpdater s = new SpigotUpdater();
                        builds_behind = s.buildsBehind();
                    }
                    if (SpigotUpdater.isUpdating()) {
                        spigot = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.RED, new Text("mcm.gui.main.spigot_update", lang).toString());
                        ItemMeta meta = spigot.getItemMeta();
                        LinkedList<String> lore = new LinkedList<String>();
                        lore.add(new Text("mcm.gui.main.spigot_active_d1", lang, builds_behind).toString());
                        meta.setLore(lore);
                        spigot.setItemMeta(meta);
                    } else if (builds_behind == 0) {
                        spigot = new MenuItem(Material.STAINED_GLASS_PANE, 1, 15, new Text("mcm.gui.main.spigot_no_update", lang).toString());
                        ItemMeta meta = spigot.getItemMeta();
                        LinkedList<String> lore = new LinkedList<String>();
                        for (String s : new Text("mcm.gui.main.spigot_update_d", lang).wordWrap(40, ChatColor.GRAY)) {
                            lore.add(s);
                        }
                        lore.add(" ");
                        lore.add(new Text("mcm.gui.main.spigot_update_a", lang).toString());
                        meta.setLore(lore);
                        spigot.setItemMeta(meta);
                    } else if (builds_behind > 0) {
                        spigot = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.ORANGE, new Text("mcm.gui.main.spigot_update", lang).toString());
                        ItemMeta meta = spigot.getItemMeta();
                        LinkedList<String> lore = new LinkedList<String>();
                        lore.add(new Text("mcm.gui.main.spigot_update_d1", lang, builds_behind).toString());
                        for (String s : new Text("mcm.gui.main.spigot_update_d", lang).wordWrap(40, ChatColor.GRAY)) {
                            lore.add(s);
                        }
                        lore.add(" ");
                        lore.add(new Text("mcm.gui.main.spigot_update_a", lang).toString());
                        meta.setLore(lore);
                        spigot.setItemMeta(meta);
                    } else if (builds_behind == -1) {
                        spigot = new MenuItem(Material.STAINED_GLASS_PANE, 1, 14, "\u00a7cFailed to load Spigot update information!");
                        ItemMeta meta = spigot.getItemMeta();
                        LinkedList<String> lore = new LinkedList<String>();
                        for (String s : new Text("mcm.gui.main.spigot_update_d", lang).wordWrap(40, ChatColor.GRAY)) {
                            lore.add(s);
                        }
                        lore.add(" ");
                        lore.add(new Text("mcm.gui.main.spigot_update_a", lang).toString());
                        meta.setLore(lore);
                        spigot.setItemMeta(meta);
                    } else {
                        spigot = new MenuItem(Material.STAINED_GLASS_PANE, 1, 4, new Text("mcm.gui.main.spigot_custom", lang).toString());
                        ItemMeta meta = spigot.getItemMeta();
                        LinkedList<String> lore = new LinkedList<String>();
                        for (String s : new Text("mcm.gui.main.spigot_update_d", lang).wordWrap(40, ChatColor.GRAY)) {
                            lore.add(s);
                        }
                        lore.add(" ");
                        lore.add(new Text("mcm.gui.main.spigot_update_a", lang).toString());
                        meta.setLore(lore);
                        spigot.setItemMeta(meta);
                    }
                    MainMenu.this.setItem(27, spigot);
                }
            }.runTaskAsynchronously((Plugin)MCManager.getInstance());
        } else {
            this.setItem(27, new MenuItem(Material.STAINED_GLASS_PANE, 1, 14, "\u00a7cSpigotUpdater has been blocked by the system."));
        }
        new BukkitRunnable(){

            public void run() {
                if (ModuleManager.isValid("plugin_updater") && System.currentTimeMillis() - last_check > 1200000L) {
                    last_check = System.currentTimeMillis();
                    MCManager.getUpdates().clear();
                    for (PluginHook h : MCManager.getPluginHooks()) {
                        if (MCManager.getUpdates().contains(h.getPlugin().getName()) || !h.hasUpdateChecker() || h.getUpdateChecker().checkUpdate() == null) continue;
                        MCManager.getUpdates().add(h.getPlugin().getName());
                    }
                }
                if (MCManager.getUpdates() != null && !MCManager.getUpdates().isEmpty()) {
                    String[] lore = MCManager.getUpdates().toArray(new String[MCManager.getUpdates().size()]);
                    for (int i = 0; i < lore.length; ++i) {
                        lore[i] = "\u00a77- " + ChatColor.stripColor((String)lore[i]);
                    }
                    lore = Arrays.copyOf(lore, lore.length + 2);
                    lore[lore.length - 2] = " ";
                    lore[lore.length - 1] = new Text("mcm.gui.main.pu_a", lang).toString();
                    MenuItem plugin_updates = new MenuItem(Material.STAINED_GLASS_PANE, MCManager.getUpdates().size(), BlockColor.ORANGE.toShort(), new Text("mcm.gui.main.pu_title", lang).toString(), lore);
                    MainMenu.this.setItem(28, plugin_updates);
                }
            }
        }.runTaskAsynchronously((Plugin)MCManager.getInstance());
        MenuItem error = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.BLUE, new Text("mcm.gui.main.settings", lang).toString());
        this.setItem(35, error);
        this.setItem(34, new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.CYAN, new Text("mcm.gui.main.error", lang).toString()));
        MenuItem close = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.RED, new Text("mcm.gui.main.close", lang).toString());
        this.setItem(31, close);
    }

    @Override
    public final void setItem(int slot, RawMenuItem stack) {
        super.setItem(slot, stack);
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        int slot = e.getSlot();
        final Player p = (Player)e.getWhoClicked();
        switch (slot) {
            case 4: {
                new InfoMenu(this.lang).open(p);
                break;
            }
            case 27: {
                if (e.getCurrentItem().getDurability() != BlockColor.ORANGE.toShort() && e.getCurrentItem().getDurability() != BlockColor.BLACK.toShort()) break;
                if (ModuleManager.isValid(p, "spigot_update")) {
                    if (SpigotUpdater.isUpdating()) break;
                    e.getView().close();
                    if (e.getClick() == ClickType.SHIFT_LEFT || e.getClick() == ClickType.SHIFT_RIGHT) {
                        if (MCManager.requestInput(p, new SignInputHandler(){

                            @Override
                            public void handleTextInput(String[] lines) {
                                SpigotUpdater updater = new SpigotUpdater();
                                Bukkit.getScheduler().runTaskAsynchronously((Plugin)MCManager.getInstance(), () -> updater.performUpdate(lines[0] + lines[1] + lines[2] + lines[3], p));
                            }

                            @Override
                            public String[] getDefault() {
                                return null;
                            }
                        })) break;
                        p.sendMessage(MCManager.getPrefix() + "\u00a7cProtocolLib is not installed!");
                        break;
                    }
                    SpigotUpdater updater = new SpigotUpdater();
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)MCManager.getInstance(), () -> updater.performUpdate(null, p));
                    break;
                }
                GUIUtils.showNoAccess(e, this.lang);
                break;
            }
            case 28: {
                if (ModuleManager.isValid(p, "plugin")) {
                    LinkedList<Plugin> pl = new LinkedList<Plugin>();
                    for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                        if (!MCManager.getUpdates().contains(plugin.getName())) continue;
                        pl.add(plugin);
                    }
                    if (pl.isEmpty()) break;
                    new MainPluginMenu(this.lang, 0, pl.toArray(new Plugin[pl.size()])).open(p);
                    break;
                }
                GUIUtils.showNoAccess(e, this.lang);
                break;
            }
            case 31: {
                e.getView().close();
                break;
            }
            case 35: {
                new SettingsMenu(this.lang).open(p);
                break;
            }
            case 34: {
                e.getView().close();
                p.sendMessage("\u00a79\u00a7lMCManager \u00a78Support Page");
                String text = "If you enjoy the plugin, please consider donating via PayPal as it is offered for free and/or write a review on Spigot. If there is a bug or any other error, please create an issue on Bitbucket. If you need help, please refer to the wiki  (https://bitbucket.org/iZefix/mcmanager/wiki/Home) or create an issue.";
                for (String s : ChatPaginator.wordWrap((String)text, (int)55)) {
                    p.sendMessage("\u00a77" + ChatColor.stripColor((String)s));
                }
                TextComponent donate = new TextComponent("\u00a76\u00a7nDonate via PayPal\n");
                donate.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=N4YLZ42CGRP3E"));
                donate.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=N4YLZ42CGRP3E").create()));
                p.spigot().sendMessage((BaseComponent)donate);
                TextComponent issue = new TextComponent("\u00a7c\u00a7nReport an issue on Bitbucket\n");
                issue.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bitbucket.org/iZefix/mcmanager/issues/new"));
                issue.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77https://bitbucket.org/iZefix/mcmanager/issues/new").create()));
                p.spigot().sendMessage((BaseComponent)issue);
                TextComponent spigot = new TextComponent("\u00a7e\u00a7nVisit Spigot Page\n");
                spigot.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.spigotmc.org/resources/mcmanager-ingame-server-management.7297/"));
                spigot.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77https://www.spigotmc.org/resources/mcmanager-ingame-server-management.7297/").create()));
                p.spigot().sendMessage((BaseComponent)spigot);
                break;
            }
            default: {
                int cfg_slot = this.convertMenuSlot(slot);
                if (cfg_slot < 0 || !MCManager.getMenuDesign().containsKey(cfg_slot)) break;
                MCManager.getMenuDesign().get(cfg_slot).onClick(e);
            }
        }
    }
}

