/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.Menu;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;

public class GUIManager
implements Listener {
    final Plugin pl;

    public GUIManager(Plugin pl) {
        this.pl = pl;
        this.registerListener();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getClickedInventory() != null && e.getClickedInventory().getHolder() instanceof Menu) {
            Menu m = (Menu)e.getInventory().getHolder();
            try {
                m.onClick(e);
                if (m.isAutoCancel()) {
                    e.setCancelled(true);
                    e.setResult(Event.Result.DENY);
                }
            }
            catch (Exception ex) {
                e.setCancelled(true);
                e.setResult(Event.Result.DENY);
                MCManager.getLog().log(Level.SEVERE, "Menu " + m.getClass().getSimpleName() + " caused an uncaught " + ex.getClass().getName() + ".", ex);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        if (e.getInventory() != null && e.getInventory().getHolder() instanceof Menu) {
            Menu m = (Menu)e.getInventory().getHolder();
            try {
                m.onClose(e);
            }
            catch (Exception ex) {
                MCManager.getLog().log(Level.SEVERE, "Menu " + m.getClass().getSimpleName() + " caused an uncaught " + ex.getClass().getName() + " while closing.", ex);
            }
        }
    }

    private void registerListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.pl);
    }
}

