/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.BlockColor;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.api.NotificationPrompt;
import com.betafase.mcmanager.api.SafetyPrompt;
import com.betafase.mcmanager.api.SignInputHandler;
import com.betafase.mcmanager.gui.MainMenu;
import com.betafase.mcmanager.security.ModuleManager;
import com.betafase.mcmanager.utils.Text;
import com.betafase.mcmanager.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FileMenu
extends Menu {
    private File dir;
    private String home;
    private int page;
    private UUID player;
    public static HashMap<UUID, Clipboard> clipboards = new HashMap();

    public FileMenu(final File dir, final String lang, UUID player, final int page) {
        super(dir.getName().length() > 22 ? new Text("mcm.gui.file.title", lang, dir.getName().substring(0, 20) + "...").toString() : new Text("mcm.gui.file.title", lang, dir.getName()).toString(), 36, lang);
        this.dir = dir;
        this.player = player;
        this.home = System.getProperty("user.dir");
        if (!ModuleManager.isFileEnabled(null, dir)) {
            this.setInventorySize(18);
            this.setItem(4, GUIUtils.no_access(lang));
            this.setItem(13, GUIUtils.backOld(lang));
            return;
        }
        if (!dir.isDirectory()) {
            MenuItem black = GUIUtils.black();
            for (int i = 0; i < 9; ++i) {
                this.setItem(i, black);
                this.setItem(27 + i, black);
            }
            this.setItem(9, black);
            this.setItem(18, black);
            this.setItem(17, black);
            this.setItem(26, black);
            this.setItem(31, GUIUtils.back(lang));
            MenuItem remove = new MenuItem(Material.BARRIER, new Text("mcm.gui.file.remove", lang).toString());
            this.setItem(GUIUtils.convertCounterSlot(13), remove);
            if (ModuleManager.isValid("webserver") && MCManager.getWebServer().isOnline()) {
                MenuItem download = new MenuItem(Material.EMERALD, "\u00a7a\u00a7l" + new Text("mcm.gui.file.download2", lang));
                this.setItem(GUIUtils.convertCounterSlot(11), download);
            }
            MenuItem rename = new MenuItem(Material.NAME_TAG, "\u00a7e\u00a7l" + new Text("mcm.gui.file.rename", lang));
            this.setItem(GUIUtils.convertCounterSlot(5), rename);
            MenuItem copy = new MenuItem(Material.STAINED_CLAY, 1, 5, "\u00a7a\u00a7l" + new Text("mcm.gui.file.copy", lang).toString());
            this.setItem(GUIUtils.convertCounterSlot(9), copy);
            String name = dir.getName();
            if (name.endsWith(".yml") || name.endsWith(".txt") || name.endsWith(".json") || name.endsWith(".properties") || name.contains(".log") || name.endsWith(".sh")) {
                MenuItem view = new MenuItem(Material.EYE_OF_ENDER, "\u00a77\u00a7l" + new Text("mcm.gui.file.view", lang));
                MenuItem edit = new MenuItem(Material.BOOK_AND_QUILL, "\u00a77\u00a7l" + new Text("mcm.gui.file.edit", lang));
                this.setItem(GUIUtils.convertCounterSlot(1), edit);
                this.setItem(GUIUtils.convertCounterSlot(3), view);
            }
            if (name.endsWith(".zip")) {
                MenuItem unzip = new MenuItem(Material.DRAGON_EGG, "\u00a7a\u00a7l" + new Text("mcm.gui.file.extract", lang));
                this.setItem(GUIUtils.convertCounterSlot(10), unzip);
            }
            if ((name.endsWith(".sh") || dir.canExecute()) && ModuleManager.isValid("file.run")) {
                MenuItem run = new MenuItem(Material.BLAZE_POWDER, "\u00a7a\u00a7l" + new Text("mcm.gui.file.run", lang));
                this.setItem(GUIUtils.convertCounterSlot(10), run);
            }
        } else {
            MenuItem black = GUIUtils.black();
            for (int i = 0; i < 9; ++i) {
                this.setItem(i, black);
                this.setItem(27 + i, black);
            }
            this.setItem(9, black);
            this.setItem(18, black);
            this.setItem(17, black);
            this.setItem(26, black);
            this.setItem(31, GUIUtils.back(lang));
            this.page = page;
            if (page != 0) {
                this.setItem(30, new MenuItem(GUIUtils.previous_page(lang, page)));
            }
            this.setItem(4, GUIUtils.loading(lang));
            new BukkitRunnable(){
                int counter;
                {
                    this.counter = -page * 14;
                }

                public void run() {
                    File[] files = dir.listFiles();
                    Arrays.sort(files, (o1, o2) -> o1.getAbsolutePath().compareTo(o2.getAbsolutePath()));
                    for (File f : files) {
                        if (!ModuleManager.isFileEnabled(null, f)) continue;
                        if (this.counter >= 0) {
                            if (this.counter == 14) {
                                FileMenu.this.setItem(32, new MenuItem(GUIUtils.next_page(lang, page + 2)));
                                break;
                            }
                            if (!ModuleManager.isFileEnabled(null, f)) continue;
                            String fname = f.getName();
                            Material view = Material.PAPER;
                            if (f.isDirectory()) {
                                if (f.list((dir, name) -> name.equalsIgnoreCase("level.dat")).length > 0) {
                                    fname = ChatColor.DARK_GREEN + "\u00a7l" + fname;
                                    view = Material.GRASS;
                                } else {
                                    fname = "\u00a76\u00a7l" + fname;
                                    view = Material.CHEST;
                                }
                            } else if (fname.endsWith(".jar") || fname.endsWith(".zip") || fname.endsWith(".exe")) {
                                fname = "\u00a74\u00a7l" + fname;
                                view = Material.ENDER_CHEST;
                            } else {
                                fname = fname.endsWith(".sh") || fname.endsWith(".bat") ? "\u00a7a\u00a7l" + fname : (fname.endsWith(".yml") || fname.endsWith(".txt") ? "\u00a7e\u00a7l" + fname : "\u00a77\u00a7l" + fname);
                            }
                            FileMenu.this.setItem(GUIUtils.convertCounterSlot(this.counter), new MenuItem(view, fname, new Text("mcm.gui.file.size", lang, FileUtils.byteCountToDisplaySize(FileUtils.sizeOf(f))).toString(), new Text("mcm.gui.file.last_change", lang, Utils.makeDateReadable(f.lastModified())).toString()));
                        }
                        ++this.counter;
                    }
                    String size = "Huuuuge";
                    try {
                        size = FileUtils.byteCountToDisplaySize(FileUtils.sizeOfDirectory(dir));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int f_size = dir.list().length;
                    if (f_size <= 0 || f_size > 64) {
                        f_size = 1;
                    }
                    MenuItem dirinfo = new MenuItem(Material.CHEST, f_size, 0, "\u00a76\u00a7l" + dir.getName(), new Text("mcm.gui.file.size", lang, size).toString());
                    FileMenu.this.setItem(4, dirinfo);
                }
            }.runTaskAsynchronously((Plugin)MCManager.getInstance());
            MenuItem createDir = new MenuItem(Material.STAINED_GLASS_PANE, 1, 5, new Text("mcm.gui.file.folder", lang).toString());
            if (ModuleManager.isValid("webserver") && MCManager.getWebServer().isOnline() && ModuleManager.isValid("file.upload")) {
                this.setItem(27, new MenuItem(Material.STAINED_GLASS_PANE, 1, 5, new Text("mcm.gui.file.upload", lang).toString()));
            }
            this.setItem(28, createDir);
            if (clipboards.containsKey(player)) {
                this.setItem(29, new MenuItem(Material.STAINED_GLASS_PANE, 1, 5, new Text("mcm.gui.file.paste", lang, clipboards.get(player).getFile().getName()).toString()));
            }
            MenuItem remove = new MenuItem(Material.STAINED_GLASS_PANE, 1, BlockColor.ORANGE.toShort(), new Text("mcm.gui.file.remove", lang).toString(), new Text("mcm.gui.file.remove_warning", lang).toString());
            this.setItem(35, remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClick(InventoryClickEvent e) {
        block77: {
            block75: {
                Player p;
                int slot;
                block76: {
                    if (this.dir.isDirectory()) break block75;
                    slot = e.getSlot();
                    p = (Player)e.getWhoClicked();
                    int converted = GUIUtils.convertInventorySlot(slot);
                    if (converted == -1) break block76;
                    switch (converted) {
                        case 3: {
                            if (e.getCurrentItem().getType() != Material.EYE_OF_ENDER) break;
                            e.getView().close();
                            try {
                                List<String> list = FileUtils.readLines(this.dir);
                                p.sendMessage(new Text("mcm.gui.file.view_loaded", this.getLanguage(), list.size()).toString());
                                for (String s : list) {
                                    p.sendMessage(s);
                                }
                                TextComponent back = new TextComponent("\u00a7c\u00a7nClick here to go back");
                                back.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/manager file " + this.dir.getPath()));
                                p.spigot().sendMessage((BaseComponent)back);
                            }
                            catch (IOException ex) {
                                p.sendMessage(MCManager.getPrefix() + "\u00a7cUnfortunatly, an " + ex.getClass().getName() + " occured ;(. Message: " + ex.getMessage());
                                ex.printStackTrace();
                            }
                            break;
                        }
                        case 10: {
                            if (e.getCurrentItem().getType() == Material.BLAZE_POWDER) {
                                if (this.dir.getName().endsWith(".jar")) {
                                    e.getView().close();
                                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)MCManager.getInstance(), () -> {
                                        try {
                                            String line;
                                            p.sendMessage("\u00a7aRunning Jar-File " + this.dir.getName() + "...");
                                            Process process = Runtime.getRuntime().exec("java -jar " + this.dir.getName(), null, this.dir.getParentFile());
                                            BufferedReader r = new BufferedReader(new InputStreamReader(process.getInputStream()));
                                            while ((line = r.readLine()) != null) {
                                                p.sendMessage(line);
                                            }
                                            p.sendMessage("\u00a7aThe Process has ended.");
                                            TextComponent back = new TextComponent("\u00a7c\u00a7nClick here to go back");
                                            back.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/manager file " + this.dir.getPath()));
                                            p.spigot().sendMessage((BaseComponent)back);
                                        }
                                        catch (IOException ex) {
                                            ex.printStackTrace();
                                        }
                                    });
                                    break;
                                }
                                if (!this.dir.getName().endsWith(".sh")) break;
                                e.getView().close();
                                Bukkit.getScheduler().runTaskAsynchronously((Plugin)MCManager.getInstance(), new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            String line;
                                            p.sendMessage("\u00a7aRunning Script " + FileMenu.this.dir.getName() + "...");
                                            Process process = Runtime.getRuntime().exec("./" + FileMenu.this.dir.getName(), null, FileMenu.this.dir.getParentFile());
                                            BufferedReader r = new BufferedReader(new InputStreamReader(process.getInputStream()));
                                            while ((line = r.readLine()) != null) {
                                                p.sendMessage(line);
                                            }
                                            p.sendMessage("\u00a7aThe Process has ended.");
                                            TextComponent back = new TextComponent("\u00a7c\u00a7nClick here to go back");
                                            back.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/manager file " + FileMenu.this.dir.getPath()));
                                            p.spigot().sendMessage((BaseComponent)back);
                                        }
                                        catch (IOException ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                });
                                break;
                            }
                            if (e.getCurrentItem().getType() != Material.DRAGON_EGG) break;
                            try {
                                try (ZipFile zipFile = new ZipFile(this.dir);){
                                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                                    while (entries.hasMoreElements()) {
                                        ZipEntry entry = entries.nextElement();
                                        File entryDestination = new File(this.dir.getParentFile(), entry.getName());
                                        if (entry.isDirectory()) {
                                            entryDestination.mkdirs();
                                            continue;
                                        }
                                        entryDestination.getParentFile().mkdirs();
                                        InputStream in = zipFile.getInputStream(entry);
                                        FileOutputStream out = new FileOutputStream(entryDestination);
                                        IOUtils.copy(in, (OutputStream)out);
                                        IOUtils.closeQuietly(in);
                                        ((OutputStream)out).close();
                                    }
                                }
                                new FileMenu(this.dir.getParentFile(), Text.getLanguage(p), p.getUniqueId(), 0).open(p);
                            }
                            catch (Exception ex) {
                                e.getView().close();
                                p.sendMessage(MCManager.getPrefix() + "\u00a7cAn " + ex.getClass().getName() + " occured while extracting zip-file. Check the console log for details.");
                                ex.printStackTrace();
                            }
                            break;
                        }
                        case 1: {
                            if (e.getCurrentItem().getType() != Material.BOOK_AND_QUILL) break;
                            e.getView().close();
                            MenuItem book = new MenuItem(Material.BOOK_AND_QUILL, "\u00a77\u00a7lEdit " + this.dir.getName(), "\u00a7r" + this.dir.getAbsolutePath());
                            BookMeta bmeta = (BookMeta)book.getItemMeta();
                            try {
                                for (String line : FileUtils.readLines(this.dir, "UTF-8")) {
                                    bmeta.addPage(new String[]{line});
                                }
                                book.setItemMeta((ItemMeta)bmeta);
                                p.getInventory().addItem(new ItemStack[]{book});
                                p.sendMessage(new Text("mcm.gui.file.book_hint", this.lang).toString());
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                p.sendMessage("\u00a7cAn " + ex.getClass().getName() + " occured. Check the console log for details.");
                            }
                            break;
                        }
                        case 5: {
                            if (e.getCurrentItem().getType() != Material.NAME_TAG) break;
                            if (e.getClick() == ClickType.SHIFT_LEFT || e.getClick() == ClickType.SHIFT_RIGHT) {
                                e.getView().close();
                                clipboards.put(this.player, new Clipboard(this.dir, true));
                                TextComponent con = new TextComponent(new Text("mcm.gui.file.proceed", this.lang).toString());
                                con.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/move " + this.dir.getParent() + "/<newName>"));
                                TextComponent back = new TextComponent(new Text("mcm.gui.file.back", this.lang).toString());
                                back.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/manager file " + this.dir.getPath()));
                                p.spigot().sendMessage(new BaseComponent[]{con, back});
                                break;
                            }
                            if (MCManager.requestInput(p, new SignInputHandler(){

                                @Override
                                public void handleTextInput(String[] lines) {
                                    String output = lines[0] + lines[1] + lines[2] + lines[3];
                                    if (!output.isEmpty()) {
                                        try {
                                            File newF = new File(FileMenu.this.dir.getParentFile(), output);
                                            FileUtils.moveFile(FileMenu.this.dir, newF);
                                            new FileMenu(newF, FileMenu.this.lang, FileMenu.this.player, 0).open(p);
                                        }
                                        catch (Exception ex) {
                                            new NotificationPrompt(FileMenu.this.getInventory().getTitle(), NotificationPrompt.Type.ERROR, ex.getClass().getSimpleName() + ": " + ex.getMessage(), FileMenu.this.lang){

                                                @Override
                                                public void onBack(Player p, String lang) {
                                                    this.onContinue(p, lang);
                                                }

                                                @Override
                                                public void onContinue(Player p, String lang) {
                                                    FileMenu.this.open(p);
                                                }
                                            }.open(p);
                                        }
                                    } else {
                                        FileMenu.this.open(p);
                                    }
                                }

                                @Override
                                public String[] getDefault() {
                                    return new String[]{FileMenu.this.dir.getName(), "", "", ""};
                                }
                            })) break;
                            p.sendMessage(MCManager.getPrefix() + "\u00a7cProtocolLib is not installed!");
                            e.getView().close();
                            clipboards.put(this.player, new Clipboard(this.dir, true));
                            TextComponent con = new TextComponent(new Text("mcm.gui.file.proceed", this.lang).toString());
                            con.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/move " + this.dir.getParent() + "/<newName>"));
                            TextComponent back = new TextComponent(new Text("mcm.gui.file.back", this.lang).toString());
                            back.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/manager file " + this.dir.getPath()));
                            p.spigot().sendMessage(new BaseComponent[]{con, back});
                            break;
                        }
                        case 9: {
                            if (e.getCurrentItem().getType() != Material.STAINED_CLAY) break;
                            e.setCurrentItem(new ItemStack(Material.AIR));
                            clipboards.put(this.player, new Clipboard(this.dir, false));
                            break;
                        }
                        case 11: {
                            e.getView().close();
                            try {
                                p.sendMessage(MCManager.getPrefix() + "\u00a7a\u00a7n" + InetAddress.getLocalHost().getCanonicalHostName() + ":" + MCManager.getWebServer().getPort() + "/download?file=" + this.dir.getPath());
                            }
                            catch (UnknownHostException ex) {
                                Logger.getLogger(FileMenu.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            break;
                        }
                        case 13: {
                            if (MCManager.getConfiguration().getBoolean("file.safe_delete")) {
                                new SafetyPrompt(new Text("mcm.gui.safety", this.lang).toString(), this.lang){

                                    @Override
                                    public void onApprove(boolean approve) {
                                        if (approve) {
                                            FileMenu.this.dir.delete();
                                            new FileMenu(FileMenu.this.dir.getParentFile(), this.getLanguage(), p.getUniqueId(), 0).open(p);
                                        } else {
                                            new FileMenu(FileMenu.this.dir, this.getLanguage(), p.getUniqueId(), 0).open(p);
                                        }
                                    }
                                }.open(p);
                                break;
                            }
                            this.dir.delete();
                            new FileMenu(this.dir.getParentFile(), this.getLanguage(), p.getUniqueId(), 0).open(p);
                        }
                    }
                    break block77;
                }
                switch (slot) {
                    case 31: {
                        new FileMenu(this.dir.getParentFile(), this.getLanguage(), p.getUniqueId(), 0).open(p);
                    }
                }
                break block77;
            }
            final Player p = (Player)e.getWhoClicked();
            int slot = e.getSlot();
            int conv = GUIUtils.convertInventorySlot(slot);
            if (conv != -1) {
                if (e.getCurrentItem().getType() != Material.AIR) {
                    File f = new File(this.dir, ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()));
                    if (e.getAction().equals((Object)InventoryAction.DROP_ONE_SLOT) && MCManager.getConfiguration().getBoolean("file.drop_delete")) {
                        if (!f.isDirectory() && ModuleManager.isFileEnabled(p, f)) {
                            f.delete();
                            new FileMenu(this.dir, this.lang, this.player, this.page).open(p);
                        }
                    } else if (ModuleManager.isFileEnabled(p, f)) {
                        if (ModuleManager.isFileEnabled(p, f)) {
                            new FileMenu(f, this.getLanguage(), p.getUniqueId(), 0).open(p);
                        }
                    } else {
                        GUIUtils.showNoAccess(e, this.lang);
                    }
                }
            } else if (slot == 27) {
                e.getView().close();
                TextComponent proceed = new TextComponent(new Text("mcm.gui.file.upload_link", this.lang).toString());
                try {
                    proceed.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://" + InetAddress.getLocalHost().getCanonicalHostName() + ":" + MCManager.getWebServer().getPort() + "/upload"));
                    proceed.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77http://" + InetAddress.getLocalHost().getCanonicalHostName() + ":" + MCManager.getWebServer().getPort() + "/upload").create()));
                }
                catch (UnknownHostException ex) {
                    MCManager.getLog().log(Level.SEVERE, null, ex);
                }
                TextComponent back = new TextComponent(new Text("mcm.gui.file.back", this.lang).toString());
                back.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/manager file " + this.dir.getPath()));
                p.spigot().sendMessage(new BaseComponent[]{new TextComponent(MCManager.getPrefix()), proceed, back});
            } else if (slot == 28) {
                e.getView().close();
                if (!MCManager.requestInput(p, new SignInputHandler(){

                    @Override
                    public void handleTextInput(String[] lines) {
                        String newS = lines[0] + lines[1] + lines[2] + lines[3];
                        if (!newS.isEmpty()) {
                            p.performCommand("mkdir " + FileMenu.this.dir.getPath() + "/" + newS);
                            new FileMenu(new File(FileMenu.this.dir, newS), FileMenu.this.lang, FileMenu.this.player, 0).open(p);
                        } else {
                            new FileMenu(FileMenu.this.dir, FileMenu.this.lang, FileMenu.this.player, FileMenu.this.page).open(p);
                        }
                    }

                    @Override
                    public String[] getDefault() {
                        return null;
                    }
                })) {
                    TextComponent proceed = new TextComponent(new Text("mcm.gui.file.proceed", this.lang).toString());
                    proceed.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/mkdir " + this.dir.getPath() + "/<name>"));
                    TextComponent back = new TextComponent(new Text("mcm.gui.file.back", this.lang).toString());
                    back.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/manager file " + this.dir.getPath()));
                    p.spigot().sendMessage(new BaseComponent[]{proceed, back});
                }
            } else if (slot == 29) {
                if (clipboards.containsKey(this.player)) {
                    Clipboard c = clipboards.get(this.player);
                    File f = c.getFile();
                    if (!f.exists()) {
                        p.sendMessage(MCManager.getPrefix() + "\u00a7cThe File in the Clipboard does not exist!");
                    } else if (f.isDirectory()) {
                        try {
                            FileUtils.copyDirectoryToDirectory(f, this.dir);
                            p.sendMessage(MCManager.getPrefix() + "\u00a7aDirectory successfully copied.");
                        }
                        catch (IOException ex) {
                            p.sendMessage(MCManager.getPrefix() + "\u00a7cFailed to copy directory: " + ex.getMessage());
                            p.sendMessage(new Text("mcm.exception.log_hint", this.lang).toString());
                            ex.printStackTrace();
                        }
                    } else {
                        try {
                            FileUtils.copyFileToDirectory(f, this.dir);
                            p.sendMessage(MCManager.getPrefix() + "\u00a7aFile successfully copied.");
                        }
                        catch (IOException ex) {
                            p.sendMessage(MCManager.getPrefix() + "\u00a7cFailed to copy directory: " + ex.getMessage());
                            p.sendMessage(new Text("mcm.exception.log_hint", this.lang).toString());
                            ex.printStackTrace();
                        }
                    }
                    clipboards.remove(this.player);
                    new FileMenu(this.dir, this.lang, this.player, this.page).open(p);
                }
            } else if (slot == 31) {
                if (this.dir.getParent() != null && this.dir.getParentFile().getAbsolutePath().startsWith(this.home)) {
                    new FileMenu(this.dir.getParentFile(), this.getLanguage(), p.getUniqueId(), 0).open(p);
                } else {
                    new MainMenu(p, this.getLanguage()).open(p);
                }
            } else if (slot == 30) {
                if (e.getCurrentItem().getDurability() == BlockColor.WHITE.toShort()) {
                    new FileMenu(this.dir, this.getLanguage(), p.getUniqueId(), this.page - 1).open(p);
                }
            } else if (slot == 32) {
                if (e.getCurrentItem().getDurability() == BlockColor.WHITE.toShort()) {
                    new FileMenu(this.dir, this.getLanguage(), p.getUniqueId(), this.page + 1).open(p);
                }
            } else if (slot == 35 && !this.dir.equals(new File(this.home))) {
                if (MCManager.getConfiguration().getBoolean("file.safe_delete")) {
                    new SafetyPrompt(new Text("mcm.gui.safety", this.lang).toString(), this.lang){

                        @Override
                        public void onApprove(boolean approve) {
                            if (approve) {
                                try {
                                    FileUtils.deleteDirectory(FileMenu.this.dir);
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                    p.sendMessage(MCManager.getPrefix() + "\u00a7cFailed to delete directory. Check log for more information.");
                                }
                                if (FileMenu.this.dir.getParent() != null && FileMenu.this.dir.getParentFile().getAbsolutePath().startsWith(FileMenu.this.home)) {
                                    new FileMenu(FileMenu.this.dir.getParentFile(), this.getLanguage(), p.getUniqueId(), 0).open(p);
                                } else {
                                    new MainMenu(p, this.getLanguage()).open(p);
                                }
                            } else {
                                new FileMenu(FileMenu.this.dir, this.lang, FileMenu.this.player, FileMenu.this.page).open(p);
                            }
                        }
                    }.open(p);
                } else {
                    try {
                        FileUtils.deleteDirectory(this.dir);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        p.sendMessage(MCManager.getPrefix() + "\u00a7cFailed to delete directory. Check log for more information.");
                    }
                    if (this.dir.getParent() != null && this.dir.getParentFile().getAbsolutePath().startsWith(this.home)) {
                        new FileMenu(this.dir.getParentFile(), this.getLanguage(), p.getUniqueId(), 0).open(p);
                    } else {
                        new MainMenu(p, this.getLanguage()).open(p);
                    }
                }
            }
        }
    }

    public static class Clipboard {
        private File file;
        private boolean move;

        public Clipboard(File file, boolean move) {
            this.file = file;
            this.move = move;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public boolean isMove() {
            return this.move;
        }

        public void setMove(boolean move) {
            this.move = move;
        }
    }
}

