/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.BlockColor;
import com.betafase.mcmanager.api.ConfigChangeEvent;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.api.SignInputHandler;
import com.betafase.mcmanager.gui.plugin.PluginMenu;
import com.betafase.mcmanager.utils.Text;
import java.util.LinkedList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ConfigMenu
extends Menu {
    Plugin pl;
    ConfigurationSection current;
    int page;

    public ConfigMenu(Plugin pl, ConfigurationSection current, int page, String lang) {
        super(new Text("mcm.gui.config.title", lang, current.getName().length() > 20 ? current.getName().substring(0, 20) + "..." : current.getName()).toString(), 36, lang);
        this.pl = pl;
        this.current = current;
        this.page = page;
        MenuItem black = GUIUtils.black();
        for (int i = 0; i < 9; ++i) {
            this.setItem(i, black);
            this.setItem(27 + i, black);
        }
        this.setItem(9, black);
        this.setItem(18, black);
        this.setItem(17, black);
        this.setItem(26, black);
        this.setItem(31, GUIUtils.back(lang));
        if (page > 0) {
            this.setItem(30, new MenuItem(GUIUtils.previous_page(lang, page)));
        }
        Bukkit.getScheduler().runTaskAsynchronously(pl, () -> {
            int counter = -page * 14;
            for (String s : current.getKeys(false)) {
                if (counter >= 0) {
                    MenuItem item;
                    if (counter == 14) {
                        this.setItem(32, GUIUtils.next_page(lang, page + 2));
                        break;
                    }
                    if (current.isConfigurationSection(s)) {
                        item = new MenuItem(Material.CHEST, "\u00a76\u00a7l" + StringUtils.capitalize((String)s));
                    } else if (current.isBoolean(s)) {
                        boolean bln = current.getBoolean(s);
                        item = bln ? new MenuItem(Material.EMERALD_BLOCK, "\u00a7a\u00a7l" + StringUtils.capitalize((String)s), "\u00a77Value: \u00a76" + bln) : new MenuItem(Material.REDSTONE_BLOCK, "\u00a7c\u00a7l" + StringUtils.capitalize((String)s), "\u00a77Value: \u00a76" + bln);
                    } else if (current.isInt(s)) {
                        int integer = current.getInt(s);
                        item = new MenuItem(Material.GOLD_BLOCK, "\u00a7e\u00a7l" + StringUtils.capitalize((String)s), "\u00a77Value: \u00a76" + integer);
                    } else if (current.isString(s)) {
                        String string = current.getString(s);
                        item = new MenuItem(Material.BOOKSHELF, "\u00a7e\u00a7l" + StringUtils.capitalize((String)s), "\u00a77Value: \u00a76" + string);
                    } else if (current.isList(s)) {
                        try {
                            List list = current.getList(s);
                            item = new MenuItem(new ItemStack(Material.LADDER));
                            ItemMeta imeta = item.getItemMeta();
                            imeta.setDisplayName("\u00a79\u00a7l" + StringUtils.capitalize((String)s));
                            LinkedList<String> lore = new LinkedList<String>();
                            int c = 0;
                            for (Object o : list) {
                                if (c >= 10) {
                                    lore.add("\u00a77... and \u00a76" + (list.size() - 10) + "\u00a77 more");
                                    break;
                                }
                                lore.add("\u00a77 - \u00a76" + o.toString());
                                ++c;
                            }
                            imeta.setLore(lore);
                            item.setItemMeta(imeta);
                        }
                        catch (Exception ex) {
                            item = new MenuItem(Material.BONE, "\u00a7c\u00a7lERROR");
                            ex.printStackTrace();
                        }
                    } else {
                        Object o = current.get(s);
                        item = new MenuItem(Material.PAPER, "\u00a78\u00a7l" + StringUtils.capitalize((String)s), "\u00a77Value: \u00a76" + o.toString());
                    }
                    this.setItem(GUIUtils.convertCounterSlot(counter), item);
                }
                ++counter;
            }
        });
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        block22: {
            Player p;
            int slot;
            block21: {
                slot = e.getSlot();
                p = (Player)e.getWhoClicked();
                int conv = GUIUtils.convertInventorySlot(slot);
                if (conv == -1) break block21;
                Material type = e.getCurrentItem().getType();
                final String s = ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).toLowerCase();
                switch (type) {
                    case AIR: {
                        break;
                    }
                    case REDSTONE_BLOCK: {
                        boolean bln = true;
                        ConfigChangeEvent event = new ConfigChangeEvent(this.pl, this.current.getCurrentPath() + "." + s, bln);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        this.current.set(s, event.getValue());
                        this.pl.saveConfig();
                        MenuItem item = new MenuItem(Material.EMERALD_BLOCK, "\u00a7a\u00a7l" + StringUtils.capitalize((String)s), "\u00a77Value: \u00a76" + bln);
                        this.setItem(slot, item);
                        break;
                    }
                    case EMERALD_BLOCK: {
                        boolean bln = false;
                        ConfigChangeEvent event2 = new ConfigChangeEvent(this.pl, this.current.getCurrentPath() + "." + s, bln);
                        Bukkit.getPluginManager().callEvent((Event)event2);
                        this.current.set(s, event2.getValue());
                        this.pl.saveConfig();
                        MenuItem item = new MenuItem(Material.REDSTONE_BLOCK, "\u00a7c\u00a7l" + StringUtils.capitalize((String)s), "\u00a77Value: \u00a76" + bln);
                        this.setItem(slot, item);
                        break;
                    }
                    case GOLD_BLOCK: {
                        e.getView().close();
                        if (!MCManager.requestInput(p, new SignInputHandler(){

                            @Override
                            public void handleTextInput(String[] lines) {
                                ConfigChangeEvent event = new ConfigChangeEvent(ConfigMenu.this.pl, ConfigMenu.this.current.getCurrentPath() + "." + s, lines[0] + lines[1] + lines[2] + lines[3]);
                                Bukkit.getPluginManager().callEvent((Event)event);
                                ConfigMenu.this.current.set(s, event.getValue());
                                ConfigMenu.this.pl.saveConfig();
                                GUIUtils.openAsync(ConfigMenu.this.getInventory(), (HumanEntity)p);
                            }

                            @Override
                            public String[] getDefault() {
                                String[] array = new String[4];
                                array[0] = Integer.toString(ConfigMenu.this.current.getInt(s));
                                return array;
                            }
                        })) {
                            TextComponent t = new TextComponent("\u00a7aClick \u00a7nhere\u00a7r\u00a7a to change             ");
                            TextComponent back = new TextComponent("\u00a7c[BACK]");
                            t.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/config " + this.pl.getName() + " " + this.current.getCurrentPath() + (this.current.getCurrentPath().isEmpty() ? "" : ".") + s + " <value>"));
                            if (this.current.getParent() == null) {
                                back.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/config " + this.pl.getName() + " home"));
                            } else {
                                back.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/config " + this.pl.getName() + " " + this.current.getCurrentPath()));
                            }
                            p.spigot().sendMessage(new BaseComponent[]{t, back});
                            break;
                        }
                        break block22;
                    }
                    case BOOKSHELF: {
                        e.getView().close();
                        TextComponent t = new TextComponent("\u00a7aClick \u00a7nhere\u00a7r\u00a7a to change             ");
                        TextComponent back = new TextComponent("\u00a7c[BACK]");
                        t.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/config " + this.pl.getName() + " " + this.current.getCurrentPath() + (this.current.getCurrentPath().isEmpty() ? "" : ".") + s + " <value>"));
                        if (this.current.getParent() == null) {
                            back.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/config " + this.pl.getName() + " home"));
                        } else {
                            back.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/config " + this.pl.getName() + " " + this.current.getCurrentPath()));
                        }
                        p.spigot().sendMessage(new BaseComponent[]{t, back});
                        break;
                    }
                    case CHEST: {
                        new ConfigMenu(this.pl, this.current.getConfigurationSection(s), 0, this.getLanguage()).open(p);
                        break;
                    }
                    default: {
                        p.sendMessage("\u00a7cThis item can't be edited yet. Create an issue if you want to change this \u00a7csetting here: \u00a76https://bitbucket.org/iZefix/mcmanager/issues/new");
                        break;
                    }
                }
                break block22;
            }
            if (slot == 30) {
                if (e.getCurrentItem().getDurability() == BlockColor.WHITE.toShort()) {
                    new ConfigMenu(this.pl, this.current, this.page - 1, this.getLanguage()).open(p);
                }
            } else if (slot == 31) {
                if (this.current.getParent() != null) {
                    new ConfigMenu(this.pl, this.current.getParent(), 0, this.getLanguage()).open(p);
                } else {
                    new PluginMenu(this.pl, this.getLanguage()).open(p);
                }
            } else if (slot == 32 && e.getCurrentItem().getDurability() == BlockColor.WHITE.toShort()) {
                new ConfigMenu(this.pl, this.current, this.page + 1, this.getLanguage()).open(p);
            }
        }
    }
}

