/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.api;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.command.WgetCommand;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public interface UpdateChecker {
    public UpdateInfo checkUpdate();

    public Plugin getPlugin();

    public static class UpdateInfo {
        private Plugin plugin;
        private String title;
        private String version;
        private String description;
        private String download_url;
        private String jar_name;

        public UpdateInfo(Plugin plugin, String title, String version, String description, String download_url) {
            this.title = title;
            this.version = version;
            this.description = description;
            this.download_url = download_url;
            try {
                this.jar_name = new File(plugin.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getName();
            }
            catch (Exception ex) {
                Logger.getLogger(MCManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void setJarName(String jar_name) {
            this.jar_name = jar_name;
        }

        public String getJarName() {
            return this.jar_name;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public String getTitle() {
            return this.title;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDescription() {
            return this.description;
        }

        public void performUpdate(Player notifier) {
            if (this != null && this.jar_name != null && this.download_url != null) {
                WgetCommand.downloadFile(this.download_url, this.jar_name, notifier);
            }
        }
    }
}

