/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.api;

import com.betafase.mcmanager.api.UpdateChecker;
import com.betafase.mcmanager.utils.spiget.ServerRequest;
import com.betafase.mcmanager.utils.spiget.SpigetPlugin;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SpigotUpdateChecker
implements UpdateChecker {
    private final int spigot_id;
    private final Plugin plugin;

    public SpigotUpdateChecker(Plugin plugin, int spigot_id) {
        this.spigot_id = spigot_id;
        this.plugin = plugin;
    }

    public int getSpigotID() {
        return this.spigot_id;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public UpdateChecker.UpdateInfo checkUpdate() {
        ServerRequest r = new ServerRequest("resources/" + this.spigot_id + "/versions?sort=-releaseDate");
        JsonElement e = r.getAsJsonElement();
        if (e.isJsonArray()) {
            JsonObject current = e.getAsJsonArray().get(0).getAsJsonObject();
            String version = current.get("name").getAsString();
            if (!version.equalsIgnoreCase(this.plugin.getDescription().getVersion())) {
                ServerRequest r2 = new ServerRequest("resources/" + this.spigot_id + "/updates?size=1&sort=-date");
                JsonObject update = r2.getAsJsonElement().getAsJsonArray().get(0).getAsJsonObject();
                String title = update.get("title").getAsString();
                String description = "Update found via SpigetUpdater";
                try {
                    description = new String(Base64.getDecoder().decode(update.get("description").getAsString()), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(SpigotUpdateChecker.class.getName()).log(Level.SEVERE, null, ex);
                }
                description = description.replaceAll("(?s)<[^>]*>(\\s*<[^>]*>)*", " ");
                if (description.length() > 300) {
                    description = description.substring(0, 300) + "...";
                }
                UpdateChecker.UpdateInfo info = new UpdateChecker.UpdateInfo(this.plugin, title, version, description, current.has("url") ? current.get("url").getAsString() : null){

                    @Override
                    public void performUpdate(Player notifier) {
                        SpigetPlugin d = new SpigetPlugin(SpigotUpdateChecker.this.spigot_id);
                        d.loadInformation();
                        if (d.hasDirectDownload()) {
                            notifier.sendMessage("\u00a7aCached Download from spiget.org found. Downloading directly...");
                            d.downloadDirectly(notifier, "plugins/" + this.getJarName());
                        } else if (d.isExternalDownload()) {
                            notifier.sendMessage("\u00a7c\u00a7lError \u00a7e\u00a7lThis Plugin has an external download. You must download it manually: " + d.getDownloadURL());
                        } else {
                            notifier.sendMessage("\u00a7aDownload started. Please wait...");
                            notifier.performCommand("wget plugins " + d.getDownloadURL());
                        }
                    }
                };
                return info;
            }
        } else {
            System.out.println("Could not check update for " + this.plugin.getName() + " : " + r.getAsString());
        }
        return null;
    }
}

