/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.api;

import com.betafase.mcmanager.api.ExecutableMenuItem;
import com.betafase.mcmanager.api.UpdateChecker;
import java.util.Objects;
import org.bukkit.plugin.Plugin;

public class PluginHook {
    private final Plugin plugin;
    private UpdateChecker checker;
    private ExecutableMenuItem[] items = new ExecutableMenuItem[9];

    public PluginHook(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean hasUpdateChecker() {
        return this.checker != null || this.items[5] != null;
    }

    public UpdateChecker getUpdateChecker() {
        return this.checker;
    }

    public void setUpdateChecker(UpdateChecker checker) {
        this.checker = checker;
    }

    public ExecutableMenuItem[] getCustomMenuItems() {
        return this.items;
    }

    public void setCustomMenuItem(int slot, ExecutableMenuItem item) {
        if (slot < 0 || slot >= 9) {
            throw new IllegalArgumentException("Slot must be between 0 and 8");
        }
        this.items[slot] = item;
    }

    public boolean isCustomItem(int slot) {
        if (slot >= 0 && slot < 9) {
            return this.items[slot] != null;
        }
        return false;
    }

    public ExecutableMenuItem getCustomItem(int slot) {
        if (slot >= 0 && slot < 9) {
            return this.items[slot];
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Plugin) {
            return obj.equals(this.getPlugin());
        }
        if (obj instanceof PluginHook) {
            return super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + Objects.hashCode(this.plugin);
        return hash;
    }
}

