/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.api;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.BlockColor;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.utils.Text;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class NotificationPrompt
extends Menu {
    public NotificationPrompt(String title, Type type, String message, final String lang) {
        super(title, 9, lang);
        BlockColor c;
        String t;
        this.setItem(0, new MenuItem(Material.STAINED_CLAY, BlockColor.LIME, new Text("mcm.notification.continue", lang).toString()));
        this.setItem(8, GUIUtils.backOld(lang));
        switch (type) {
            case SUCCESS: {
                t = new Text("mcm.notification.success", lang).toString();
                c = BlockColor.LIME;
                break;
            }
            case ERROR: {
                t = new Text("mcm.notification.error", lang).toString();
                c = BlockColor.RED;
                break;
            }
            case WARNING: {
                t = new Text("mcm.notification.warning", lang).toString();
                c = BlockColor.YELLOW;
                break;
            }
            default: {
                t = "\u00a78\u00a7lNotification";
                c = BlockColor.GRAY;
            }
        }
        this.setItem(4, new MenuItem(Material.STAINED_GLASS, 1, c.toShort(), t, Text.wordWrapAsArray(message, 40, ChatColor.GRAY)));
        for (int i = 1; i < 8; ++i) {
            if (this.getInventory().getItem(i) != null && this.getInventory().getItem(i).getType() != Material.AIR) continue;
            this.setItem(i, new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.GRAY, " "));
        }
        new BukkitRunnable(){
            int counter = 7;

            public void run() {
                if (this.counter > 0) {
                    if (NotificationPrompt.this.getInventory().getItem(this.counter).getType() == Material.STAINED_GLASS_PANE) {
                        NotificationPrompt.this.setItem(this.counter, new MenuItem(Material.STAINED_GLASS_PANE, c, " "));
                    }
                    --this.counter;
                } else {
                    if (!NotificationPrompt.this.getInventory().getViewers().isEmpty()) {
                        NotificationPrompt.this.getInventory().getViewers().stream().forEach(h -> NotificationPrompt.this.onContinue((Player)h, lang));
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MCManager.getInstance(), 20L, 20L);
    }

    public abstract void onBack(Player var1, String var2);

    public abstract void onContinue(Player var1, String var2);

    @Override
    public void onClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        switch (e.getSlot()) {
            case 0: {
                e.getView().close();
                this.onContinue(p, this.lang);
                break;
            }
            case 8: {
                e.getView().close();
                this.onBack(p, this.lang);
            }
        }
    }

    public static enum Type {
        SUCCESS,
        ERROR,
        WARNING;

    }
}

