/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.api;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.RawMenuItem;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class Menu
implements InventoryHolder,
Listener {
    private Inventory inv;
    public final String lang;
    int slots;
    private String title;
    private boolean autoCancel = true;

    public Menu(String title, int slots, String lang) {
        this.lang = lang;
        this.title = title;
        this.slots = slots;
    }

    public void setAutoCancel(boolean autoCancel) {
        this.autoCancel = autoCancel;
    }

    public void setMenuItem(int slot, RawMenuItem item) {
        if (slot < 0 || slot > 13) {
            throw new IndexOutOfBoundsException("Slot must be between 0 and 13.");
        }
        this.setItem(GUIUtils.convertCounterSlot(slot), item);
    }

    public final void setInventorySize(int newSize) throws IllegalStateException {
        if (this.inv != null) {
            throw new IllegalStateException("Can't set size of already created menu.");
        }
        this.slots = newSize;
    }

    public boolean isAutoCancel() {
        return this.autoCancel;
    }

    public abstract void onClick(InventoryClickEvent var1);

    public void setItem(int slot, RawMenuItem stack) {
        this.getInventory().setItem(slot, (ItemStack)stack.getDisplayItem(this.lang));
    }

    public String getLanguage() {
        return this.lang;
    }

    public Inventory getInventory() {
        if (this.inv == null) {
            this.inv = Bukkit.createInventory((InventoryHolder)this, (int)this.slots, (String)this.title);
        }
        return this.inv;
    }

    public void open(Player p) {
        Validate.notNull((Object)p, (String)"Player must not be null.");
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MCManager.getInstance(), () -> {
            p.openInventory(this.getInventory());
            this.onOpen(p);
        }, 2L);
    }

    public void onClose(InventoryCloseEvent e) {
    }

    public void onOpen(Player p) {
    }
}

