/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.api;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.ExecutableMenuItem;
import com.betafase.mcmanager.api.PluginHook;
import com.betafase.mcmanager.api.SignInputHandler;
import com.betafase.mcmanager.api.SpigotUpdateChecker;
import com.betafase.mcmanager.api.UpdateChecker;
import com.betafase.mcmanager.command.WgetCommand;
import com.betafase.mcmanager.gui.FileMenu;
import com.betafase.mcmanager.gui.plugin.PluginMenu;
import com.betafase.mcmanager.security.ModuleManager;
import com.betafase.mcmanager.utils.Text;
import java.io.File;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MCManagerAPI {
    public static PluginHook getPluginHook(Plugin pl) {
        return MCManager.getPluginHook(pl);
    }

    public static void registerUpdater(UpdateChecker checker) {
        MCManagerAPI.getPluginHook(checker.getPlugin()).setUpdateChecker(checker);
    }

    public static void registerSpigotUpdater(Plugin plugin, int id) {
        MCManagerAPI.registerUpdater(new SpigotUpdateChecker(plugin, id));
    }

    public static boolean requestSignTextInput(Player p, SignInputHandler handler) {
        return MCManager.requestInput(p, handler);
    }

    public static void downloadFile(String url, String save, Player notifier) {
        if (!ModuleManager.isValid(notifier, "wget")) {
            throw new SecurityException("Access denied.");
        }
        WgetCommand.downloadFile(url, save, notifier);
    }

    public static void openFileMenu(Player p, File f) {
        if (!ModuleManager.isValid(p, "file")) {
            throw new SecurityException("Access denied.");
        }
        new FileMenu(f, Text.getLanguage(p), p.getUniqueId(), 0).open(p);
    }

    public static void openPluginMenu(Player p, Plugin pl) {
        if (!ModuleManager.isValid(p, "plugin")) {
            throw new SecurityException("Access denied.");
        }
        new PluginMenu(pl, Text.getLanguage(p)).open(p);
    }

    public static void setMainMenuItem(int slot, ExecutableMenuItem item) {
        Validate.isTrue((slot < 14 && slot >= 0 ? 1 : 0) != 0, (String)"Slot must be between 0 and 15", (long)slot);
        MCManager.getMenuDesign().put(slot, item);
    }

    public static boolean recommendAddMainMenuItem(int pref_slot, ExecutableMenuItem item) {
        if (!MCManager.getMenuDesign().containsKey(pref_slot)) {
            MCManagerAPI.setMainMenuItem(pref_slot, item);
            return true;
        }
        return MCManagerAPI.addMenuItem(item);
    }

    public static boolean addMenuItem(ExecutableMenuItem item) {
        int slot = MCManagerAPI.getNextMainMenuSlot();
        if (slot < 0) {
            return false;
        }
        MCManager.getMenuDesign().put(slot, item);
        return true;
    }

    public static int getNextMainMenuSlot() {
        int[] array = new int[16];
        for (Integer in : MCManager.getMenuDesign().keySet()) {
            array[in.intValue()] = 1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != 0) continue;
            return i;
        }
        return -1;
    }
}

