/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.api;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.BlockColor;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.utils.Text;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GUIUtils {
    public static void openAsync(Inventory inventory, HumanEntity player) {
        Inventory inv = inventory;
        HumanEntity p = player;
        Runnable r = () -> p.openInventory(inv);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MCManager.getInstance(), r, 2L);
    }

    public static MenuItem loadingOld(String lang) {
        return new MenuItem(Material.POTATO_ITEM, "\u00a77Loading...");
    }

    public static MenuItem no_access(String lang) {
        return new MenuItem(Material.STAINED_GLASS_PANE, 0, 14, new Text("mcm.gui.security", lang).toString());
    }

    public static MenuItem backOld(String lang) {
        return new MenuItem(Material.ARROW, "\u00a7c" + new Text("mcm.gui.back", lang));
    }

    public static MenuItem next_pageOld(String lang, int page) {
        MenuItem stack = new MenuItem(Material.STICK, page);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName("\u00a7a" + new Text("mcm.gui.next_page", lang));
        stack.setItemMeta(meta);
        return stack;
    }

    public static MenuItem previous_pageOld(String lang, int page) {
        MenuItem stack = new MenuItem(Material.STICK, page);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName("\u00a7a" + new Text("mcm.gui.previous_page", lang));
        stack.setItemMeta(meta);
        return stack;
    }

    public static MenuItem back(String lang) {
        return new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.RED, "\u00a7c" + new Text("mcm.gui.back", lang));
    }

    public static MenuItem previous_page(String lang, int page) {
        MenuItem stack = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.WHITE, ChatColor.WHITE.toString() + new Text("mcm.gui.previous_page", lang));
        stack.setAmount(page);
        return stack;
    }

    public static MenuItem next_page(String lang, int page) {
        MenuItem stack = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.WHITE, ChatColor.WHITE.toString() + new Text("mcm.gui.next_page", lang));
        stack.setAmount(page);
        return stack;
    }

    public static MenuItem black() {
        return new MenuItem(Material.STAINED_GLASS_PANE, 1, 15, " ");
    }

    public static MenuItem loading(String lang) {
        return new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.YELLOW, new Text("mcm.gui.loading", lang).toString());
    }

    public static MenuItem displayInteger(int value, String lang) {
        return new MenuItem(Material.INK_SACK, value > 0 && value <= 64 ? value : 1, 9, "\u00a7e" + value);
    }

    public static MenuItem displayString(String value, String lang) {
        return new MenuItem(Material.INK_SACK, 1, 5, "\u00a7e" + value);
    }

    public static MenuItem displayBoolean(boolean value, String lang) {
        if (value) {
            return GUIUtils.enabled(lang);
        }
        return GUIUtils.disabled(lang);
    }

    public static MenuItem disabled(String lang) {
        return new MenuItem(Material.INK_SACK, 1, 8, "\u00a77" + new Text("mcm.gui.disabled", lang));
    }

    public static MenuItem enabled(String lang) {
        return new MenuItem(Material.INK_SACK, 1, 10, "\u00a7a" + new Text("mcm.gui.enabled", lang));
    }

    public static MenuItem all(String lang, boolean selected) {
        MenuItem stack = new MenuItem(Material.GLOWSTONE_DUST);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName("\u00a76" + new Text("mcm.gui.all", lang));
        if (selected) {
            meta.addEnchant(Enchantment.LUCK, 1, selected);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        stack.setItemMeta(meta);
        return stack;
    }

    public static ItemStack friends(String lang, boolean selected) {
        ItemStack stack = new ItemStack(Material.REDSTONE);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName("\u00a74" + new Text("mcm.gui.friends", lang));
        if (selected) {
            meta.addEnchant(Enchantment.LUCK, 1, selected);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        stack.setItemMeta(meta);
        return stack;
    }

    public static ItemStack none(String lang, boolean selected) {
        ItemStack stack = new ItemStack(Material.SULPHUR);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName("\u00a77" + new Text("mcm.gui.none", lang));
        if (selected) {
            meta.addEnchant(Enchantment.LUCK, 1, selected);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        stack.setItemMeta(meta);
        return stack;
    }

    public static int convertCounterSlot(int counter) {
        if (counter >= 7) {
            counter += 2;
        }
        return counter += 10;
    }

    public static int convertInventorySlot(int inv) {
        if (inv >= 9 && inv < 27 && inv % 9 < 8 && inv % 9 > 0) {
            if ((inv -= 10) >= 9) {
                inv -= 2;
            }
            return inv;
        }
        return -1;
    }

    public static void showNoAccess(InventoryClickEvent e, String lang) {
        ItemStack item = e.getCurrentItem();
        e.setCurrentItem((ItemStack)GUIUtils.no_access(lang));
        Bukkit.getScheduler().runTaskLater((Plugin)MCManager.getInstance(), () -> e.setCurrentItem(item), 20L);
    }
}

