/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager;

import com.betafase.mcmanager.api.ExecutableMenuItem;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.MCManagerAPI;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.api.PluginHook;
import com.betafase.mcmanager.api.SignInputHandler;
import com.betafase.mcmanager.api.SpigotUpdateChecker;
import com.betafase.mcmanager.command.ConfigCommand;
import com.betafase.mcmanager.command.MainCommand;
import com.betafase.mcmanager.command.MkdirCommand;
import com.betafase.mcmanager.command.MoveCommand;
import com.betafase.mcmanager.command.QuickCommandHandler;
import com.betafase.mcmanager.command.SearchPluginCommand;
import com.betafase.mcmanager.command.WgetCommand;
import com.betafase.mcmanager.command.WorldCreateCommand;
import com.betafase.mcmanager.gui.FileMenu;
import com.betafase.mcmanager.gui.GUIManager;
import com.betafase.mcmanager.gui.backup.BackupsMenu;
import com.betafase.mcmanager.gui.player.MainPlayerMenu;
import com.betafase.mcmanager.gui.plugin.MainPluginMenu;
import com.betafase.mcmanager.gui.world.WorldsMenu;
import com.betafase.mcmanager.listener.BookHandler;
import com.betafase.mcmanager.listener.DamageHandler;
import com.betafase.mcmanager.listener.WorldEventHandler;
import com.betafase.mcmanager.security.ModuleManager;
import com.betafase.mcmanager.utils.BackupManager;
import com.betafase.mcmanager.utils.Text;
import com.betafase.mcmanager.utils.TextInputHandleWrapper;
import com.betafase.mcmanager.web.WebManager;
import com.betafase.mcmanager.web.WebServer;
import java.io.File;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.RandomStringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.ChatPaginator;

public class MCManager
extends JavaPlugin {
    private static MCManager instance;
    private GUIManager manager;
    private TextInputHandleWrapper inputHandler;
    private WebServer webserver;
    private BackupManager backup;
    private final String prefix = "\u00a78MCManager > ";
    private HashMap<String, PluginHook> plugin_hooks;
    private List<String> req_updates = new LinkedList<String>();
    private HashMap<Integer, ExecutableMenuItem> menu;

    public static MCManager getInstance() {
        return instance;
    }

    public static String getInstanceName() {
        return instance.getName();
    }

    public GUIManager getGUIManager() {
        return this.manager;
    }

    public static Logger getLog() {
        return instance.getLogger();
    }

    public static String getPrefix() {
        return MCManager.instance.prefix;
    }

    public static List<String> getUpdates() {
        return MCManager.instance.req_updates;
    }

    public static HashMap<Integer, ExecutableMenuItem> getMenuDesign() {
        return MCManager.instance.menu;
    }

    public void onEnable() {
        int port;
        instance = this;
        this.menu = new LinkedHashMap<Integer, ExecutableMenuItem>();
        if (Bukkit.getPluginManager().isPluginEnabled("ProtocolLib")) {
            this.getLogger().log(Level.INFO, "Injecting into ProtocolLib...");
            this.inputHandler = new TextInputHandleWrapper((Plugin)this);
        } else {
            this.getLogger().log(Level.WARNING, "Dependency ProtocolLib not found. Please install it to use all functions.");
            this.inputHandler = null;
        }
        this.manager = new GUIManager((Plugin)this);
        ModuleManager.initializeData();
        Bukkit.getPluginCommand((String)"manager").setExecutor((CommandExecutor)new MainCommand());
        Bukkit.getPluginCommand((String)"manager").setAliases(Arrays.asList("mcm", "m"));
        Bukkit.getPluginCommand((String)"wget").setExecutor((CommandExecutor)new WgetCommand());
        Bukkit.getPluginCommand((String)"mkdir").setExecutor((CommandExecutor)new MkdirCommand());
        Bukkit.getPluginCommand((String)"config").setExecutor((CommandExecutor)new ConfigCommand());
        Bukkit.getPluginCommand((String)"move").setExecutor((CommandExecutor)new MoveCommand());
        Bukkit.getPluginCommand((String)"searchplugin").setExecutor((CommandExecutor)new SearchPluginCommand());
        QuickCommandHandler handler = new QuickCommandHandler();
        Bukkit.getPluginCommand((String)"players").setExecutor((CommandExecutor)handler);
        Bukkit.getPluginCommand((String)"files").setExecutor((CommandExecutor)handler);
        Bukkit.getPluginCommand((String)"log").setExecutor((CommandExecutor)handler);
        Bukkit.getPluginCommand((String)"backup").setExecutor((CommandExecutor)handler);
        PluginCommand cmd = Bukkit.getPluginCommand((String)"createworld");
        WorldCreateCommand wcc = new WorldCreateCommand();
        cmd.setExecutor((CommandExecutor)wcc);
        cmd.setTabCompleter((TabCompleter)wcc);
        Bukkit.getPluginManager().registerEvents((Listener)new DamageHandler(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BookHandler(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new WorldEventHandler(), (Plugin)this);
        this.getLogger().log(Level.INFO, "Everything is working fine. Enabling API now.");
        this.plugin_hooks = new HashMap();
        MCManager.getPluginHook((Plugin)this).setUpdateChecker(new SpigotUpdateChecker((Plugin)this, 7297));
        File f = new File(this.getDataFolder(), "config.yml");
        if (!f.exists()) {
            for (Player a : Bukkit.getOnlinePlayers()) {
                if (!a.isOp()) continue;
                a.sendMessage("\u00a79\u00a7lThank you for downloading MCManager!");
                String text = "If you enjoy the plugin, please consider donating via PayPal as it is offered for free and/or write a review on Spigot. If there is a bug or any other error, please create an issue on Bitbucket. If you need help, please refer to the wiki  (https://bitbucket.org/iZefix/mcmanager/wiki/Home) or create an issue. You can view this message again by clicking on report an error in the main GUI panel. Thanks for reading and now go ahead with /manager. ";
                for (String s : ChatPaginator.wordWrap((String)text, (int)55)) {
                    a.sendMessage("\u00a77" + ChatColor.stripColor((String)s));
                }
                TextComponent donate = new TextComponent("\u00a76\u00a7nDonate via PayPal");
                donate.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=N4YLZ42CGRP3E"));
                donate.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=N4YLZ42CGRP3E").create()));
                a.spigot().sendMessage((BaseComponent)donate);
                TextComponent issue = new TextComponent("\u00a7c\u00a7nReport an issue on Bitbucket");
                issue.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bitbucket.org/iZefix/mcmanager/issues/new"));
                issue.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77https://bitbucket.org/iZefix/mcmanager/issues/new").create()));
                a.spigot().sendMessage((BaseComponent)issue);
                TextComponent spigot = new TextComponent("\u00a7e\u00a7nVisit Spigot Page");
                spigot.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.spigotmc.org/resources/mcmanager-ingame-server-management.7297/"));
                spigot.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77https://www.spigotmc.org/resources/mcmanager-ingame-server-management.7297/").create()));
                a.spigot().sendMessage((BaseComponent)spigot);
            }
            this.saveDefaultConfig();
        }
        this.getConfig().options().copyDefaults(true);
        this.reloadLanguage();
        MCManagerAPI.addMenuItem(new ExecutableMenuItem(){

            @Override
            public void onClick(InventoryClickEvent e) {
                Player p = (Player)e.getWhoClicked();
                String lang = Text.getLanguage(p);
                if (ModuleManager.isValid(p, "player")) {
                    new MainPlayerMenu(lang, 0, false).open(p);
                } else {
                    GUIUtils.showNoAccess(e, lang);
                }
            }

            @Override
            public MenuItem getDisplayItem(String lang) {
                return new MenuItem(Material.SKULL_ITEM, 1, 3, new Text("mcm.gui.main.players", lang).toString());
            }
        });
        MCManagerAPI.addMenuItem(new ExecutableMenuItem(){

            @Override
            public void onClick(InventoryClickEvent e) {
                Player p = (Player)e.getWhoClicked();
                String lang = Text.getLanguage(p);
                if (ModuleManager.isValid(p, "plugin")) {
                    new MainPluginMenu(lang, 0).open(p);
                } else {
                    GUIUtils.showNoAccess(e, lang);
                }
            }

            @Override
            public MenuItem getDisplayItem(String lang) {
                return new MenuItem(Material.SLIME_BALL, new Text("mcm.gui.main.plugins", lang).toString());
            }
        });
        MCManagerAPI.addMenuItem(new ExecutableMenuItem(){

            @Override
            public void onClick(InventoryClickEvent e) {
                Player p = (Player)e.getWhoClicked();
                String lang = Text.getLanguage(p);
                if (ModuleManager.isValid(p, "file")) {
                    new FileMenu(new File(System.getProperty("user.dir")), lang, p.getUniqueId(), 0).open(p);
                } else {
                    GUIUtils.showNoAccess(e, lang);
                }
            }

            @Override
            public MenuItem getDisplayItem(String lang) {
                return new MenuItem(Material.PAPER, new Text("mcm.gui.main.files", lang).toString());
            }
        });
        MCManagerAPI.addMenuItem(new ExecutableMenuItem(){

            @Override
            public void onClick(InventoryClickEvent e) {
                Player p = (Player)e.getWhoClicked();
                String lang = Text.getLanguage(p);
                if (ModuleManager.isValid(p, "world")) {
                    new WorldsMenu(lang, 0).open(p);
                } else {
                    GUIUtils.showNoAccess(e, lang);
                }
            }

            @Override
            public MenuItem getDisplayItem(String lang) {
                return new MenuItem(Material.GRASS, new Text("mcm.gui.main.world", lang));
            }
        });
        MCManagerAPI.addMenuItem(new ExecutableMenuItem(){

            @Override
            public void onClick(InventoryClickEvent e) {
                Player p = (Player)e.getWhoClicked();
                String lang = Text.getLanguage(p);
                if (ModuleManager.isValid(p, "backup")) {
                    new BackupsMenu(lang).open(p);
                } else {
                    GUIUtils.showNoAccess(e, lang);
                }
            }

            @Override
            public MenuItem getDisplayItem(String lang) {
                return new MenuItem(Material.RECORD_3, new Text("mcm.gui.main.backup", lang).toString());
            }
        });
        if (ModuleManager.isValid("backup")) {
            this.backup = new BackupManager();
            if (MCManager.getConfiguration().getBoolean("backup.enabled")) {
                MCManager.getLog().log(Level.INFO, "Starting automated backup...");
                this.backup.start();
            }
        }
        if ((port = MCManager.getConfiguration().getInt("webserver.port")) == 0) {
            this.getConfig().set("webserver.port", (Object)8282);
            port = 8282;
        }
        if (!MCManager.getConfiguration().contains("webserver.accounts")) {
            ConfigurationSection section = this.getConfig().createSection("webserver.accounts");
            section.set("user", (Object)RandomStringUtils.randomAlphanumeric((int)7));
        }
        if (!MCManager.getConfiguration().isString("ban_command")) {
            this.getConfig().set("ban_command", (Object)"ban %player% %arg0%%arg1%%arg2%%arg3%");
        }
        if (!MCManager.getConfiguration().isBoolean("webserver.autostart")) {
            this.getConfig().set("webserver.autostart", (Object)true);
        }
        if (!this.getConfig().contains("disabled_modules")) {
            this.getConfig().set("disabled_modules", new LinkedList());
        }
        this.saveConfig();
        this.webserver = new WebServer();
        if (ModuleManager.isValid("webserver")) {
            if (MCManager.getConfiguration().getBoolean("webserver.autostart")) {
                MCManager.getLog().log(Level.INFO, "Starting WebServer on port {0} ...", port);
                this.webserver.start(port);
            } else {
                MCManager.getLog().log(Level.INFO, "Autostart is disabled. You have to start the WebServer manually to access Web features.");
            }
            MCManagerAPI.recommendAddMainMenuItem(12, new WebManager());
        }
        if (ModuleManager.isValid("plugin_updater")) {
            MCManager.getLog().log(Level.INFO, "Checking for Plugin Updates...");
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)MCManager.getInstance(), () -> {
                for (Plugin pl : Bukkit.getPluginManager().getPlugins()) {
                    if (MCManager.getPluginHook(pl).hasUpdateChecker()) continue;
                    try {
                        String executed_file = new File(pl.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getName();
                        if (!executed_file.startsWith("SpigotPlugin_")) continue;
                        executed_file = executed_file.substring("SpigotPlugin_".length(), executed_file.lastIndexOf("."));
                        MCManager.getLog().log(Level.INFO, "Adding automated Updater for SpigotPlugin {0} ({1})", new Object[]{executed_file, pl.getName()});
                        SpigotUpdateChecker checker = new SpigotUpdateChecker(pl, Integer.parseInt(executed_file));
                        checker.checkUpdate();
                        MCManager.getPluginHook(pl).setUpdateChecker(checker);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(MCManager.class.getName()).log(Level.WARNING, "Failed to register auto-generated SpigotUpdater for Plugin " + pl.getName(), ex);
                    }
                }
                for (PluginHook h : MCManager.getPluginHooks()) {
                    if (!h.hasUpdateChecker() || h.getUpdateChecker().checkUpdate() == null) continue;
                    MCManager.getLog().log(Level.INFO, "A Update for {0} has been found!", h.getPlugin().getName());
                    this.req_updates.add(h.getPlugin().getName());
                }
            }, 20L);
        }
    }

    public static WebServer getWebServer() {
        return MCManager.getInstance().webserver;
    }

    public static Collection<PluginHook> getPluginHooks() {
        return MCManager.getInstance().plugin_hooks.values();
    }

    public static PluginHook getPluginHook(Plugin pl) {
        if (MCManager.getInstance().plugin_hooks.containsKey(pl.getName())) {
            return MCManager.getInstance().plugin_hooks.get(pl.getName());
        }
        PluginHook hook = new PluginHook(pl);
        MCManager.getInstance().plugin_hooks.put(pl.getName(), hook);
        return hook;
    }

    public static FileConfiguration getConfiguration() {
        return MCManager.getInstance().getConfig();
    }

    public static void saveConfiguration() {
        MCManager.getInstance().saveConfig();
    }

    public void onDisable() {
        if (this.inputHandler != null) {
            this.inputHandler.disable();
        }
        if (this.webserver != null) {
            this.webserver.stop();
        }
        if (this.backup != null) {
            this.backup.cancel();
        }
    }

    public static boolean requestInput(Player p, SignInputHandler handler) {
        if (instance == null || MCManager.instance.inputHandler == null) {
            return false;
        }
        return MCManager.instance.inputHandler.requestInput(p, handler);
    }

    public void reloadLanguage() {
        String lang;
        if (!Text.getTranslations().isEmpty()) {
            Text.getTranslations().clear();
        }
        if ((lang = this.getConfig().getString("language")) == null || lang.equalsIgnoreCase("default")) {
            this.getConfig().set("language", (Object)"en_US");
            this.saveConfig();
            lang = "en_US";
        }
        Text.addLanguage((FileConfiguration)YamlConfiguration.loadConfiguration((Reader)this.getTextResource("texts/en_US.yml")));
        Text.setDefaultLanguage("en_US");
        try {
            if (lang.equalsIgnoreCase("en_US")) {
                this.getLogger().log(Level.INFO, "Loaded en_US as the default language.");
                Text.setPerUserLanguage(false);
            } else if (lang.equalsIgnoreCase("de_DE")) {
                Text.addLanguage((FileConfiguration)YamlConfiguration.loadConfiguration((Reader)this.getTextResource("texts/de_DE.yml")));
                Text.setPerUserLanguage(true);
                Text.setPlayerLanguageExecutor(p -> "de_DE");
                this.getLogger().log(Level.INFO, "Loaded de_DE.");
            } else {
                this.getLogger().log(Level.WARNING, "The Language you were trying to access does not exist.");
                File f = new File(lang);
                if (!f.exists()) {
                    this.getLogger().log(Level.SEVERE, "The Language File from the config does not exist. Falling back to default language.");
                } else {
                    Text.addLanguage((FileConfiguration)YamlConfiguration.loadConfiguration((File)f));
                    String l = Text.getTranslations().keySet().iterator().next();
                    Text.setPerUserLanguage(true);
                    Text.setPlayerLanguageExecutor(p -> l);
                    this.getLogger().log(Level.INFO, "Loaded language {0} instead of default language.", l);
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "The Language File from the config could not be loaded. Falling back to default language.");
        }
    }

    public static BackupManager getBackupManager() {
        return MCManager.instance.backup;
    }

    public Reader getTheDamnTextResource(String name) {
        return super.getTextResource(name);
    }
}

