/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.nomoblag.xseries.messages;

import com.zenya.nomoblag.xseries.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class ActionBar {
    private static final boolean SPIGOT;
    private static final MethodHandle CHAT_COMPONENT_TEXT;
    private static final MethodHandle PACKET_PLAY_OUT_CHAT;
    private static final Object CHAT_MESSAGE_TYPE;

    private ActionBar() {
    }

    public static void sendActionBar(@Nonnull Player player, @Nullable String message) {
        Objects.requireNonNull(player, "Cannot send action bar to null player");
        if (SPIGOT) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
            return;
        }
        try {
            Object component = CHAT_COMPONENT_TEXT.invoke(message);
            Object packet = ReflectionUtils.supports(16) ? PACKET_PLAY_OUT_CHAT.invoke(component, CHAT_MESSAGE_TYPE, player.getUniqueId()) : PACKET_PLAY_OUT_CHAT.invoke(component, CHAT_MESSAGE_TYPE);
            ReflectionUtils.sendPacket(player, packet);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void sendPlayersActionBar(@Nullable String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ActionBar.sendActionBar(player, message);
        }
    }

    public static void clearActionBar(@Nonnull Player player) {
        ActionBar.sendActionBar(player, " ");
    }

    public static void clearPlayersActionBar() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ActionBar.clearActionBar(player);
        }
    }

    public static void sendActionBarWhile(@Nonnull JavaPlugin plugin, final @Nonnull Player player, final @Nullable String message, final @Nonnull Callable<Boolean> callable) {
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!((Boolean)callable.call()).booleanValue()) {
                        this.cancel();
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ActionBar.sendActionBar(player, message);
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 40L);
    }

    public static void sendActionBarWhile(@Nonnull JavaPlugin plugin, final @Nonnull Player player, final @Nullable Callable<String> message, final @Nonnull Callable<Boolean> callable) {
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!((Boolean)callable.call()).booleanValue()) {
                        this.cancel();
                        return;
                    }
                    ActionBar.sendActionBar(player, (String)message.call());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 40L);
    }

    public static void sendActionBar(@Nonnull JavaPlugin plugin, final @Nonnull Player player, final @Nullable String message, final long duration) {
        if (duration < 1L) {
            return;
        }
        new BukkitRunnable(){
            long repeater;
            {
                this.repeater = duration;
            }

            public void run() {
                ActionBar.sendActionBar(player, message);
                this.repeater -= 40L;
                if (this.repeater - 40L < -20L) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 0L, 40L);
    }

    static {
        boolean exists = false;
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            exists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        SPIGOT = exists;
        MethodHandle packet = null;
        MethodHandle chatComp = null;
        Byte chatMsgType = null;
        if (!SPIGOT) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> packetPlayOutChatClass = ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutChat");
            Class<?> iChatBaseComponentClass = ReflectionUtils.getNMSClass("network.chat", "IChatBaseComponent");
            try {
                Class<?> chatMessageTypeClass = Class.forName(ReflectionUtils.NMS + (ReflectionUtils.supports(17) ? "network.chat" : "") + "ChatMessageType");
                MethodType type = ReflectionUtils.supports(16) ? MethodType.methodType(Void.TYPE, iChatBaseComponentClass, chatMessageTypeClass, UUID.class) : MethodType.methodType(Void.TYPE, iChatBaseComponentClass, chatMessageTypeClass);
                for (Object obj : chatMessageTypeClass.getEnumConstants()) {
                    String name = obj.toString();
                    if (!name.equals("GAME_INFO") && !name.equals("c") && !name.equalsIgnoreCase("ACTION_BAR")) continue;
                    chatMsgType = obj;
                    break;
                }
                Class<?> chatComponentTextClass = ReflectionUtils.getNMSClass("network.chat", "ChatComponentText");
                chatComp = lookup.findConstructor(chatComponentTextClass, MethodType.methodType(Void.TYPE, String.class));
                packet = lookup.findConstructor(packetPlayOutChatClass, type);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ignored) {
                try {
                    chatMsgType = 2;
                    Class<?> chatComponentTextClass = ReflectionUtils.getNMSClass("ChatComponentText");
                    chatComp = lookup.findConstructor(chatComponentTextClass, MethodType.methodType(Void.TYPE, String.class));
                    packet = lookup.findConstructor(packetPlayOutChatClass, MethodType.methodType(Void.TYPE, iChatBaseComponentClass, Byte.TYPE));
                }
                catch (IllegalAccessException | NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
            }
        }
        CHAT_MESSAGE_TYPE = chatMsgType;
        CHAT_COMPONENT_TEXT = chatComp;
        PACKET_PLAY_OUT_CHAT = packet;
    }
}

