/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.nomoblag.util;

import com.zenya.nomoblag.xseries.XMaterial;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.block.CreatureSpawner;

public class SpawnerUtils {
    private static ArrayList<CreatureSpawner> getNearbySpawners(Location loc, double maxDist) {
        ArrayList<CreatureSpawner> spawners = new ArrayList<CreatureSpawner>();
        double minX = loc.getX() - maxDist;
        double maxX = loc.getX() + maxDist;
        double minY = loc.getY() - maxDist;
        double maxY = loc.getY() + maxDist;
        double minZ = loc.getZ() - maxDist;
        double maxZ = loc.getZ() + maxDist;
        for (double x = minX; x <= maxX; x += 1.0) {
            for (double y = minY; y <= maxY; y += 1.0) {
                for (double z = minZ; z <= maxZ; z += 1.0) {
                    Location checkLoc = new Location(loc.getWorld(), x, y, z);
                    if (loc.equals((Object)checkLoc) || !loc.getWorld().getBlockAt(checkLoc).getType().equals((Object)XMaterial.SPAWNER.parseMaterial())) continue;
                    spawners.add((CreatureSpawner)loc.getWorld().getBlockAt(checkLoc).getState());
                }
            }
        }
        return spawners;
    }

    public static CreatureSpawner getNearestSpawner(Location loc, double maxDist) {
        ArrayList<CreatureSpawner> spawners = SpawnerUtils.getNearbySpawners(loc, maxDist);
        if (spawners == null || spawners.size() == 0) {
            return null;
        }
        CreatureSpawner closest = spawners.get(0);
        double minDist = loc.distance(closest.getLocation());
        for (CreatureSpawner spawner : spawners) {
            double checkDist = loc.distance(spawner.getLocation());
            if (!(checkDist < minDist)) continue;
            minDist = checkDist;
            closest = spawner;
        }
        return closest;
    }
}

