/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.nomoblag.scheduler;

import com.zenya.nomoblag.NoMobLag;
import com.zenya.nomoblag.scheduler.NMLTask;
import com.zenya.nomoblag.scheduler.TaskKey;
import java.util.ArrayList;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TrackTPSTask
implements NMLTask {
    private static TrackTPSTask nmlTask;
    private BukkitTask bukkitTask;
    private float instTps = 0.0f;
    private float avgTps = 0.0f;

    public TrackTPSTask() {
        this.runTask();
    }

    @Override
    public TaskKey getKey() {
        return TaskKey.TRACK_TPS_TASK;
    }

    @Override
    public void runTask() {
        this.bukkitTask = new BukkitRunnable(){
            long start = 0L;
            long now = 0L;

            public void run() {
                this.start = this.now;
                this.now = System.currentTimeMillis();
                long tdiff = this.now - this.start;
                if (tdiff > 0L) {
                    TrackTPSTask.this.instTps = 1000L / tdiff;
                }
            }
        }.runTaskTimer((Plugin)NoMobLag.getInstance(), 0L, 1L);
        new BukkitRunnable(){
            ArrayList<Float> tpsList = new ArrayList();

            public void run() {
                Float totalTps = Float.valueOf(0.0f);
                this.tpsList.add(Float.valueOf(TrackTPSTask.this.instTps));
                if (this.tpsList.size() >= 15) {
                    this.tpsList.remove(0);
                }
                for (Float f : this.tpsList) {
                    totalTps = Float.valueOf(totalTps.floatValue() + f.floatValue());
                }
                TrackTPSTask.this.avgTps = totalTps.floatValue() / (float)this.tpsList.size();
            }
        }.runTaskTimerAsynchronously((Plugin)NoMobLag.getInstance(), 20L, 20L);
    }

    @Override
    public BukkitTask getTask() {
        return this.bukkitTask;
    }

    public float getInstantTps() {
        if (this.instTps > 20.0f) {
            this.instTps = 20.0f;
        }
        return this.instTps;
    }

    public float getAverageTps() {
        if (this.avgTps > 20.0f) {
            this.avgTps = 20.0f;
        }
        return this.avgTps;
    }

    public static TrackTPSTask getInstance() {
        if (nmlTask == null) {
            nmlTask = new TrackTPSTask();
        }
        return nmlTask;
    }
}

