/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.nomoblag.scheduler;

import com.zenya.nomoblag.NoMobLag;
import com.zenya.nomoblag.event.PlayerChunkChangeEvent;
import com.zenya.nomoblag.scheduler.NMLTask;
import com.zenya.nomoblag.scheduler.TaskKey;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TrackPlayerTask
implements NMLTask {
    private static TrackPlayerTask nmlTask;
    private BukkitTask task;
    private CompletableFuture<HashMap<Player, Location>> playerCoords = CompletableFuture.supplyAsync(() -> new HashMap());

    public TrackPlayerTask() {
        this.runTask();
    }

    @Override
    public TaskKey getKey() {
        return TaskKey.TRACK_PLAYER_TASK;
    }

    @Override
    public void runTask() {
        this.task = new BukkitRunnable(){

            public void run() {
                TrackPlayerTask.this.playerCoords.thenAcceptAsync(coordMap -> {
                    if (Bukkit.getOnlinePlayers() != null && Bukkit.getOnlinePlayers().size() != 0) {
                        for (final Player player : Bukkit.getOnlinePlayers()) {
                            if (player.getLocation().getChunk().getX() == coordMap.getOrDefault(player, new Location(player.getWorld(), 0.0, 0.0, 0.0)).getChunk().getX() && player.getLocation().getChunk().getZ() == coordMap.getOrDefault(player, new Location(player.getWorld(), 0.0, 0.0, 0.0)).getChunk().getZ()) continue;
                            new BukkitRunnable(){

                                public void run() {
                                    Bukkit.getPluginManager().callEvent((Event)new PlayerChunkChangeEvent(player));
                                }
                            }.runTask((Plugin)NoMobLag.getInstance());
                            coordMap.put(player, player.getLocation());
                        }
                    }
                });
            }
        }.runTaskTimerAsynchronously((Plugin)NoMobLag.getInstance(), 0L, 10L);
        BukkitTask task2 = new BukkitRunnable(){

            public void run() {
                TrackPlayerTask.this.playerCoords.thenAcceptAsync(coordMap -> {
                    if (Bukkit.getOnlinePlayers() != null && Bukkit.getOnlinePlayers().size() != 0) {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            if (coordMap.containsKey(player)) continue;
                            coordMap.put(player, new Location(player.getWorld(), 0.0, 0.0, 0.0));
                        }
                    }
                });
            }
        }.runTaskTimerAsynchronously((Plugin)NoMobLag.getInstance(), 0L, 20L);
        BukkitTask task3 = new BukkitRunnable(){

            public void run() {
                TrackPlayerTask.this.playerCoords.thenAcceptAsync(coordMap -> {
                    if (Bukkit.getOnlinePlayers() != null && Bukkit.getOnlinePlayers().size() != 0) {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            coordMap.put(player, player.getLocation());
                        }
                    }
                });
            }
        }.runTaskTimerAsynchronously((Plugin)NoMobLag.getInstance(), 0L, 100L);
        BukkitTask task4 = new BukkitRunnable(){

            public void run() {
                TrackPlayerTask.this.playerCoords.thenAcceptAsync(coordMap -> {
                    if (Bukkit.getOnlinePlayers() != null && Bukkit.getOnlinePlayers().size() != 0) {
                        if (coordMap.keySet() != null && coordMap.keySet().size() != 0) {
                            for (Player player : coordMap.keySet()) {
                                if (Bukkit.getOnlinePlayers().contains(player)) continue;
                                coordMap.remove(player);
                            }
                        }
                    } else {
                        coordMap.clear();
                    }
                });
            }
        }.runTaskTimerAsynchronously((Plugin)NoMobLag.getInstance(), 0L, 200L);
    }

    @Override
    public BukkitTask getTask() {
        return this.task;
    }

    public static TrackPlayerTask getInstance() {
        if (nmlTask == null) {
            nmlTask = new TrackPlayerTask();
        }
        return nmlTask;
    }
}

