/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.nomoblag.file;

import com.zenya.nomoblag.NoMobLag;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.FileUtil;

public class MessagesManager {
    private int messagesVersion = 1;
    private boolean resetMessages = false;
    private List<String> ignoredNodes = new ArrayList<String>(){
        {
            this.add("messages-version");
        }
    };
    private List<String> replaceNodes = new ArrayList<String>(){};
    private static MessagesManager messagesManager;
    private Plugin plugin = NoMobLag.getInstance();
    private FileConfiguration origMessages = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.plugin.getResource("messages.yml")));
    private File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
    private FileConfiguration messages;

    public MessagesManager() throws IOException {
        if (!this.getMessagesExists()) {
            this.origMessages.save(this.messagesFile);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        if (this.getMessagesVersion() > this.messagesVersion) {
            this.resetMessages = true;
        }
        if (this.getMessagesVersion() != this.messagesVersion) {
            File oldMessagesFile = new File(this.plugin.getDataFolder(), "messages.yml.v" + String.valueOf(this.getMessagesVersion()));
            FileUtil.copy((File)this.messagesFile, (File)oldMessagesFile);
            YamlConfiguration oldMessages = YamlConfiguration.loadConfiguration((File)oldMessagesFile);
            this.messagesFile.delete();
            this.origMessages.save(this.messagesFile);
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
            this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
            if (!this.resetMessages) {
                for (String node : oldMessages.getKeys(true)) {
                    if (this.ignoredNodes.contains(node) || oldMessages.getKeys(true).contains(node + ".")) continue;
                    if (this.replaceNodes.contains(node)) {
                        this.messages.set(node, null);
                        this.messages.createSection(node);
                    }
                    this.messages.set(node, oldMessages.get(node));
                }
            }
            this.messages.save(this.messagesFile);
        }
    }

    private boolean getMessagesExists() {
        return this.messagesFile.exists();
    }

    private int getMessagesVersion() {
        return this.getInt("messages-version");
    }

    public String getString(String node) {
        String val;
        try {
            val = this.messages.getString(node);
        }
        catch (Exception e) {
            val = "";
        }
        return val;
    }

    private int getInt(String node) {
        int val;
        try {
            val = this.messages.getInt(node);
        }
        catch (Exception e) {
            val = 0;
        }
        return val;
    }

    public static void reloadMessages() {
        messagesManager = null;
        MessagesManager.getInstance();
    }

    public static MessagesManager getInstance() {
        if (messagesManager == null) {
            try {
                messagesManager = new MessagesManager();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return messagesManager;
    }
}

