/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.nomoblag.file;

import com.zenya.nomoblag.NoMobLag;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.FileUtil;

public class ConfigManager {
    private int configVersion = 7;
    private boolean resetConfig = false;
    private List<String> ignoredNodes = new ArrayList<String>(){
        {
            this.add("config-version");
        }
    };
    private List<String> replaceNodes = new ArrayList<String>(){
        {
            this.add("mob-spawning.spawn-chance-at-playercount");
            this.add("mob-spawning.spawnreason-tps-block");
        }
    };
    private static ConfigManager configManager;
    private Plugin plugin = NoMobLag.getInstance();
    private FileConfiguration origConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.plugin.getResource("config.yml")));
    private File configFile = new File(this.plugin.getDataFolder(), "config.yml");
    private FileConfiguration config;

    public ConfigManager() throws IOException {
        if (!this.getConfigExists()) {
            this.plugin.saveDefaultConfig();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        if (this.getConfigVersion() > this.configVersion) {
            this.resetConfig = true;
        }
        if (this.getConfigVersion() != this.configVersion) {
            File oldConfigFile = new File(this.plugin.getDataFolder(), "config.yml.v" + String.valueOf(this.getConfigVersion()));
            FileUtil.copy((File)this.configFile, (File)oldConfigFile);
            YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)oldConfigFile);
            this.configFile.delete();
            this.plugin.saveDefaultConfig();
            this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
            this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
            if (!this.resetConfig) {
                for (String node : oldConfig.getKeys(true)) {
                    if (this.ignoredNodes.contains(node)) continue;
                    if (this.replaceNodes.contains(node)) {
                        this.config.set(node, null);
                    }
                    if (oldConfig.getConfigurationSection(node) != null && oldConfig.getConfigurationSection(node).getKeys(false) != null && oldConfig.getConfigurationSection(node).getKeys(false).size() != 0) continue;
                    this.config.set(node, oldConfig.get(node));
                }
            }
            this.config.save(this.configFile);
        }
    }

    private boolean getConfigExists() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        return configFile.exists();
    }

    private int getConfigVersion() {
        return this.getInt("config-version");
    }

    public String getString(String node) {
        String val;
        try {
            val = this.config.getString(node);
        }
        catch (Exception e) {
            val = "";
        }
        return val;
    }

    public int getInt(String node) {
        int val;
        try {
            val = this.config.getInt(node);
        }
        catch (Exception e) {
            val = 0;
        }
        return val;
    }

    public double getDouble(String node) {
        double val;
        try {
            val = this.config.getDouble(node);
        }
        catch (Exception e) {
            val = 0.0;
        }
        return val;
    }

    public boolean getBool(String node) {
        boolean val;
        try {
            val = this.config.getBoolean(node);
        }
        catch (Exception e) {
            val = false;
        }
        return val;
    }

    public ArrayList<String> getKeys(String node) {
        ArrayList<String> val = new ArrayList<String>();
        try {
            for (String key : this.config.getConfigurationSection(node).getKeys(false)) {
                val.add(key);
            }
        }
        catch (Exception e) {
            val = new ArrayList();
            e.printStackTrace();
        }
        return val;
    }

    public ArrayList<String> getList(String node) {
        ArrayList<String> val = new ArrayList<String>();
        try {
            for (String s : this.config.getStringList(node)) {
                val.add(s);
            }
        }
        catch (Exception e) {
            val = new ArrayList();
            e.printStackTrace();
        }
        return val;
    }

    public boolean listContains(String node, String item) {
        ArrayList<String> list = this.getList(node);
        return list != null && list.size() != 0 && list.contains(item);
    }

    public static void reloadConfig() {
        configManager = null;
        ConfigManager.getInstance();
    }

    public static ConfigManager getInstance() {
        if (configManager == null) {
            try {
                configManager = new ConfigManager();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return configManager;
    }
}

