/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.nomoblag.event;

import java.util.ArrayList;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PlayerChunkChangeEvent
extends Event
implements Cancellable {
    private boolean isCancelled = false;
    private Player player;
    private static final HandlerList handlers = new HandlerList();

    public PlayerChunkChangeEvent(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Chunk getChunk() {
        return this.player.getLocation().getChunk();
    }

    public World getWorld() {
        return this.player.getWorld();
    }

    public Chunk getPreviousChunk() {
        double relativeX = this.player.getVelocity().getX();
        double relativeZ = this.player.getVelocity().getZ();
        relativeX = relativeX > 0.0 ? 1.0 : -1.0;
        relativeZ = relativeZ > 0.0 ? 1.0 : -1.0;
        return this.getChunk().getWorld().getChunkAt(this.getChunk().getX() + (int)relativeX, this.getChunk().getZ() + (int)relativeZ);
    }

    public Chunk[] getNearbyChunks(int radius) {
        ArrayList<Chunk> nearbyChunks = new ArrayList<Chunk>();
        int cX = this.getChunk().getX();
        int cZ = this.getChunk().getZ();
        for (int x = cX - radius; x <= cX + radius; ++x) {
            for (int z = cZ - radius; z <= cZ + radius; ++z) {
                nearbyChunks.add(this.getChunk().getWorld().getChunkAt(x, z));
            }
        }
        return nearbyChunks.toArray(new Chunk[nearbyChunks.size()]);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

