/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.nomoblag.event;

import com.zenya.nomoblag.NoMobLag;
import com.zenya.nomoblag.event.PlayerChunkChangeEvent;
import com.zenya.nomoblag.file.ConfigManager;
import com.zenya.nomoblag.file.MessagesManager;
import com.zenya.nomoblag.scheduler.DespawnEntityTask;
import com.zenya.nomoblag.scheduler.FreezeEntityTask;
import com.zenya.nomoblag.scheduler.SetCollidableTask;
import com.zenya.nomoblag.scheduler.TrackTPSTask;
import com.zenya.nomoblag.util.ChatUtils;
import com.zenya.nomoblag.util.LocationUtils;
import com.zenya.nomoblag.util.MetaUtils;
import com.zenya.nomoblag.util.SpawnerUtils;
import com.zenya.nomoblag.xseries.XMaterial;
import com.zenya.nomoblag.xseries.particles.ParticleDisplay;
import com.zenya.nomoblag.xseries.particles.XParticle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Listeners
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCreatureSpawnEvent(CreatureSpawnEvent e) {
        if (!(e.getEntity() instanceof Creature)) {
            return;
        }
        this.handleSpawnChance(e);
        this.handleSpawnTreshold(e);
        this.handleSpawners(e);
        this.handleMobCollisions(e);
        this.handleMobFreezing(e);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityTargetCreatureEvent(EntityTargetLivingEntityEvent e) {
        if (!MetaUtils.hasMeta(e.getEntity(), "no-endermite-aggro")) {
            return;
        }
        if (e.getTarget().getType().equals((Object)EntityType.valueOf((String)"ENDERMITE"))) {
            e.setTarget(null);
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockPlaceEvent(BlockPlaceEvent e) {
        Location blockLoc;
        CreatureSpawner nearestSpawner;
        if (!ConfigManager.getInstance().getBool("spawners.enabled")) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (e.getBlockPlaced().getType().equals((Object)XMaterial.SPAWNER.parseMaterial()) && (nearestSpawner = SpawnerUtils.getNearestSpawner(blockLoc = e.getBlock().getLocation(), ConfigManager.getInstance().getInt("spawners.minimum-spawner-distance"))) != null) {
            ChatUtils.sendMessage(e.getPlayer(), MessagesManager.getInstance().getString("spawners-too-close"));
            XParticle.line(LocationUtils.getCentre(blockLoc), LocationUtils.getCentre(nearestSpawner.getLocation()), 0.1 * blockLoc.distance(nearestSpawner.getLocation()), ParticleDisplay.colored(blockLoc, Color.RED, 1.0f));
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractEntityEvent(PlayerInteractEntityEvent e) {
        if (!ConfigManager.getInstance().getBool("mob-freezing.enable-freezing")) {
            return;
        }
        if (!ConfigManager.getInstance().getBool("mob-freezing.enable-ai-on-interact")) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (!(e.getRightClicked() instanceof Creature)) {
            return;
        }
        Creature entity = (Creature)e.getRightClicked();
        for (String nbt : ConfigManager.getInstance().getList("mob-freezing.no-ai-tags")) {
            if (!entity.hasMetadata(nbt)) continue;
            return;
        }
        if (!ConfigManager.getInstance().listContains("mob-freezing.freeze-bypass-mobs", entity.getType().name())) {
            new FreezeEntityTask((LivingEntity)entity);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamageEvent(EntityDamageEvent e) {
        if (!ConfigManager.getInstance().getBool("mob-freezing.enable-freezing")) {
            return;
        }
        if (!ConfigManager.getInstance().getBool("mob-freezing.enable-ai-on-interact")) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (!(e.getEntity() instanceof Creature)) {
            return;
        }
        Creature entity = (Creature)e.getEntity();
        for (String nbt : ConfigManager.getInstance().getList("mob-freezing.no-ai-tags")) {
            if (!entity.hasMetadata(nbt)) continue;
            return;
        }
        if (!ConfigManager.getInstance().listContains("mob-freezing.freeze-bypass-mobs", entity.getType().name())) {
            new FreezeEntityTask((LivingEntity)entity);
        }
    }

    @EventHandler
    public void onProjectileLaunchEvent(ProjectileLaunchEvent e) {
        final Projectile proj = e.getEntity();
        final int cancelAfter = 100;
        new BukkitRunnable(){
            int count = 0;

            public void run() {
                ++this.count;
                if (this.count >= cancelAfter) {
                    this.cancel();
                }
                if (proj.isDead() || proj.isOnGround()) {
                    this.cancel();
                }
                for (Entity ent : proj.getNearbyEntities(5.0, 5.0, 5.0)) {
                    if (!(ent instanceof Creature)) continue;
                    try {
                        new SetCollidableTask((Creature)ent);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {}
                }
            }
        }.runTaskTimer((Plugin)NoMobLag.getInstance(), 0L, 1L);
    }

    @EventHandler
    public void onPlayerChunkChangeEvent(PlayerChunkChangeEvent e) {
        final ArrayList<Creature> mobs = new ArrayList<Creature>();
        for (Chunk chunk : e.getNearbyChunks(1)) {
            for (Entity ent : chunk.getEntities()) {
                if (!(ent instanceof Creature)) continue;
                mobs.add((Creature)ent);
            }
        }
        if (mobs == null || mobs.size() == 0) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                for (Creature mob : mobs) {
                    if (!ConfigManager.getInstance().listContains("mob-collisions.force-collision-mobs", mob.getType().name())) continue;
                    try {
                        mob.setCollidable(!ConfigManager.getInstance().getBool("mob-collisions.disable-mob-collision"));
                    }
                    catch (NoSuchMethodError noSuchMethodError) {}
                }
            }
        }.runTaskAsynchronously((Plugin)NoMobLag.getInstance());
        if (!ConfigManager.getInstance().getBool("mob-freezing.enable-freezing")) {
            new BukkitRunnable(){

                public void run() {
                    for (Creature mob : mobs) {
                        mob.setAI(true);
                    }
                }
            }.runTaskAsynchronously((Plugin)NoMobLag.getInstance());
        } else {
            if (!ConfigManager.getInstance().getBool("mob-freezing.enable-ai-on-chunk-load")) {
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    block0: for (Creature mob : mobs) {
                        for (String nbt : ConfigManager.getInstance().getList("mob-freezing.no-ai-tags")) {
                            if (!mob.hasMetadata(nbt)) continue;
                            continue block0;
                        }
                        if (ConfigManager.getInstance().listContains("mob-freezing.freeze-bypass-mobs", mob.getType().name())) continue;
                        new FreezeEntityTask((LivingEntity)mob);
                    }
                }
            }.runTask((Plugin)NoMobLag.getInstance());
        }
    }

    public void handleSpawnChance(CreatureSpawnEvent e) {
        ArrayList<String> keyList;
        int spawnChance;
        Random randObj = new Random();
        int tps = Math.round(TrackTPSTask.getInstance().getAverageTps());
        int playercount = Bukkit.getOnlinePlayers().size();
        if (e.isCancelled()) {
            return;
        }
        boolean canBlock = false;
        if (ConfigManager.getInstance().getList("mob-spawning.spawnreason-tps-block") != null && ConfigManager.getInstance().getList("mob-spawning.spawnreason-tps-block").size() != 0) {
            for (String spawnReason : ConfigManager.getInstance().getList("mob-spawning.spawnreason-tps-block")) {
                if (!e.getSpawnReason().name().equals(spawnReason.toUpperCase())) continue;
                canBlock = true;
            }
        }
        if (!canBlock) {
            return;
        }
        int randNum = randObj.nextInt(100) + 1;
        if (randNum > (spawnChance = ConfigManager.getInstance().getInt("mob-spawning.spawn-chance-at-tps." + String.valueOf(tps)))) {
            e.setCancelled(true);
        }
        if ((keyList = ConfigManager.getInstance().getKeys("mob-spawning.spawn-chance-at-playercount")) != null && keyList.size() != 0) {
            int smallestDiff = Math.abs(Integer.valueOf((String)keyList.get(0)) - playercount);
            int smallestIndex = 0;
            for (int i = 1; i < keyList.size(); ++i) {
                int difference = Math.abs(Integer.valueOf((String)keyList.get(i)) - playercount);
                if (difference >= smallestDiff) continue;
                smallestDiff = difference;
                smallestIndex = i;
            }
            randNum = randObj.nextInt(100) + 1;
            if (randNum > (spawnChance = ConfigManager.getInstance().getInt("mob-spawning.spawn-chance-at-playercount." + String.valueOf(keyList.get(smallestIndex))))) {
                e.setCancelled(true);
            }
        }
    }

    public void handleSpawnTreshold(CreatureSpawnEvent e) {
        int tps = Math.round(TrackTPSTask.getInstance().getAverageTps());
        if (e.isCancelled()) {
            return;
        }
        if (tps > ConfigManager.getInstance().getInt("spawn-treshold.tps-treshold")) {
            return;
        }
        if (ConfigManager.getInstance().getBool("spawn-treshold.disable-breeding") && e.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.BREEDING)) {
            e.setCancelled(true);
            return;
        }
        if (ConfigManager.getInstance().getBool("spawn-treshold.disable-raiding")) {
            try {
                if (e.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.RAID)) {
                    e.setCancelled(true);
                }
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            return;
        }
        if (ConfigManager.getInstance().getBool("spawn-treshold.farms.block-spawner-farm") && e.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER)) {
            e.setCancelled(true);
            return;
        }
        if (ConfigManager.getInstance().getBool("spawn-treshold.farms.block-portal-farm") && e.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.NETHER_PORTAL)) {
            try {
                if (e.getEntity().getType().equals((Object)EntityType.valueOf((String)"DROWNED"))) {
                    e.setCancelled(true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                if (e.getEntity().getType().equals((Object)EntityType.valueOf((String)"PIG_ZOMBIE"))) {
                    e.setCancelled(true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                if (e.getEntity().getType().equals((Object)EntityType.valueOf((String)"ZOGLIN"))) {
                    e.setCancelled(true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return;
        }
        if (ConfigManager.getInstance().getBool("spawn-treshold.farms.block-pigman-farm") && e.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.REINFORCEMENTS) && e.getEntity().getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            try {
                if (e.getEntity().getType().equals((Object)EntityType.valueOf((String)"PIG_ZOMBIE"))) {
                    e.setCancelled(true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                if (e.getEntity().getType().equals((Object)EntityType.valueOf((String)"ZOGLIN"))) {
                    e.setCancelled(true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return;
        }
        if (ConfigManager.getInstance().getBool("spawn-treshold.farms.block-enderman-farm") && e.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.NATURAL) && e.getEntity().getWorld().getEnvironment().equals((Object)World.Environment.THE_END) && e.getEntity().getType().equals((Object)EntityType.valueOf((String)"ENDERMAN"))) {
            MetaUtils.setMeta((Entity)e.getEntity(), "no-endermite-aggro", true);
            return;
        }
    }

    public void handleSpawners(final CreatureSpawnEvent e) {
        if (!ConfigManager.getInstance().getBool("spawners.enabled")) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (!e.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER)) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                CreatureSpawner spawner = SpawnerUtils.getNearestSpawner(e.getLocation(), 4.0);
                if (spawner == null) {
                    return;
                }
                try {
                    spawner.setSpawnRange(4);
                    spawner.setRequiredPlayerRange(ConfigManager.getInstance().getInt("spawners.activation-range"));
                    spawner.setSpawnCount(1);
                    spawner.setMinSpawnDelay((int)Math.ceil(1200 / ConfigManager.getInstance().getInt("spawners.max-mobs-per-minute")));
                    spawner.setMaxSpawnDelay((int)Math.ceil(1200 / ConfigManager.getInstance().getInt("spawners.max-mobs-per-minute")));
                }
                catch (NoSuchMethodError exc) {
                    spawner.setDelay((int)Math.ceil(1200 / ConfigManager.getInstance().getInt("spawners.max-mobs-per-minute")));
                }
            }
        }.runTask((Plugin)NoMobLag.getInstance());
        if (ConfigManager.getInstance().getInt("spawners.mob-despawn-rate") < 0) {
            return;
        }
        Creature entity = (Creature)e.getEntity();
        new DespawnEntityTask((LivingEntity)entity);
    }

    public void handleMobCollisions(CreatureSpawnEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!ConfigManager.getInstance().getBool("mob-collisions.disable-mob-collision")) {
            return;
        }
        Creature entity = (Creature)e.getEntity();
        if (ConfigManager.getInstance().listContains("mob-collisions.force-collision-mobs", entity.getType().name())) {
            try {
                entity.setCollidable(false);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }

    public void handleMobFreezing(CreatureSpawnEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!ConfigManager.getInstance().getBool("mob-freezing.enable-freezing")) {
            return;
        }
        if (ConfigManager.getInstance().getInt("mob-freezing.disable-ai-after") < 0) {
            return;
        }
        Creature entity = (Creature)e.getEntity();
        for (String nbt : ConfigManager.getInstance().getList("mob-freezing.no-ai-tags")) {
            if (!entity.hasMetadata(nbt)) continue;
            return;
        }
        if (!ConfigManager.getInstance().listContains("mob-freezing.freeze-bypass-mobs", entity.getType().name())) {
            new FreezeEntityTask((LivingEntity)entity);
        }
    }
}

