/*
 * Decompiled with CFR 0.152.
 */
package com.r1ckp1ckle.pickaxecommands.utils;

import com.r1ckp1ckle.pickaxecommands.PickaxeCommandsCore;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationUtils {
    private PickaxeCommandsCore pickaxeCommandsCore;
    private File configFile;
    private FileConfiguration config;

    public ConfigurationUtils(PickaxeCommandsCore pickaxeCommandsCore) {
        this.pickaxeCommandsCore = pickaxeCommandsCore;
        this.initConfig();
    }

    private void initConfig() {
        if (!this.pickaxeCommandsCore.getDataFolder().exists()) {
            this.pickaxeCommandsCore.getDataFolder().mkdirs();
        }
        this.configFile = new File(this.pickaxeCommandsCore.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            this.pickaxeCommandsCore.saveResource("config.yml", false);
        }
        this.config = new YamlConfiguration();
        try {
            this.config.load(this.configFile);
        }
        catch (Exception e) {
            this.pickaxeCommandsCore.getLogger().log(Level.SEVERE, "Failed to load plugin files.");
            this.pickaxeCommandsCore.getLogger().log(Level.SEVERE, "Error: " + e.getMessage());
        }
    }

    public void reloadFiles() {
        try {
            this.config.load(this.configFile);
        }
        catch (Exception e) {
            this.pickaxeCommandsCore.getLogger().log(Level.SEVERE, "Failed to load plugin files.");
            this.pickaxeCommandsCore.getLogger().log(Level.SEVERE, "Error: " + e.getMessage());
        }
    }

    public void saveFiles() {
        try {
            this.config.save(this.configFile);
        }
        catch (Exception e) {
            this.pickaxeCommandsCore.getLogger().log(Level.SEVERE, "Failed to save plugin files.");
            this.pickaxeCommandsCore.getLogger().log(Level.SEVERE, "Error: " + e.getMessage());
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

