/*
 * Decompiled with CFR 0.152.
 */
package main.customitem.Cmds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import main.customitem.File.Config;
import main.customitem.File.Items;
import main.customitem.File.ItemsInHand;
import main.customitem.Main;
import main.customitem.Utils.Utils;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Command
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(Utils.color("&6&m-------------------------------------&r\n&a /" + label + " get <Id> <Amount> &7> &fGet Item\n&a /" + label + " give <Player> <Id> <Amount> &7> &fGive Items\n&a /" + label + " reload &7> &fReload files\n&a /" + label + " hand &7> &fCheck items in hand\n&6&m-------------------------------------&r"));
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("reload")) {
                Config.reload();
                Items.reloadConfig();
                ItemsInHand.reloadConfig();
                sender.sendMessage(Utils.color(Config.get().getString("cmd_reload")));
                return true;
            }
            if (args[0].equalsIgnoreCase("hand")) {
                Player p = (Player)sender;
                if (p.getItemInHand().getAmount() == 0) {
                    sender.sendMessage(Utils.color(Config.get().getString("cmd_noiteminhand")));
                    return true;
                }
                ItemStack heldItem = p.getItemInHand();
                UUID uuid = UUID.randomUUID();
                p.sendMessage(Utils.color("&7&m&l======&r &a&lStart &7&m&l======\n&3ID &r: " + heldItem.getType()));
                ItemsInHand.getConfig().set(uuid + ".Id", (Object)String.valueOf(Material.getMaterial((String)String.valueOf(heldItem.getType()))));
                if (heldItem.getDurability() != 0) {
                    p.sendMessage(Utils.color("&3Durability &r: " + heldItem.getDurability()));
                    ItemsInHand.getConfig().set(uuid + ".Durability", (Object)heldItem.getDurability());
                }
                if (heldItem.getItemMeta().hasCustomModelData()) {
                    p.sendMessage(Utils.color("&3Model &r: " + heldItem.getItemMeta().getCustomModelData()));
                    ItemsInHand.getConfig().set(uuid + ".CustomModelData", (Object)heldItem.getItemMeta().getCustomModelData());
                }
                if (heldItem.getItemMeta().hasDisplayName()) {
                    p.sendMessage(Utils.color("&3Display &r: " + heldItem.getItemMeta().getDisplayName()));
                    ItemsInHand.getConfig().set(uuid + ".Display", (Object)heldItem.getItemMeta().getDisplayName());
                }
                if (heldItem.getItemMeta().hasLore()) {
                    p.sendMessage(Utils.color("&3Lore &r: "));
                    for (int i = 1; i <= heldItem.getItemMeta().getLore().size(); ++i) {
                        String loreline = (String)heldItem.getItemMeta().getLore().get(i - 1);
                        p.sendMessage(Utils.color(" - " + loreline));
                    }
                    List lore = heldItem.getItemMeta().getLore();
                    ItemsInHand.getConfig().set(uuid + ".Lore", Collections.unmodifiableList(lore));
                }
                if (heldItem.getItemMeta().isUnbreakable()) {
                    p.sendMessage(Utils.color("&3Unbreakable &r: " + heldItem.getItemMeta().isUnbreakable()));
                    ItemsInHand.getConfig().set(uuid + ".Unbreakable", (Object)heldItem.getItemMeta().isUnbreakable());
                }
                if (heldItem.getEnchantments().size() != 0) {
                    p.sendMessage(Utils.color("&3Enchantment &r: "));
                    String[] endall = String.valueOf(heldItem.getEnchantments()).replace("Enchantment", "").split(":");
                    for (int i = 1; i <= heldItem.getEnchantments().size(); ++i) {
                        String nameend = endall[i].replaceAll("[^A-Z]", "");
                        String endlv = endall[i].replaceAll("[^0-9]", "");
                        String endlist = nameend + ":" + endlv;
                        p.sendMessage(Utils.color(" - " + endlist));
                        ItemsInHand.getConfig().set(uuid + ".Enchantment." + i, (Object)endlist);
                    }
                }
                if (heldItem.getItemMeta().getItemFlags().size() != 0) {
                    p.sendMessage(Utils.color("&3ItemFlag &r: "));
                    String[] flags = String.valueOf(heldItem.getItemMeta().getItemFlags()).replaceAll("[^A-Z _]", "").split(" ");
                    Set flag = heldItem.getItemMeta().getItemFlags();
                    for (int i = 1; i <= heldItem.getItemMeta().getItemFlags().size(); ++i) {
                        p.sendMessage(Utils.color(" - " + flags[i - 1]));
                        ItemsInHand.getConfig().set(uuid + ".ItemFlag." + i, (Object)flags[i - 1]);
                    }
                }
                ItemsInHand.saveConfig();
                p.sendMessage(Utils.color("&7&m&l======&r &a&lEnd &7&m&l======"));
                return true;
            }
        } else if (args.length == 3) {
            if (args[0].equalsIgnoreCase("get")) {
                Player player = (Player)sender;
                FileConfiguration Kits = Items.getConfig();
                String amountStr = args[2];
                int amount = 1;
                try {
                    amount = Integer.parseInt(amountStr);
                }
                catch (NumberFormatException event) {
                    sender.sendMessage(Utils.color(Config.get().getString("notnumber") + args[2]));
                    return true;
                }
                for (String key : Kits.getKeys(false)) {
                    if (!args[1].equals(String.valueOf(key))) continue;
                    Utils.GetItems(key, amount, player);
                    sender.sendMessage(Utils.color(Config.get().getString("cmd_gotitem").replace("<id>", Items.getConfig().getString(key + ".Display"))));
                    return true;
                }
                sender.sendMessage(Utils.color(Config.get().getString("noitemfound") + args[1]));
                return true;
            }
        } else if (args.length == 4) {
            if (args[0].equalsIgnoreCase("give")) {
                Player target = null;
                for (Player po : Main.get().getServer().getOnlinePlayers()) {
                    if (!args[1].equalsIgnoreCase(po.getName())) continue;
                    target = po;
                }
                if (target == null) {
                    sender.sendMessage(Utils.color(Config.get().getString("noplayerfound") + args[1]));
                    return true;
                }
                String amountStr = args[3];
                int amount = 1;
                try {
                    amount = Integer.parseInt(amountStr);
                }
                catch (NumberFormatException event) {
                    sender.sendMessage(Utils.color(Config.get().getString("notnumber") + args[3]));
                    return true;
                }
                FileConfiguration Kits = Items.getConfig();
                for (String key : Kits.getKeys(false)) {
                    if (!args[2].equals(String.valueOf(key))) continue;
                    Utils.GetItems(key, amount, target);
                    sender.sendMessage(Utils.color(Config.get().getString("give_items").replace("<i>", Items.getConfig().getString(key + ".Display")).replace("<p>", target.getName()).replace("<a>", String.valueOf(amount))));
                    target.sendMessage(Utils.color(Config.get().getString("player_gotitems").replace("<id>", Items.getConfig().getString(key + ".Display")).replace("<a>", String.valueOf(amount))));
                    return true;
                }
            }
        } else {
            sender.sendMessage(Utils.color(Config.get().getString("cmd_wrong")));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> strs = new ArrayList<String>();
            String[] list = new String[]{"get", "give", "reload", "hand"};
            if (!args[0].equalsIgnoreCase("")) {
                for (String tab : list) {
                    if (!tab.startsWith(args[0].toLowerCase())) continue;
                    strs.add(tab);
                }
            } else {
                for (String tab : list) {
                    strs.add(tab);
                }
            }
            Collections.sort(strs);
            return strs;
        }
        if (args[0].equalsIgnoreCase("get")) {
            ArrayList<String> strs = new ArrayList<String>();
            if (args.length == 2) {
                return Utils.getItemList(args[1]);
            }
            if (args.length == 3) {
                String[] list = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
                if (!args[2].equalsIgnoreCase("")) {
                    for (String s : list) {
                        if (!s.startsWith(args[1].toLowerCase())) continue;
                        strs.add(s);
                    }
                } else {
                    for (String s : list) {
                        strs.add(s);
                    }
                }
            }
            Collections.sort(strs);
            return strs;
        }
        if (args[0].equalsIgnoreCase("give")) {
            ArrayList<String> strs = new ArrayList<String>();
            if (args.length == 2) {
                return Utils.PlayeOnline(args[1]);
            }
            if (args.length == 3) {
                return Utils.getItemList(args[2]);
            }
            if (args.length == 4) {
                String[] list = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
                if (!args[3].equalsIgnoreCase("")) {
                    for (String s : list) {
                        if (!s.startsWith(args[1].toLowerCase())) continue;
                        strs.add(s);
                    }
                } else {
                    for (String s : list) {
                        strs.add(s);
                    }
                }
            }
            Collections.sort(strs);
            return strs;
        }
        return null;
    }
}

