/*
 * Decompiled with CFR 0.152.
 */
package fr.WarzouMc.hikabrain.manager;

import fr.WarzouMc.hikabrain.gameLoop.NewPoint;
import fr.WarzouMc.hikabrain.gameLoop.StartLoop;
import fr.WarzouMc.hikabrain.gameLoop.WinLoop;
import fr.WarzouMc.hikabrain.graphic.bossBar.BossBar;
import fr.WarzouMc.hikabrain.graphic.scoreboard.Creater;
import fr.WarzouMc.hikabrain.main.Main;
import fr.WarzouMc.hikabrain.state.GameState;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class Manager
implements Listener {
    private Main main;
    private Location spawn;
    Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
    Team team = null;

    public Manager(Main main) {
        this.main = main;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getName();
        this.spawn = new Location(player.getLocation().getWorld(), 0.5, 70.0, 0.5);
        player.teleport(this.spawn);
        player.getInventory().clear();
        player.setFoodLevel(20);
        player.setSaturation(20.0f);
        player.setHealth(20.0);
        player.setBedSpawnLocation(this.spawn);
        player.getInventory().setChestplate(null);
        player.getInventory().setLeggings(null);
        player.getInventory().setBoots(null);
        if (this.main.getPlayerInGame().size() > 1) {
            for (int i = 0; i < this.main.getPlayerInGame().size(); ++i) {
                Player pls = Bukkit.getPlayer((String)this.main.getPlayerInGame().get(i));
                pls.hidePlayer(player);
            }
            player.sendTitle("\u00a7cThe game is already", "\u00a7eStart");
            player.setGameMode(GameMode.SPECTATOR);
        } else {
            this.addPlayer(playerName);
            player.setGameMode(GameMode.ADVENTURE);
        }
        if (this.main.getPlayerInGame().size() == 2 && this.main.getGameState() == GameState.WAITING) {
            this.main.setGameState(GameState.STARTING);
            StartLoop startLoop = new StartLoop(this.main);
            startLoop.runTaskTimer((Plugin)this.main, 0L, 1L);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getName();
        if (this.main.getPlayerInGame().contains(playerName)) {
            this.rvmPlayer(playerName);
            for (int i = 0; i < this.main.getPlayerInGame().size(); ++i) {
                Player pls = Bukkit.getPlayer((String)this.main.getPlayerInGame().get(i));
                if (this.main.getGameState() == GameState.STARTING) {
                    pls.sendTitle("\u00a7cWaiting for", "\u00a7emore player !");
                    this.main.setGameState(GameState.WAITING);
                    continue;
                }
                if (this.main.getGameState() == GameState.WINNING) continue;
                this.main.setGameState(GameState.WINNING);
                this.win();
                this.main.setWinner(this.main.getPlayerInGame().get(0));
            }
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getName();
        player.setSaturation(20.0f);
        player.setFoodLevel(20);
        int x = player.getLocation().getBlockX();
        int y = player.getLocation().getBlockY() - 1;
        int z = player.getLocation().getBlockZ();
        Map<String, Integer> point = this.main.getPoint();
        if (this.main.getGameState() == GameState.NEWPOINT) {
            this.main.initPlayer(player);
        }
        Player bluePlayer = null;
        Player redPlayer = null;
        int bluePoint = 0;
        int redPoint = 0;
        if (this.main.getGameState() != GameState.WAITING && this.main.getGameState() != GameState.STARTING) {
            bluePlayer = Bukkit.getPlayer((String)this.main.getPlayerInGame().get(0));
            redPlayer = Bukkit.getPlayer((String)this.main.getPlayerInGame().get(1));
            redPoint = this.main.getPoint().get(redPlayer.getName());
            bluePoint = this.main.getPoint().get(bluePlayer.getName());
        }
        if (this.main.getGameState() == GameState.PLAYING && player.getLocation().getBlockY() < 50) {
            this.main.initPlayer(player);
        } else if (this.main.getGameState() == GameState.PLAYING && player.getLocation().getWorld().getBlockAt(x, y, z).getType() == Material.WOOL) {
            if (this.main.getPlayerInGame().get(0).equalsIgnoreCase(playerName)) {
                if (player.getLocation().getWorld().getBlockAt(x, y, z).getData() == 14) {
                    point.replace(playerName, point.get(playerName) + 1);
                    this.main.setPoint(point);
                    if (this.main.getPoint().get(playerName) == 5) {
                        this.main.setGameState(GameState.WINNING);
                        Bukkit.getPlayer((String)this.main.getPlayerInGame().get(1)).setGameMode(GameMode.SPECTATOR);
                        player.setAllowFlight(true);
                        player.getLocation().setY(player.getLocation().getY() + 0.1);
                        player.setFlying(true);
                        for (Player pls : Bukkit.getOnlinePlayers()) {
                            pls.sendTitle("\u00a71" + playerName + " has win", "\u00a715 \u00a76- \u00a74" + redPoint);
                        }
                        this.main.setWinner(playerName);
                        this.win();
                    } else {
                        this.goal();
                    }
                }
            } else if (this.main.getPlayerInGame().get(1).equalsIgnoreCase(playerName) && player.getLocation().getWorld().getBlockAt(x, y, z).getData() == 11) {
                point.replace(playerName, point.get(playerName) + 1);
                this.main.setPoint(point);
                if (this.main.getPoint().get(playerName) == 5) {
                    this.main.setGameState(GameState.WINNING);
                    player.setAllowFlight(true);
                    player.getLocation().setY(player.getLocation().getY() + 0.1);
                    player.setFlying(true);
                    Bukkit.getPlayer((String)this.main.getPlayerInGame().get(0)).setGameMode(GameMode.SPECTATOR);
                    for (Player pls : Bukkit.getOnlinePlayers()) {
                        pls.sendTitle("\u00a71" + playerName + " has win", "\u00a745 \u00a76- \u00a71" + bluePoint);
                    }
                    this.main.setWinner(playerName);
                    this.win();
                } else {
                    this.goal();
                }
            }
        }
    }

    private void goal() {
        this.main.setGameState(GameState.NEWPOINT);
        NewPoint newPoint = new NewPoint(this.main);
        newPoint.runTaskTimer((Plugin)this.main, 0L, 1L);
        this.main.initPlayer(Bukkit.getPlayer((String)this.main.getPlayerInGame().get(0)));
        this.main.initPlayer(Bukkit.getPlayer((String)this.main.getPlayerInGame().get(1)));
        this.main.initMap();
    }

    private void win() {
        for (int x = -21; x < 22; ++x) {
            for (int z = -7; z < 8; ++z) {
                ((World)Bukkit.getWorlds().get(0)).getBlockAt(x, 69, z).setType(Material.AIR);
            }
        }
        WinLoop winLoop = new WinLoop(this.main);
        winLoop.runTaskTimer((Plugin)this.main, 0L, 20L);
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (this.main.getGameState() != GameState.PLAYING) {
            event.setCancelled(true);
            return;
        }
        if (entity instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player && ((Player)entity).getHealth() <= event.getDamage()) {
            this.main.initPlayer((Player)entity);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        Location blockLocation = block.getLocation();
        if (block.getType() != Material.SANDSTONE || this.main.getGameState() != GameState.PLAYING) {
            event.setCancelled(true);
            return;
        }
        if (blockLocation.getZ() >= -1.0 && blockLocation.getZ() <= 1.0 && blockLocation.getY() >= 59.0) {
            event.setCancelled(blockLocation.getX() >= 19.0 || blockLocation.getX() <= -19.0);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Location blockLocation = block.getLocation();
        if (block.getType() != Material.SANDSTONE || this.main.getGameState() != GameState.PLAYING) {
            event.setCancelled(true);
            return;
        }
        if (blockLocation.getZ() >= -1.0 && blockLocation.getZ() <= 1.0 && blockLocation.getY() >= 59.0) {
            event.setCancelled(blockLocation.getX() >= 19.0 || blockLocation.getX() <= -19.0);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        event.setCancelled(true);
    }

    private void rvmPlayer(String playerName) {
        List<String> playerInGame = this.main.getPlayerInGame();
        Map<String, Integer> point = this.main.getPoint();
        Creater creater = new Creater(this.main);
        creater.destroy(Bukkit.getPlayer((String)playerName));
        playerInGame.remove(playerName);
        point.remove(playerName);
        this.main.setPlayerInGame(playerInGame);
        this.rvmBar(Bukkit.getPlayer((String)playerName));
    }

    private void addPlayer(String playerName) {
        List<String> playerInGame = this.main.getPlayerInGame();
        Map<String, Integer> point = this.main.getPoint();
        Creater creater = new Creater(this.main);
        creater.create(Bukkit.getPlayer((String)playerName));
        playerInGame.add(playerName);
        point.put(playerName, 0);
        this.main.setPlayerInGame(playerInGame);
        Bukkit.getPlayer((String)playerName).setPlayerListName("\u00a7k" + playerName);
        Bukkit.getPlayer((String)playerName).setDisplayName("\u00a7k" + playerName + "\u00a7r");
        this.team = this.scoreboard.getTeam(playerName) == null ? this.scoreboard.registerNewTeam(playerName) : this.scoreboard.getTeam(playerName);
        this.setBar(Bukkit.getPlayer((String)playerName));
        this.team.setPrefix("\u00a7k");
        this.team.addPlayer((OfflinePlayer)Bukkit.getPlayer((String)playerName));
    }

    public void rvmBar(Player player) {
        Map<Player, BossBar> bar = this.main.getBar();
        if (bar.containsKey(player)) {
            bar.remove(player);
            this.main.setBar(bar);
        }
    }

    public void setBar(Player player) {
        Map<Player, BossBar> bar = this.main.getBar();
        if (!bar.containsKey(player)) {
            bar.put(player, new BossBar(player, "\u00a7cWaiting player", 100.0f));
            this.main.setBar(bar);
        }
    }
}

