/*
 * Decompiled with CFR 0.152.
 */
package fr.WarzouMc.hikabrain.main;

import fr.WarzouMc.hikabrain.graphic.bossBar.BossBar;
import fr.WarzouMc.hikabrain.graphic.bossBar.BossBarUpdater;
import fr.WarzouMc.hikabrain.graphic.scoreboard.Creater;
import fr.WarzouMc.hikabrain.graphic.scoreboard.ScoreBoardUpdater;
import fr.WarzouMc.hikabrain.graphic.scoreboard.ScoreboardSign;
import fr.WarzouMc.hikabrain.manager.Manager;
import fr.WarzouMc.hikabrain.state.GameState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class Main
extends JavaPlugin {
    private GameState gameState;
    private List<String> playerInGame = new ArrayList<String>();
    private List<String> playerOutGame = new ArrayList<String>();
    private Map<String, Integer> point = new HashMap<String, Integer>();
    private Map<Player, ScoreboardSign> board = new HashMap<Player, ScoreboardSign>();
    private Map<Player, BossBar> bar = new HashMap<Player, BossBar>();
    private int timer = 10;
    public String winner = null;

    public void onEnable() {
        Bukkit.getConsoleSender().sendMessage("\u00a72#########################\n                 \u00a72##\u00a76Hikabrain by \u00a71War\u00a7fzo\u00a74uMc\u00a72##\n                 \u00a72#########################");
        ((World)Bukkit.getWorlds().get(0)).setGameRuleValue("doDaylightCycle", "false");
        ((World)Bukkit.getWorlds().get(0)).setGameRuleValue("doMobSpawning", "false");
        ((World)Bukkit.getWorlds().get(0)).setGameRuleValue("keepInventory", "true");
        this.setGameState(GameState.WAITING);
        this.getServer().getPluginManager().registerEvents((Listener)new Manager(this), (Plugin)this);
        ScoreBoardUpdater scoreBoardUpdater = new ScoreBoardUpdater(this);
        scoreBoardUpdater.runTaskTimer((Plugin)this, 0L, 1L);
        BossBarUpdater bossBarUpdater = new BossBarUpdater(this);
        bossBarUpdater.runTaskTimer((Plugin)this, 0L, 1L);
        this.initMap();
    }

    public void onDisable() {
        Bukkit.getConsoleSender().sendMessage("\u00a74#########################\n                 \u00a74##\u00a76Hikabrain by \u00a71War\u00a7fzo\u00a74uMc\u00a74##\n                 \u00a74#########################");
        for (Player pls : Bukkit.getOnlinePlayers()) {
            Creater creater = new Creater(this);
            creater.destroy(pls);
            pls.kickPlayer("\u00a74End of the game !");
        }
    }

    public void initPlayer(Player player) {
        FireworkMeta fireworkMeta;
        Firework firework;
        FireworkEffect fireworkEffect;
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = null;
        float x = 20.5f;
        float yaw = 0.0f;
        if (this.getPlayerInGame().get(0).equalsIgnoreCase(player.getName())) {
            x = 20.5f;
            yaw = 90.0f;
            player.setPlayerListName("\u00a71" + player.getName());
            player.setDisplayName("\u00a71" + player.getName() + "\u00a7r");
            if (this.getGameState() != GameState.NEWPOINT && this.getGameState() != GameState.STARTING) {
                fireworkEffect = FireworkEffect.builder().with(FireworkEffect.Type.STAR).withColor(Color.BLUE).build();
                firework = (Firework)player.getWorld().spawnEntity(player.getLocation(), EntityType.FIREWORK);
                firework.detonate();
                fireworkMeta = firework.getFireworkMeta();
                fireworkMeta.setPower(0);
                fireworkMeta.addEffect(fireworkEffect);
                firework.setFireworkMeta(fireworkMeta);
            }
            team = scoreboard.getTeam(player.getName()) == null ? scoreboard.registerNewTeam(player.getName()) : scoreboard.getTeam(player.getName());
            team.setPrefix("\u00a71");
            team.addPlayer((OfflinePlayer)Bukkit.getPlayer((String)player.getName()));
        } else {
            x = -20.5f;
            yaw = 270.0f;
            player.setPlayerListName("\u00a74" + player.getName());
            player.setDisplayName("\u00a74" + player.getName() + "\u00a7r");
            if (this.getGameState() != GameState.NEWPOINT && this.getGameState() != GameState.STARTING) {
                fireworkEffect = FireworkEffect.builder().with(FireworkEffect.Type.STAR).withColor(Color.RED).build();
                firework = (Firework)player.getWorld().spawnEntity(player.getLocation(), EntityType.FIREWORK);
                firework.detonate();
                fireworkMeta = firework.getFireworkMeta();
                fireworkMeta.setPower(0);
                fireworkMeta.addEffect(fireworkEffect);
                firework.setFireworkMeta(fireworkMeta);
            }
            team = scoreboard.getTeam(player.getName()) == null ? scoreboard.registerNewTeam(player.getName()) : scoreboard.getTeam(player.getName());
            team.setPrefix("\u00a74");
            team.addPlayer((OfflinePlayer)Bukkit.getPlayer((String)player.getName()));
        }
        Location tp = new Location(player.getLocation().getWorld(), (double)x, 64.0, 0.5, yaw, 0.0f);
        player.teleport(tp);
        player.setHealth(20.0);
        player.setSaturation(20.0f);
        player.setFoodLevel(20);
        player.getInventory().clear();
        ItemStack sword = new ItemStack(Material.IRON_SWORD);
        ItemStack pickAxe = new ItemStack(Material.DIAMOND_PICKAXE);
        ItemStack gApple = new ItemStack(Material.GOLDEN_APPLE, 64);
        ItemStack sandStonne = new ItemStack(Material.SANDSTONE, 64);
        ItemStack chestplate = new ItemStack(Material.IRON_CHESTPLATE);
        ItemStack leggins = new ItemStack(Material.IRON_LEGGINGS);
        ItemStack boots = new ItemStack(Material.IRON_BOOTS);
        ItemMeta swordM = sword.getItemMeta();
        ItemMeta pickAxeM = pickAxe.getItemMeta();
        swordM.addEnchant(Enchantment.DURABILITY, 1000, true);
        swordM.addEnchant(Enchantment.KNOCKBACK, 1, true);
        sword.setItemMeta(swordM);
        pickAxeM.addEnchant(Enchantment.DURABILITY, 1000, true);
        pickAxe.setItemMeta(pickAxeM);
        player.getInventory().addItem(new ItemStack[]{sword});
        player.getInventory().addItem(new ItemStack[]{pickAxe});
        player.getInventory().addItem(new ItemStack[]{gApple});
        player.setNoDamageTicks(40);
        for (int i = 0; i < 34; ++i) {
            player.getInventory().addItem(new ItemStack[]{sandStonne});
        }
        player.getInventory().setChestplate(chestplate);
        player.getInventory().setLeggings(leggins);
        player.getInventory().setBoots(boots);
        player.setGameMode(GameMode.SURVIVAL);
    }

    public void initMap() {
        int z;
        int z2;
        int y;
        int x;
        World world = (World)Bukkit.getWorlds().get(0);
        for (x = -21; x < 22; ++x) {
            for (y = 50; y < 73; ++y) {
                for (z2 = -7; z2 < 8; ++z2) {
                    world.getBlockAt(x, y, z2).setType(Material.AIR);
                    world.getBlockAt(x, 69, z2).setType(Material.STAINED_GLASS);
                }
            }
        }
        for (int y2 = 50; y2 < 73; ++y2) {
            for (int x2 = -22; x2 < 23; ++x2) {
                for (z2 = -8; z2 < 9; ++z2) {
                    if (x2 != -22 && x2 != 22 && z2 != -8 && z2 != 8) continue;
                    if (y2 < 70) {
                        world.getBlockAt(x2, y2, z2).setType(Material.OBSIDIAN);
                        continue;
                    }
                    if (y2 > 70) {
                        world.getBlockAt(x2, y2, z2).setType(Material.BEDROCK);
                        continue;
                    }
                    world.getBlockAt(x2, y2, z2).setType(Material.AIR);
                }
            }
        }
        for (x = -21; x < 22; ++x) {
            for (y = 50; y < 60; ++y) {
                if (x == 0 && y == 59) {
                    world.getBlockAt(x, y, 0).setType(Material.REDSTONE_BLOCK);
                    continue;
                }
                if ((x == 21 || x == 20) && y == 59) {
                    world.getBlockAt(x, y, 0).setType(Material.WOOL);
                    world.getBlockAt(x, y, 0).setData((byte)11);
                    continue;
                }
                if ((x == -21 || x == -20) && y == 59) {
                    world.getBlockAt(x, y, 0).setType(Material.WOOL);
                    world.getBlockAt(x, y, 0).setData((byte)14);
                    continue;
                }
                world.getBlockAt(x, y, 0).setType(Material.SANDSTONE);
            }
        }
        for (x = 19; x < 22; ++x) {
            for (z = -1; z < 2; ++z) {
                world.getBlockAt(x, 63, z).setType(Material.STAINED_GLASS);
                world.getBlockAt(x, 63, z).setData((byte)11);
            }
        }
        for (x = -21; x < -18; ++x) {
            for (z = -1; z < 2; ++z) {
                world.getBlockAt(x, 63, z).setType(Material.STAINED_GLASS);
                world.getBlockAt(x, 63, z).setData((byte)14);
            }
        }
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public Map<String, Integer> getPoint() {
        return this.point;
    }

    public void setPoint(Map<String, Integer> point) {
        this.point = point;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState gameState) {
        this.gameState = gameState;
    }

    public List<String> getPlayerInGame() {
        return this.playerInGame;
    }

    public void setPlayerInGame(List<String> playerInGame) {
        this.playerInGame = playerInGame;
    }

    public List<String> getPlayerOutGame() {
        return this.playerOutGame;
    }

    public void setPlayerOutGame(List<String> playerOutGame) {
        this.playerOutGame = playerOutGame;
    }

    public Map<Player, ScoreboardSign> getBoard() {
        return this.board;
    }

    public void setBoard(Map<Player, ScoreboardSign> board) {
        this.board = board;
    }

    public String getWinner() {
        return this.winner;
    }

    public void setWinner(String winner) {
        this.winner = winner;
    }

    public Map<Player, BossBar> getBar() {
        return this.bar;
    }

    public void setBar(Map<Player, BossBar> bar) {
        this.bar = bar;
    }
}

