/*
 * Decompiled with CFR 0.152.
 */
package fr.WarzouMc.hikabrain.graphic.bossBar;

import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityWither;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class BossBar {
    private Player player;
    private String message;
    private EntityWither wither;
    private float live;

    public BossBar(Player player, String message, float live) {
        this.player = player;
        this.message = message;
        this.live = live;
        this.update(player, message, live);
    }

    public void update(Player player, String message, float live) {
        Vector vector = player.getLocation().getDirection();
        Location location = player.getLocation().add(vector.multiply(20));
        this.removWither();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        this.wither = new EntityWither((World)world);
        int y = -15;
        if (player.getLocation().getPitch() < 0.0f) {
            y = 15;
        }
        this.wither.setLocation(location.getX(), player.getLocation().getY() + (double)y, location.getZ(), location.getPitch(), location.getYaw());
        this.wither.setCustomName(message);
        this.wither.setCustomNameVisible(true);
        this.wither.setHealth(live * this.wither.getMaxHealth() / 100.0f);
        this.wither.setInvisible(true);
        this.wither.r(10000000);
        PacketPlayOutSpawnEntityLiving packet = new PacketPlayOutSpawnEntityLiving((EntityLiving)this.wither);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }

    public void removWither() {
        if (this.wither != null) {
            PacketPlayOutEntityDestroy packet = new PacketPlayOutEntityDestroy(new int[]{this.wither.getId()});
            ((CraftPlayer)this.player).getHandle().playerConnection.sendPacket((Packet)packet);
        }
    }
}

