/*
 * Decompiled with CFR 0.152.
 */
package me.valkyrienyanko.inventoryRestore.configs;

import java.util.ArrayList;
import java.util.List;
import me.valkyrienyanko.inventoryRestore.configs.ConfigManager;
import me.valkyrienyanko.inventoryRestore.configs.ConfigResource;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ConfigItem
extends ConfigResource {
    public ConfigItem(ConfigManager config) {
        super(config);
    }

    public void set(String path, ItemStack item) {
        super.setConfigResource(path);
        ItemMeta im = item.getItemMeta();
        String name = null;
        List lore = null;
        int quantity = item.getAmount();
        ArrayList<String> flags = new ArrayList<String>();
        if (im != null) {
            name = im.getDisplayName();
            lore = im.getLore();
            for (ItemFlag flag : im.getItemFlags()) {
                flags.add(flag.name());
            }
        }
        this.config.set(String.valueOf(path) + ".material", (Object)item.getType().name());
        if (name != null && name != "") {
            this.config.set(String.valueOf(path) + ".name", (Object)name);
        }
        if (quantity != 1) {
            this.config.set(String.valueOf(path) + ".quantity", (Object)quantity);
        }
        if (lore != null) {
            this.config.set(String.valueOf(path) + ".lore", (Object)lore);
        }
        if (flags.size() != 0) {
            this.config.set(String.valueOf(path) + ".flags", flags);
        }
    }

    public ItemStack get(String path) {
        ItemStack item;
        ItemMeta im;
        String materialName = this.config.getString(String.valueOf(path) + ".material");
        String itemName = this.config.getString(String.valueOf(path) + ".name");
        List configLore = this.config.getStringList(String.valueOf(path) + ".lore");
        ArrayList<String> formattedLore = new ArrayList<String>();
        List itemFlags = this.config.getStringList(String.valueOf(path) + ".flags");
        int quantity = this.config.getInt(String.valueOf(path) + ".quantity");
        if (!this.config.isSet(String.valueOf(path) + ".quantity")) {
            quantity = 1;
        }
        Material material = null;
        try {
            material = Material.valueOf((String)materialName);
        }
        catch (IllegalArgumentException e) {
            material = Material.AIR;
        }
        if (itemName == null) {
            itemName = "";
            String[] words = material.name().toLowerCase().split("_");
            int i = 0;
            while (i < words.length) {
                itemName = String.valueOf(itemName) + words[i].substring(0, 1).toUpperCase() + words[i].substring(1) + (i == words.length - 1 ? "" : " ");
                ++i;
            }
        }
        if ((im = (item = new ItemStack(material, quantity)).getItemMeta()) != null) {
            im.setDisplayName(itemName);
            if (configLore != null) {
                for (String element : configLore) {
                    formattedLore.add(element);
                }
                im.setLore(formattedLore);
            }
            if (itemFlags != null) {
                for (String element : itemFlags) {
                    im.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)element.toUpperCase())});
                }
            }
            item.setItemMeta(im);
        }
        return item;
    }
}

