/*
 * Decompiled with CFR 0.152.
 */
package fyi.sugar.mobstoeggs.utility;

import fyi.sugar.mobstoeggs.Main;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lfyi/sugar/mobstoeggs/utility/PluginVersionMigrator;", "", "plugin", "Lfyi/sugar/mobstoeggs/Main;", "(Lfyi/sugar/mobstoeggs/Main;)V", "onDirectoryUpdate", "", "configTarget", "Ljava/io/File;", "directory", "onNewVersionFound", "configFound", "MobsToEggsX"})
public final class PluginVersionMigrator {
    @NotNull
    private final Main plugin;

    public PluginVersionMigrator(@NotNull Main plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
    }

    public final void onNewVersionFound(@NotNull File configFound, @NotNull File configTarget) {
        Intrinsics.checkNotNullParameter((Object)configFound, (String)"configFound");
        Intrinsics.checkNotNullParameter((Object)configTarget, (String)"configTarget");
        try {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)configFound);
            Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"loadConfiguration(configFound)");
            YamlConfiguration configYamlConfig = yamlConfiguration;
            String configVersion = configYamlConfig.getString("config-version");
            Object object = new String[]{"1.2", "1.2.1", "1.2.2", "1.3", "1.3.1", "1.4", "1.4.1", "1.4.1_1", "1.4.2", "1.4.3", "1.4.3_1", "1.5", "1.5.1", "1.5.2", "1.5.3", "1.5.3_1", "1.5.4", "1.5.5", "1.5.5_1", "1.5.5_2", "1.5.5_3", "1.5.5_4", "1.5.5_5"};
            List previousVersions = CollectionsKt.listOf((Object[])object);
            try {
                object = configVersion;
                if (object == null || object.length() == 0) {
                    return;
                }
            }
            catch (FileNotFoundException e) {
                return;
            }
            if (previousVersions.contains(configVersion)) {
                FilesKt.copyTo((File)configFound, (File)configTarget, (boolean)true, (int)8192);
                configFound.delete();
                this.plugin.getLogger().warning("Old config file '" + configFound.getName() + "' has successfully been moved to old-configs/" + configTarget.getName() + '!');
            }
            return;
        }
        catch (NullPointerException e) {
            this.plugin.getLogger().warning(configFound.getName() + " could not be checked if it is an old config version! Please manually check the file and move or delete it.");
            this.plugin.getLogger().warning(String.valueOf(e));
            return;
        }
    }

    public final void onDirectoryUpdate(@NotNull File configTarget, @NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)configTarget, (String)"configTarget");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        if (directory.isDirectory()) {
            FilesKt.copyRecursively$default((File)directory, (File)configTarget, (boolean)true, null, (int)4, null);
            FilesKt.deleteRecursively((File)directory);
            this.plugin.getLogger().warning("Old folder '" + directory.getName() + "' has successfully been moved to old-configs/" + directory.getName() + '!');
        }
    }
}

