/*
 * Decompiled with CFR 0.152.
 */
package fyi.sugar.mobstoeggs.utility;

import de.leonhard.storage.Config;
import de.leonhard.storage.internal.settings.ConfigSettings;
import de.leonhard.storage.internal.settings.DataType;
import de.leonhard.storage.internal.settings.ReloadSettings;
import fyi.sugar.mobstoeggs.Main;
import fyi.sugar.mobstoeggs.utility.PluginVersionMigrator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lfyi/sugar/mobstoeggs/utility/ConfigManager;", "", "plugin", "Lfyi/sugar/mobstoeggs/Main;", "(Lfyi/sugar/mobstoeggs/Main;)V", "getConfig", "Lde/leonhard/storage/Config;", "getMobs", "getFileConfig", "getFileMobs", "getLanguage", "setup", "", "updateConfigs", "updateMobsConfig", "MobsToEggsX"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nfyi/sugar/mobstoeggs/utility/ConfigManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n1855#2,2:206\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\nfyi/sugar/mobstoeggs/utility/ConfigManager\n*L\n122#1:206,2\n*E\n"})
public final class ConfigManager {
    @NotNull
    private final Main plugin;
    @NotNull
    private final Config getConfig;
    @NotNull
    private final Config getMobs;

    public ConfigManager(@NotNull Main plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        this.getConfig = new Config("config", String.valueOf(this.plugin.getDataFolder()), this.plugin.getResource("config.yml"), ReloadSettings.INTELLIGENT, ConfigSettings.PRESERVE_COMMENTS, DataType.SORTED);
        this.getMobs = new Config("mobs", this.plugin.getDataFolder() + "/mobs", this.plugin.getResource("mobs/mobs.yml"), ReloadSettings.INTELLIGENT, ConfigSettings.PRESERVE_COMMENTS, DataType.SORTED);
    }

    @NotNull
    public final Config getFileConfig() {
        return this.getConfig;
    }

    @NotNull
    public final Config getFileMobs() {
        return this.getMobs;
    }

    public final void setup() {
        String configversion;
        this.plugin.getLogger().info("Loading files for MobsToEggs...");
        this.updateConfigs();
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
            this.plugin.getLogger().info("Creating MobsToEggs folder...");
        }
        try {
            configversion = this.getFileMobs().getOrSetDefault("config-version", this.plugin.getMtev());
            if (!Intrinsics.areEqual((Object)configversion, (Object)this.plugin.getMtev())) {
                this.getFileMobs().set("config-version", this.plugin.getMtev());
            }
        }
        catch (FileNotFoundException e) {
            this.getFileMobs();
        }
        try {
            configversion = this.getFileConfig().getOrSetDefault("config-version", this.plugin.getMtev());
            if (!Intrinsics.areEqual((Object)configversion, (Object)this.plugin.getMtev())) {
                this.getFileConfig().set("config-version", this.plugin.getMtev());
            }
        }
        catch (FileNotFoundException e) {
            this.getFileConfig();
        }
        this.updateMobsConfig();
        this.getLanguage();
    }

    private final void updateConfigs() {
        File oldconfig = new File(this.plugin.getDataFolder() + "/old-configs/config.yml.old");
        File oldmobs = new File(this.plugin.getDataFolder() + "/old-configs/mobs.yml.old");
        File oldmessages = new File(this.plugin.getDataFolder() + "/old-configs/messages");
        File oldconfigfile = new File(this.plugin.getDataFolder() + "/config.yml");
        File oldmobsfile = new File(this.plugin.getDataFolder() + "/mobs.yml");
        File oldmessagesdir = new File(this.plugin.getDataFolder() + "/messages");
        new PluginVersionMigrator(this.plugin).onNewVersionFound(oldmobsfile, oldmobs);
        new PluginVersionMigrator(this.plugin).onNewVersionFound(oldconfigfile, oldconfig);
        new PluginVersionMigrator(this.plugin).onDirectoryUpdate(oldmessages, oldmessagesdir);
    }

    @NotNull
    public final Config getLanguage() {
        String lang = this.getFileConfig().getString("language");
        File confMsg = new File(this.plugin.getDataFolder() + "/data/language/" + lang + ".yml");
        if (!confMsg.exists()) {
            this.plugin.getLogger().info("Loading language files...");
            this.plugin.saveResource("data/language/en.yml", false);
            this.plugin.saveResource("data/language/es.yml", false);
            this.plugin.saveResource("data/language/hu.yml", false);
            this.plugin.saveResource("data/language/zh-s.yml", false);
            this.plugin.saveResource("data/language/zh-t.yml", false);
            this.plugin.getLogger().info("Language files loaded!");
            if (!confMsg.exists()) {
                this.plugin.getLogger().severe("The language file " + lang + ".yml does not exist! If you're using a custom language file, make sure the file name is correct in the language folder and config.yml!");
                this.getFileConfig().set("language", "en");
                this.plugin.getLogger().warning("The language file has been reset to en.yml to avoid undesired outcomes.");
                lang = this.getFileConfig().getString("language");
            }
        }
        InputStream loadLang = this.plugin.getResource("data/language/" + lang + ".yml");
        return new Config(String.valueOf(lang), this.plugin.getDataFolder() + "/data/language", loadLang, ReloadSettings.INTELLIGENT, ConfigSettings.PRESERVE_COMMENTS, DataType.SORTED);
    }

    private final void updateMobsConfig() {
        Object[] objectArray = new String[]{"Warden", "Frog", "Allay", "Tadpole", "Camel"};
        List entityListToAdd = CollectionsKt.listOf((Object[])objectArray);
        String string = this.plugin.getServer().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.server.version");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"1.19", (boolean)false, (int)2, null)) {
            Iterable $this$forEach$iv = entityListToAdd;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String mob = (String)element$iv;
                boolean bl = false;
                Config config = this.getFileMobs();
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = mob.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                config.getOrSetDefault(stringBuilder.append(string2).append(".entity.enabled").toString(), true);
                Config config2 = this.getFileMobs();
                StringBuilder stringBuilder2 = new StringBuilder();
                String string3 = mob.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                config2.getOrSetDefault(stringBuilder2.append(string3).append(".entity.entity-name").toString(), mob);
                Config config3 = this.getFileMobs();
                StringBuilder stringBuilder3 = new StringBuilder();
                String string4 = mob.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                config3.getOrSetDefault(stringBuilder3.append(string4).append(".entity.item-cost").toString(), "Diamond-1");
                Config config4 = this.getFileMobs();
                StringBuilder stringBuilder4 = new StringBuilder();
                String string5 = mob.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                config4.getOrSetDefault(stringBuilder4.append(string5).append(".entity.money-cost").toString(), "10");
                Config config5 = this.getFileMobs();
                StringBuilder stringBuilder5 = new StringBuilder();
                String string6 = mob.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                config5.getOrSetDefault(stringBuilder5.append(string6).append(".entity.catch-chance").toString(), "30");
                Config config6 = this.getFileMobs();
                StringBuilder stringBuilder6 = new StringBuilder();
                String string7 = mob.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                String string8 = stringBuilder6.append(string7).append(".egg.egg-data.material").toString();
                StringBuilder stringBuilder7 = new StringBuilder();
                String string9 = mob.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                config6.getOrSetDefault(string8, stringBuilder7.append(string9).append("_SPAWN_EGG").toString());
                Config config7 = this.getFileMobs();
                StringBuilder stringBuilder8 = new StringBuilder();
                String string10 = mob.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                config7.getOrSetDefault(stringBuilder8.append(string10).append(".egg.egg-data.name").toString(), "");
                Config config8 = this.getFileMobs();
                StringBuilder stringBuilder9 = new StringBuilder();
                String string11 = mob.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                config8.getOrSetDefault(stringBuilder9.append(string11).append(".egg.egg-data.lore").toString(), CollectionsKt.emptyList());
                Config config9 = this.getFileMobs();
                StringBuilder stringBuilder10 = new StringBuilder();
                String string12 = mob.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                config9.getOrSetDefault(stringBuilder10.append(string12).append(".egg.egg-data.custom-model-data").toString(), -1);
            }
            objectArray = new String[]{"customname", "iscustomnamevisible", "health", "isfrozen", "freezeticks", "isglowing", "issilent", "isvisualfire", "isinvisible", "variant"};
            this.getFileMobs().getOrSetDefault("frog.egg.egg-data.data", CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"customname", "iscustomnamevisible", "health", "isfrozen", "freezeticks", "isglowing", "issilent", "isvisualfire", "isinvisible", "age"};
            this.getFileMobs().getOrSetDefault("tadpole.egg.egg-data.data", CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"customname", "iscustomnamevisible", "health", "isfrozen", "freezeticks", "isglowing", "issilent", "isvisualfire", "isinvisible", "anger"};
            this.getFileMobs().getOrSetDefault("warden.egg.egg-data.data", CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"customname", "iscustomnamevisible", "health", "isfrozen", "freezeticks", "isglowing", "issilent", "isvisualfire", "isinvisible"};
            this.getFileMobs().getOrSetDefault("allay.egg.egg-data.data", CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"customname", "iscustomnamevisible", "health", "isfrozen", "freezeticks", "isglowing", "issilent", "isvisualfire", "isinvisible", "isdashing"};
            this.getFileMobs().getOrSetDefault("camel.egg.egg-data.data", CollectionsKt.listOf((Object[])objectArray));
        }
    }
}

