/*
 * Decompiled with CFR 0.152.
 */
package fyi.sugar.mobstoeggs.events;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import fyi.sugar.mobstoeggs.Main;
import fyi.sugar.mobstoeggs.data.GetConfigValues;
import fyi.sugar.mobstoeggs.data.GetEntityFileData;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Tameable;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lfyi/sugar/mobstoeggs/events/CaptureChallengeEvent;", "", "plugin", "Lfyi/sugar/mobstoeggs/Main;", "entityHit", "Lorg/bukkit/entity/Entity;", "playerTarget", "Lorg/bukkit/entity/Player;", "(Lfyi/sugar/mobstoeggs/Main;Lorg/bukkit/entity/Entity;Lorg/bukkit/entity/Player;)V", "getEntityFile", "Lfyi/sugar/mobstoeggs/data/GetEntityFileData;", "onChallenge", "", "MobsToEggsX"})
@SourceDebugExtension(value={"SMAP\nCaptureChallengeEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaptureChallengeEvent.kt\nfyi/sugar/mobstoeggs/events/CaptureChallengeEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n1855#2,2:263\n1855#2,2:265\n*S KotlinDebug\n*F\n+ 1 CaptureChallengeEvent.kt\nfyi/sugar/mobstoeggs/events/CaptureChallengeEvent\n*L\n151#1:263,2\n163#1:265,2\n*E\n"})
public final class CaptureChallengeEvent {
    @NotNull
    private final Main plugin;
    @NotNull
    private final Entity entityHit;
    @NotNull
    private final Player playerTarget;
    @NotNull
    private final GetEntityFileData getEntityFile;

    public CaptureChallengeEvent(@NotNull Main plugin, @NotNull Entity entityHit, @NotNull Player playerTarget) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)entityHit, (String)"entityHit");
        Intrinsics.checkNotNullParameter((Object)playerTarget, (String)"playerTarget");
        this.plugin = plugin;
        this.entityHit = entityHit;
        this.playerTarget = playerTarget;
        EntityType entityType = this.entityHit.getType();
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"entityHit.type");
        this.getEntityFile = new GetEntityFileData(this.plugin, entityType);
    }

    public final boolean onChallenge() {
        String[] currentLocation;
        if (Random.Default.nextDouble(0.0, 1.0) * (double)100 > this.getEntityFile.getEntityCatchChance()) {
            String string = this.plugin.getConfigmanager().getLanguage().getOrSetDefault("catch-fail-generic", "&cYou failed to catch the %mobname%&c!");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.configmanager.get\u2026 catch the %mobname%&c!\")");
            this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)StringsKt.replace$default((String)string, (String)"%mobname%", (String)this.getEntityFile.getEntityName(), (boolean)false, (int)4, null)));
            return false;
        }
        if (!new GetConfigValues(this.plugin).getCatchBabyMobs() && this.entityHit instanceof Ageable && !((Ageable)this.entityHit).isAdult()) {
            this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfigmanager().getLanguage().getOrSetDefault("catch-fail-baby-not-allowed", "&cYou can't catch baby mobs!")));
            return false;
        }
        if (!new GetConfigValues(this.plugin).getCatchShearedMobs() && this.entityHit instanceof Sheep && ((Sheep)this.entityHit).isSheared()) {
            this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfigmanager().getLanguage().getOrSetDefault("catch-fail-sheared-not-allowed", "&cYou can't catch sheared mobs!")));
            return false;
        }
        if (!new GetConfigValues(this.plugin).getCatchTamedMobs() && this.entityHit instanceof Tameable && ((Tameable)this.entityHit).isTamed()) {
            this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfigmanager().getLanguage().getOrSetDefault("catch-fail-tamed-not-allowed", "&cYou can't catch tamed mobs!")));
            return false;
        }
        if (this.entityHit.getCustomName() != null) {
            if (!new GetConfigValues(this.plugin).getCatchNamedMobs()) {
                this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfigmanager().getLanguage().getOrSetDefault("catch-fail-named-not-allowed", "&cYou can't catch named mobs!")));
                return false;
            }
            if (!new GetConfigValues(this.plugin).getNamedMobsKeepName()) {
                this.entityHit.setCustomName("");
            }
        }
        boolean bl = !((Collection)new GetConfigValues(this.plugin).getWorlds()).isEmpty();
        if (bl) {
            if (new GetConfigValues(this.plugin).getCatchOnlyInListedWorlds()) {
                if (!new GetConfigValues(this.plugin).getWorlds().contains(this.playerTarget.getWorld().getName())) {
                    this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfigmanager().getLanguage().getOrSetDefault("catch-fail-world-not-allowed", "&cYou can't catch mobs in this world!")));
                    return false;
                }
            } else if (new GetConfigValues(this.plugin).getWorlds().contains(this.playerTarget.getWorld().getName())) {
                this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfigmanager().getLanguage().getOrSetDefault("catch-fail-world-not-allowed", "&cYou can't catch mobs in this world!")));
                return false;
            }
        }
        boolean bl2 = !((Collection)new GetConfigValues(this.plugin).getRegions()).isEmpty();
        if (bl2) {
            RegionContainer wgContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
            currentLocation = BukkitAdapter.adapt((Location)this.entityHit.getLocation());
            RegionQuery wgRegionManager = wgContainer.createQuery();
            ApplicableRegionSet wgRegions = wgRegionManager.getApplicableRegions((com.sk89q.worldedit.util.Location)currentLocation);
            if (wgRegionManager != null) {
                if (new GetConfigValues(this.plugin).getCatchOnlyInListedRegions()) {
                    Set set = wgRegions.getRegions();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"wgRegions.regions");
                    Iterable $this$forEach$iv = set;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ProtectedRegion region = (ProtectedRegion)element$iv;
                        boolean bl3 = false;
                        if (new GetConfigValues(this.plugin).getRegions().contains(region.getId().toString())) continue;
                        this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfigmanager().getLanguage().getOrSetDefault("catch-fail-region-not-allowed", "&cYou can't catch mobs in this region!")));
                        return false;
                    }
                } else {
                    Set set = wgRegions.getRegions();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"wgRegions.regions");
                    Iterable $this$forEach$iv = set;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ProtectedRegion region = (ProtectedRegion)element$iv;
                        boolean bl4 = false;
                        if (!new GetConfigValues(this.plugin).getRegions().contains(region.getId().toString())) continue;
                        this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfigmanager().getLanguage().getOrSetDefault("catch-fail-region-not-allowed", "&cYou can't catch mobs in this region!")));
                        return false;
                    }
                }
            }
        }
        if (new GetConfigValues(this.plugin).getEnableItemCost()) {
            String string = this.getEntityFile.getEntityItemCost().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String itemCost = string;
            currentLocation = new String[]{"-"};
            List itemSplit = StringsKt.split$default((CharSequence)itemCost, (String[])currentLocation, (boolean)false, (int)0, (int)6, null);
            ItemStack itemType = new ItemStack(Material.valueOf((String)((String)itemSplit.get(0))));
            int itemPrice = Integer.parseInt((String)itemSplit.get(1));
            if (!this.playerTarget.getInventory().containsAtLeast(itemType, itemPrice)) {
                String string2 = this.plugin.getConfigmanager().getLanguage().getString("catch-fail-no-item");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"plugin.configmanager.get\u2026ing(\"catch-fail-no-item\")");
                String string3 = StringsKt.replace$default((String)string2, (String)"%itemamount%", (String)String.valueOf(itemPrice), (boolean)false, (int)4, null);
                String string4 = itemType.getType().name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)"%item%", (String)string4, (boolean)false, (int)4, null), (String)"%mobname%", (String)this.getEntityFile.getEntityName(), (boolean)false, (int)4, null)));
                return false;
            }
            if (new GetConfigValues(this.plugin).getIgnoreCreativeCosts() && this.playerTarget.getGameMode() == GameMode.CREATIVE) {
                return true;
            }
            itemType.setAmount(itemPrice);
            ItemStack[] itemStackArray = new ItemStack[]{itemType};
            this.playerTarget.getInventory().removeItem(itemStackArray);
            String string5 = this.plugin.getConfigmanager().getLanguage().getString("catch-success-with-item");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"plugin.configmanager.get\u2026catch-success-with-item\")");
            String string6 = StringsKt.replace$default((String)string5, (String)"%itemamount%", (String)String.valueOf(itemPrice), (boolean)false, (int)4, null);
            String string7 = itemType.getType().name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)StringsKt.replace$default((String)StringsKt.replace$default((String)string6, (String)"%item%", (String)string7, (boolean)false, (int)4, null), (String)"%mobname%", (String)this.getEntityFile.getEntityName(), (boolean)false, (int)4, null)));
        }
        if (new GetConfigValues(this.plugin).getEnableMoneyCost()) {
            EconomyResponse r;
            double moneyCost = this.getEntityFile.getEntityMoneyCost();
            Economy economy = this.plugin.getEcon();
            Double d = economy != null ? Double.valueOf(economy.getBalance((OfflinePlayer)this.playerTarget)) : null;
            Intrinsics.checkNotNull(d);
            if (d < moneyCost) {
                String string = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfigmanager().getLanguage().getString("catch-fail-no-money"));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translateAlternateColorC\u2026                        )");
                this.playerTarget.sendMessage(StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"%money%", (String)String.valueOf(moneyCost), (boolean)false, (int)4, null), (String)"%mobname%", (String)this.getEntityFile.getEntityName(), (boolean)false, (int)4, null));
                return false;
            }
            if (new GetConfigValues(this.plugin).getIgnoreCreativeCosts() && this.playerTarget.getGameMode() == GameMode.CREATIVE) {
                return true;
            }
            Economy economy2 = this.plugin.getEcon();
            EconomyResponse economyResponse = r = economy2 != null ? economy2.withdrawPlayer((OfflinePlayer)this.playerTarget, moneyCost) : null;
            if (r != null && r.transactionSuccess()) {
                String string = this.plugin.getConfigmanager().getLanguage().getString("catch-success-with-money");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.configmanager.get\u2026atch-success-with-money\")");
                this.playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"%money%", (String)String.valueOf(moneyCost), (boolean)false, (int)4, null), (String)"%mobname%", (String)this.getEntityFile.getEntityName(), (boolean)false, (int)4, null)));
            }
        }
        return true;
    }
}

