/*
 * Decompiled with CFR 0.152.
 */
package fyi.sugar.mobstoeggs.events;

import com.palmergames.bukkit.towny.utils.CombatUtil;
import fyi.sugar.mobstoeggs.Main;
import fyi.sugar.mobstoeggs.data.GetConfigValues;
import fyi.sugar.mobstoeggs.data.GetEntityFileData;
import fyi.sugar.mobstoeggs.events.CapsuleItemCheckEvent;
import fyi.sugar.mobstoeggs.events.CaptureOutcomeEvent;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lfyi/sugar/mobstoeggs/events/CapsuleThrowEvent;", "Lorg/bukkit/event/Listener;", "plugin", "Lfyi/sugar/mobstoeggs/Main;", "(Lfyi/sugar/mobstoeggs/Main;)V", "capsuleStore", "Ljava/util/HashSet;", "Ljava/util/UUID;", "getCapsuleStore", "()Ljava/util/HashSet;", "onCapsuleHitEvent", "", "event", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onCapsuleThrowEvent", "Lorg/bukkit/event/entity/ProjectileLaunchEvent;", "MobsToEggsX"})
public final class CapsuleThrowEvent
implements Listener {
    @NotNull
    private final Main plugin;
    @NotNull
    private final HashSet<UUID> capsuleStore;

    public CapsuleThrowEvent(@NotNull Main plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        this.capsuleStore = new HashSet();
    }

    @NotNull
    public final HashSet<UUID> getCapsuleStore() {
        return this.capsuleStore;
    }

    @EventHandler
    public final void onCapsuleThrowEvent(@NotNull ProjectileLaunchEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProjectileSource launcher = event.getEntity().getShooter();
        Projectile projectile = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)projectile, (String)"event.entity");
        Projectile damager = projectile;
        if (new GetConfigValues(this.plugin).getCatchMethodThrow()) {
            if (launcher != null) {
                if (event.isCancelled()) {
                    event.setCancelled(true);
                    return;
                }
                if (damager.getType() != EntityType.valueOf((String)new GetConfigValues(this.plugin).getCapsuleProjectileType())) {
                    return;
                }
                if (!(launcher instanceof Player)) {
                    return;
                }
                if (((Player)launcher).getInventory().getItemInMainHand().getAmount() > 0) {
                    ItemStack itemStack = ((Player)launcher).getInventory().getItemInMainHand();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"launcher.inventory.itemInMainHand");
                    ItemStack theCapsuleMainHand = itemStack;
                    if (!new CapsuleItemCheckEvent(this.plugin, theCapsuleMainHand).onCapsuleItemCheck()) {
                        return;
                    }
                }
                if (((Player)launcher).getInventory().getItemInOffHand().getAmount() > 0 && ((Player)launcher).getInventory().getItemInMainHand().getAmount() <= 0) {
                    ItemStack itemStack = ((Player)launcher).getInventory().getItemInOffHand();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"launcher.inventory.itemInOffHand");
                    ItemStack theCapsuleOffHand = itemStack;
                    if (!new CapsuleItemCheckEvent(this.plugin, theCapsuleOffHand).onCapsuleItemCheck()) {
                        return;
                    }
                }
                ((ThrowableProjectile)damager).setItem(new ItemStack(Material.valueOf((String)new GetConfigValues(this.plugin).getCapsuleItem())));
                if (new GetConfigValues(this.plugin).getUseThrowEffects()) {
                    ((Player)launcher).getWorld().playSound(((Player)launcher).getLocation(), Sound.valueOf((String)new GetConfigValues(this.plugin).getThrowEffectsSound()), new GetConfigValues(this.plugin).getThrowEffectsSoundVolume(), new GetConfigValues(this.plugin).getThrowEffectsSoundPitch());
                    ((Player)launcher).getWorld().spawnParticle(Particle.valueOf((String)new GetConfigValues(this.plugin).getThrowEffectsParticleType()), ((Player)launcher).getLocation(), new GetConfigValues(this.plugin).getThrowEffectsParticleCount(), 0.5, 0.5, 0.5);
                }
                this.capsuleStore.add(((Player)launcher).getUniqueId());
            } else {
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public final void onCapsuleHitEvent(@NotNull EntityDamageByEntityEvent event) {
        Player playerTarget;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getDamager();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"event.damager");
        Entity capsule = entity;
        Entity entity2 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"event.entity");
        Entity hitEntity = entity2;
        EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.ENTITY_ATTACK;
        if (new GetConfigValues(this.plugin).getCatchMethodThrow()) {
            if (!(capsule instanceof Projectile)) {
                return;
            }
            if (!(((Projectile)capsule).getShooter() instanceof Player)) {
                return;
            }
            ProjectileSource projectileSource = ((Projectile)capsule).getShooter();
            Intrinsics.checkNotNull((Object)projectileSource, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
            playerTarget = (Player)projectileSource;
            if (event.isCancelled()) {
                event.setCancelled(true);
                if (this.capsuleStore.contains(playerTarget.getUniqueId())) {
                    this.capsuleStore.remove(playerTarget.getUniqueId());
                }
                return;
            }
            if (((Projectile)capsule).getType() != EntityType.valueOf((String)new GetConfigValues(this.plugin).getCapsuleProjectileType())) {
                if (this.capsuleStore.contains(playerTarget.getUniqueId())) {
                    this.capsuleStore.remove(playerTarget.getUniqueId());
                }
                return;
            }
            if (!(hitEntity instanceof LivingEntity)) {
                if (this.capsuleStore.contains(playerTarget.getUniqueId())) {
                    this.capsuleStore.remove(playerTarget.getUniqueId());
                }
                return;
            }
            if (this.plugin.getUsingTowny() && CombatUtil.preventDamageCall((Entity)capsule, (Entity)hitEntity, (EntityDamageEvent.DamageCause)cause)) {
                return;
            }
            EntityType entityType = hitEntity.getType();
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"hitEntity.type");
            GetEntityFileData getEntityFile = new GetEntityFileData(this.plugin, entityType);
            boolean isEntityEnabled = getEntityFile.getEntityEnabled();
            if (!isEntityEnabled) {
                if (this.capsuleStore.contains(playerTarget.getUniqueId())) {
                    this.capsuleStore.remove(playerTarget.getUniqueId());
                }
                return;
            }
            if (!this.capsuleStore.contains(playerTarget.getUniqueId())) {
                return;
            }
            if (new GetConfigValues(this.plugin).getGlobalValuesUsePermissions()) {
                StringBuilder stringBuilder = new StringBuilder().append("mobstoeggs.catch.");
                String string = hitEntity.getType().toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!playerTarget.hasPermission(stringBuilder.append(string).toString())) {
                    String string2 = this.plugin.getConfigmanager().getLanguage().getString("catch-fail-no-permission");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"plugin.configmanager.get\u2026atch-fail-no-permission\")");
                    playerTarget.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)StringsKt.replace$default((String)string2, (String)"%mobname%", (String)getEntityFile.getEntityName(), (boolean)false, (int)4, null)));
                    if (this.capsuleStore.contains(playerTarget.getUniqueId())) {
                        this.capsuleStore.remove(playerTarget.getUniqueId());
                    }
                    return;
                }
            }
        } else {
            return;
        }
        this.capsuleStore.remove(playerTarget.getUniqueId());
        new CaptureOutcomeEvent(this.plugin, hitEntity, playerTarget).onOutcome();
    }
}

