/*
 * Decompiled with CFR 0.152.
 */
package net.cactusdev.obsidianraider.handlers;

import java.util.HashMap;
import java.util.List;
import net.cactusdev.obsidianraider.ObsidianRaiderMain;
import net.cactusdev.obsidianraider.PluginInfo;
import net.cactusdev.obsidianraider.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplosionHandler
implements Listener {
    private static HashMap<String, Double> _BlockHealth = new HashMap();

    public ExplosionHandler() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ObsidianRaiderMain.GetInstance());
    }

    private void SortExplosionBlocks(Location source, List<Block> blockList) {
        int radius = PluginInfo.GetExplosionRadius();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    String id;
                    Block block;
                    Location checkLocation = new Location(source.getWorld(), (double)x + source.getX(), (double)y + source.getY(), (double)z + source.getZ());
                    double distToCheckLocationSquared = source.distanceSquared(checkLocation);
                    if (!(distToCheckLocationSquared <= (double)PluginInfo.GetExplosionRadiusSquared()) || !this.IsBlockDamageable(block = checkLocation.getBlock())) continue;
                    double blockDistToSource = Math.sqrt(distToCheckLocationSquared);
                    double damage = 1.0;
                    boolean isSurroundedByWater = false;
                    if (PluginInfo.CheckBlockSurroundedByLiquid()) {
                        boolean bl = isSurroundedByWater = block.getRelative(BlockFace.UP, 1).isLiquid() || block.getRelative(BlockFace.DOWN, 1).isLiquid() || block.getRelative(BlockFace.NORTH, 1).isLiquid() || block.getRelative(BlockFace.SOUTH, 1).isLiquid() || block.getRelative(BlockFace.EAST, 1).isLiquid() || block.getRelative(BlockFace.WEST, 1).isLiquid();
                    }
                    if (PluginInfo.DoesDistanceAffectDamage() && (damage /= blockDistToSource) < PluginInfo.GetMinimumDistanceDamage()) {
                        damage = PluginInfo.GetMinimumDistanceDamage();
                    }
                    if (source.getBlock().isLiquid() || isSurroundedByWater) {
                        damage *= PluginInfo.GetLiquidDamageMultiplier();
                    }
                    if (_BlockHealth.containsKey(id = Utils.GetBlockID(block))) {
                        _BlockHealth.put(id, _BlockHealth.get(id) - damage);
                    } else {
                        _BlockHealth.put(id, this.GetBlockHealth(block) - damage);
                    }
                    if (_BlockHealth.get(id) <= 0.0) {
                        _BlockHealth.remove(id);
                        if (!block.getType().equals((Object)Material.OBSIDIAN)) continue;
                        blockList.add(block);
                        continue;
                    }
                    blockList.remove(block);
                }
            }
        }
    }

    private void DisplayBlockHealth(Player player, Block block) {
        if (block != null) {
            String id = Utils.GetBlockID(block);
            if (_BlockHealth.containsKey(id)) {
                int percent = (int)(_BlockHealth.get(id) * 100.0 / this.GetBlockHealth(block));
                String healthMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ObsidianRaiderMain.GetInstance().getConfig().getString("Message.Block health").replaceFirst("<percent>", String.valueOf(percent)));
                player.sendMessage(healthMessage);
            } else if (this.IsBlockDamageable(block)) {
                String healthMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)ObsidianRaiderMain.GetInstance().getConfig().getString("Message.Block health").replaceFirst("<percent>", "100"));
                player.sendMessage(healthMessage);
            }
        }
    }

    private double GetBlockHealth(Block block) {
        Material m = block.getType();
        return (Double)PluginInfo.GetDamageableBlocks().get(m.toString().toLowerCase());
    }

    private boolean IsBlockDamageable(Block block) {
        Material m = block.getType();
        return PluginInfo.GetDamageableBlocks().containsKey(m.toString().toLowerCase());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void OnBlockBroken(BlockBreakEvent event) {
        String id;
        if (!event.isCancelled() && this.IsBlockDamageable(event.getBlock()) && _BlockHealth.containsKey(id = Utils.GetBlockID(event.getBlock()))) {
            _BlockHealth.remove(id);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void OnPlayerInteract(PlayerInteractEvent event) {
        if (!event.isCancelled()) {
            Player player = event.getPlayer();
            if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && !event.getHand().equals((Object)EquipmentSlot.OFF_HAND) && player.getInventory().getItemInMainHand() != null && player.getInventory().getItemInMainHand().getType().toString().equalsIgnoreCase(PluginInfo.GetHealthCheckItem())) {
                Block block = event.getClickedBlock();
                this.DisplayBlockHealth(player, block);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void OnPrimeExplosion(ExplosionPrimeEvent event) {
        if (!event.isCancelled() && !PluginInfo.IsExplosionRadiusModifierEnabled()) {
            if (event.getEntityType().equals((Object)EntityType.PRIMED_TNT)) {
                event.setRadius(PluginInfo.GetExplosionRadiusTnT());
                return;
            }
            if (event.getEntityType().equals((Object)EntityType.WITHER_SKULL)) {
                event.setRadius(PluginInfo.GetExplosionRadiusWitherSkull());
                return;
            }
            if (event.getEntityType().equals((Object)EntityType.WITHER)) {
                event.setRadius(PluginInfo.GetExplosionRadiusWither());
                return;
            }
            if (event.getEntityType().equals((Object)EntityType.ENDER_CRYSTAL)) {
                event.setRadius(PluginInfo.GetExplosionRadiusEndCrystal());
                return;
            }
            if (event.getEntityType().equals((Object)EntityType.MINECART_TNT)) {
                event.setRadius(PluginInfo.GetExplosionRadiusTnT());
                return;
            }
            if (event.getEntityType().equals((Object)EntityType.CREEPER)) {
                event.setRadius(((Creeper)event.getEntity()).isPowered() ? PluginInfo.GetExplosionRadiusChargedCreeper() : PluginInfo.GetExplosionRadiusCreeper());
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void OnBlockExplode(BlockExplodeEvent event) {
        if (!event.isCancelled()) {
            this.SortExplosionBlocks(event.getBlock().getLocation(), event.blockList());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void OnEntityExplode(EntityExplodeEvent event) {
        if (!event.isCancelled() && event.getEntity() != null) {
            if (!PluginInfo.AreAllExplosionsModified() && event.getEntityType() != EntityType.PRIMED_TNT) {
                return;
            }
            this.SortExplosionBlocks(event.getLocation(), event.blockList());
        }
    }

    public void Dispose() {
        HandlerList.unregisterAll();
    }
}

