/*
 * Decompiled with CFR 0.152.
 */
package dev.codedred.denytravel.data;

import dev.codedred.denytravel.DenyTravel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class CustomFile {
    private DenyTravel plugin;
    private FileConfiguration dataConfig = null;
    private File dataConfigFile = null;
    private final String name;

    public CustomFile(DenyTravel plugin, String fileName) {
        this.plugin = plugin;
        this.name = fileName;
        this.saveDefaultConfig();
    }

    public void reloadConfig() {
        if (this.dataConfigFile == null) {
            this.dataConfigFile = new File(this.plugin.getDataFolder(), this.name);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataConfigFile);
        InputStream defConfigStream = this.plugin.getResource(this.name);
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.dataConfig.setDefaults((Configuration)defConfig);
        }
    }

    public FileConfiguration getConfig() {
        if (this.dataConfig == null) {
            this.reloadConfig();
        }
        return this.dataConfig;
    }

    public void saveConfig() {
        if (this.dataConfig == null || this.dataConfigFile == null) {
            return;
        }
        try {
            this.getConfig().save(this.dataConfigFile);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + this.dataConfigFile, ex);
        }
    }

    public void saveDefaultConfig() {
        if (this.dataConfigFile == null) {
            this.dataConfigFile = new File(this.plugin.getDataFolder(), this.name);
        }
        if (!this.dataConfigFile.exists()) {
            this.plugin.saveResource(this.name, false);
        }
    }
}

