/*
 * Decompiled with CFR 0.152.
 */
package dev.codedred.denytravel.commands;

import com.google.common.collect.Lists;
import dev.codedred.denytravel.data.DataManager;
import dev.codedred.denytravel.enums.Travelers;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class AdminCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        DataManager data = DataManager.getInstance();
        if (!sender.hasPermission("denytravel.admin")) {
            sender.sendMessage(this.format(data.getConfig().getString("messages.no-permission")));
            return true;
        }
        switch (args.length) {
            case 1: {
                if (args[0].equalsIgnoreCase("reload")) {
                    data.reload();
                    data.registerEntities();
                    sender.sendMessage(this.format("&3&lDenyTravel Successfully reloaded and registered config file!"));
                    return true;
                }
                if (args[0].equalsIgnoreCase("list")) {
                    sender.sendMessage(this.format("&3&lEntities Currently Denied:"));
                    ArrayList<String> entities = new ArrayList<String>();
                    Travelers[] travelersArray = Travelers.values();
                    int n = travelersArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Travelers e = travelersArray[n2];
                        if (e.isDenied()) {
                            entities.add(e.toString());
                        }
                        ++n2;
                    }
                    sender.sendMessage(ChatColor.GRAY + ((Object)entities).toString());
                    return true;
                }
            }
            case 3: {
                if (!args[0].equalsIgnoreCase("set")) break;
                if (Travelers.isValid(args[1])) {
                    if (args[2].equalsIgnoreCase("deny")) {
                        Travelers.valueOf(args[1]).setPermission(true);
                        data.getConfig().set("entity-travel.allow-entity." + args[1].toUpperCase(), (Object)true);
                        data.save();
                        sender.sendMessage(this.format("&c&l" + args[1].toUpperCase() + "&c portal travel is now &ldenied&c!"));
                        return true;
                    }
                    if (!args[2].equalsIgnoreCase("allow")) break;
                    Travelers.valueOf(args[1]).setPermission(false);
                    data.getConfig().set("entity-travel.allow-entity." + args[1].toUpperCase(), (Object)false);
                    data.save();
                    sender.sendMessage(this.format("&3&l" + args[1].toUpperCase() + "&3 portal travel is now &lallowed&3!"));
                    return true;
                }
                sender.sendMessage(this.format("&c&l" + args[1].toUpperCase() + "&c is an invalid entry!"));
                sender.sendMessage(this.format("&3&lTry,"));
                ArrayList defaultEntities = Lists.newArrayList((Object[])Travelers.values());
                sender.sendMessage(this.format("&7" + ((Object)defaultEntities).toString()));
                return true;
            }
        }
        sender.sendMessage(this.format("&3&lDenyTravel Usage:"));
        sender.sendMessage(this.format("&3/&7denytravel list"));
        sender.sendMessage(this.format("&3/&7denytravel reload"));
        sender.sendMessage(this.format("&3/&7denytravel set <entity> <deny/allow>"));
        return true;
    }

    private String format(String msg) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }
}

