/*
 * Decompiled with CFR 0.152.
 */
package me.wafflemast3r.unbreakableanvil;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.ArrayList;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin
implements Listener {
    private boolean worldguardenabled;
    private String version;
    private ArrayList<Block> anvilBlocks;
    private String prefix;

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.getConfig().addDefault("Permission.perm", (Object)"unbreakableanvil.use");
        this.getConfig().addDefault("Permission.op", (Object)true);
        this.saveConfig();
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Prefix"));
        if (this.getConfig().getBoolean("WorldGuardSupport")) {
            if (this.getServer().getPluginManager().isPluginEnabled("WorldGuard")) {
                this.worldguardenabled = true;
                this.getServer().getConsoleSender().sendMessage(this.prefix + " WorldGuard found! Using it!");
                this.version = WorldGuardPlugin.inst().getDescription().getVersion();
                System.out.println(this.version);
            } else {
                this.getServer().getConsoleSender().sendMessage(this.prefix + " WorldGuard not found! Running without it!");
            }
        }
        this.anvilBlocks = new ArrayList();
        if (this.getConfig().isConfigurationSection("Anvils")) {
            for (String locSerialized : this.getConfig().getConfigurationSection("Anvils").getKeys(false)) {
                String[] location = locSerialized.split(";");
                Block b = this.getServer().getWorld(Objects.requireNonNull(this.getConfig().getString("Anvils." + locSerialized))).getBlockAt(Integer.parseInt(location[0]), Integer.parseInt(location[1]), Integer.parseInt(location[2]));
                if (b != null && b.getType().equals((Object)Material.ANVIL)) {
                    this.anvilBlocks.add(b);
                    continue;
                }
                this.getConfig().set("Anvils." + locSerialized, null);
                this.saveConfig();
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        if (!e.getBlock().getType().equals((Object)Material.ANVIL)) {
            return;
        }
        if (e.getPlayer().isOp() && !this.getConfig().getBoolean("Permission.op") || !e.getPlayer().hasPermission(this.getConfig().getString("Permission.perm"))) {
            return;
        }
        if (!this.hasAccessToBuild(e.getPlayer(), e.getBlock().getLocation())) {
            return;
        }
        e.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Place").replace("%prefix%", this.prefix)));
        this.anvilBlocks.add(e.getBlock());
        this.getConfig().set("Anvils." + e.getBlock().getX() + ";" + e.getBlock().getY() + ";" + e.getBlock().getZ(), (Object)e.getBlock().getWorld().getName());
        this.saveConfig();
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        boolean bool = false;
        for (Block b : this.anvilBlocks) {
            if (!b.getLocation().equals((Object)e.getBlock().getLocation())) continue;
            bool = true;
            break;
        }
        if (bool) {
            this.anvilBlocks.remove(e.getBlock());
            e.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Messages.Break").replace("%prefix%", this.prefix)));
            this.getConfig().set("Anvils." + e.getBlock().getX() + ";" + e.getBlock().getY() + ";" + e.getBlock().getZ(), null);
            this.saveConfig();
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (e.getClickedBlock() == null) {
            return;
        }
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (!e.getClickedBlock().getType().equals((Object)Material.ANVIL)) {
            return;
        }
        boolean bool = false;
        for (Block b : this.anvilBlocks) {
            if (!b.getLocation().equals((Object)e.getClickedBlock().getLocation())) continue;
            bool = true;
            break;
        }
        if (bool) {
            e.getClickedBlock().setType(Material.ANVIL);
        }
    }

    public boolean hasAccessToBuild(Player p, Location l) {
        if (this.worldguardenabled) {
            if (this.version.startsWith("6")) {
                return WorldGuardPlugin.inst().canBuild(p, l);
            }
            if (this.version.startsWith("7")) {
                RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
                RegionQuery query = container.createQuery();
                if (!query.testState(BukkitAdapter.adapt((Location)l), WorldGuardPlugin.inst().wrapPlayer(p), new StateFlag[]{Flags.BUILD})) {
                    System.out.println("Can't Build");
                    return p.isOp();
                }
            }
        }
        return true;
    }
}

