/*
 * Decompiled with CFR 0.152.
 */
package net.wesjd.anvilgui;

import java.util.function.BiFunction;
import net.wesjd.anvilgui.version.VersionMatcher;
import net.wesjd.anvilgui.version.VersionWrapper;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AnvilGUI {
    private static VersionWrapper WRAPPER = new VersionMatcher().match();
    private final Player holder;
    private final ItemStack insert;
    private final BiFunction<Player, String, String> biFunction;
    private final int containerId;
    private final Inventory inventory;
    private final ListenUp listener = new ListenUp();
    private boolean open;

    @Deprecated
    public AnvilGUI(Plugin plugin, Player holder, String insert, ClickHandler clickHandler) {
        this(plugin, holder, insert, clickHandler::onClick);
    }

    public AnvilGUI(Plugin plugin, Player holder, String insert, BiFunction<Player, String, String> biFunction) {
        this.holder = holder;
        this.biFunction = biFunction;
        ItemStack paper = new ItemStack(Material.PAPER);
        ItemMeta paperMeta = paper.getItemMeta();
        paperMeta.setDisplayName(insert);
        paper.setItemMeta(paperMeta);
        this.insert = paper;
        WRAPPER.handleInventoryCloseEvent(holder);
        WRAPPER.setActiveContainerDefault(holder);
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, plugin);
        Object container = WRAPPER.newContainerAnvil(holder);
        this.inventory = WRAPPER.toBukkitInventory(container);
        this.inventory.setItem(0, this.insert);
        this.containerId = WRAPPER.getNextContainerId(holder);
        WRAPPER.sendPacketOpenWindow(holder, this.containerId);
        WRAPPER.setActiveContainer(holder, container);
        WRAPPER.setActiveContainerId(container, this.containerId);
        WRAPPER.addActiveContainerSlotListener(container, holder);
        this.open = true;
    }

    public void closeInventory() {
        Validate.isTrue((boolean)this.open, (String)"You can't close an inventory that isn't open!");
        this.open = false;
        WRAPPER.handleInventoryCloseEvent(this.holder);
        WRAPPER.setActiveContainerDefault(this.holder);
        WRAPPER.sendPacketCloseWindow(this.holder, this.containerId);
        HandlerList.unregisterAll((Listener)this.listener);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public static class Slot {
        public static final int INPUT_LEFT = 0;
        public static final int INPUT_RIGHT = 1;
        public static final int OUTPUT = 2;
    }

    @Deprecated
    public static abstract class ClickHandler {
        public abstract String onClick(Player var1, String var2);
    }

    private class ListenUp
    implements Listener {
        private ListenUp() {
        }

        @EventHandler
        public void onInventoryClick(InventoryClickEvent e) {
            if (e.getInventory().equals(AnvilGUI.this.inventory)) {
                e.setCancelled(true);
                Player clicker = (Player)e.getWhoClicked();
                if (e.getRawSlot() == 2) {
                    ItemStack clicked = AnvilGUI.this.inventory.getItem(e.getRawSlot());
                    if (clicked == null || clicked.getType() == Material.AIR) {
                        return;
                    }
                    String ret = (String)AnvilGUI.this.biFunction.apply(clicker, clicked.hasItemMeta() ? clicked.getItemMeta().getDisplayName() : clicked.getType().toString());
                    if (ret != null) {
                        ItemMeta meta = clicked.getItemMeta();
                        meta.setDisplayName(ret);
                        clicked.setItemMeta(meta);
                        AnvilGUI.this.inventory.setItem(e.getRawSlot(), clicked);
                    } else {
                        AnvilGUI.this.closeInventory();
                    }
                }
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent e) {
            if (AnvilGUI.this.open && e.getInventory().equals(AnvilGUI.this.inventory)) {
                AnvilGUI.this.closeInventory();
            }
        }
    }
}

