/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorswieton.reportplugin.report;

import com.github.igorswieton.reportplugin.MySqlDataSourceConfiguration;
import com.github.igorswieton.reportplugin.report.Report;
import com.github.igorswieton.reportplugin.report.ReportRepository;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;

@Singleton
public final class MySqlReportRepository
implements ReportRepository {
    private final HikariDataSource dataSource;

    @Inject
    public MySqlReportRepository(MySqlDataSourceConfiguration configuration) {
        this.dataSource = configuration.createConnection();
    }

    public void createTable() {
        String query = "CREATE TABLE IF NOT EXISTS `report_table` (`reason` VARCHAR(50), `author` VARCHAR(17), `victim` VARCHAR(17), `creation_date` DATE)";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void create(Report report) {
        String query = "INSERT INTO `report_table` (`reason`, `author`, `victim`, `creation_date`) VALUES (?, ?, ?, NOW())";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, report.getReason());
            statement.setString(2, report.getAuthor());
            statement.setString(3, report.getVictim());
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void remove(Report report) {
        String query = "DELETE FROM `report_table` WHERE `author` = ?";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, report.getAuthor());
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report getByName(String name) {
        String query = "SELECT * FROM `report_table` WHERE `victim` = ?";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, name);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return null;
            String reason = resultSet.getString("reason");
            String author = resultSet.getString("author");
            String victim = resultSet.getString("victim");
            Report report = new Report(reason, author, victim);
            return report;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public Collection<Report> getAll() {
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isReported(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }
}

