/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorswieton.reportplugin.listeners;

import com.github.igorswieton.reportplugin.ReportPlugin;
import com.github.igorswieton.reportplugin.report.ReportRepository;
import com.google.inject.Inject;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerJoinListener
implements Listener {
    private final ReportPlugin plugin;
    private final ReportRepository reportRepository;

    @Inject
    public PlayerJoinListener(ReportPlugin plugin, ReportRepository reportRepository) {
        this.plugin = plugin;
        this.reportRepository = reportRepository;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        for (Player current : Bukkit.getOnlinePlayers()) {
            if (!this.reportRepository.isReported(current.getName())) continue;
            player.sendMessage(this.getReminderMessage());
        }
    }

    private String getReminderMessage() {
        return "\u00a77\u00a7m---------------\u00a76\u00a7lReminder\u00a77\u00a7m---------------\n\u00a77 \n\u00a77\u00bb There are still outstanding reports!\n \n\u00a77\u00a7m--------------------------------------";
    }
}

