/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorswieton.reportplugin.commands;

import com.github.igorswieton.acf.BaseCommand;
import com.github.igorswieton.acf.annotation.CommandAlias;
import com.github.igorswieton.acf.annotation.CommandCompletion;
import com.github.igorswieton.acf.annotation.CommandPermission;
import com.github.igorswieton.acf.annotation.Default;
import com.github.igorswieton.acf.annotation.Description;
import com.github.igorswieton.acf.annotation.Subcommand;
import com.github.igorswieton.reportplugin.ReportPlugin;
import com.github.igorswieton.reportplugin.report.Report;
import com.github.igorswieton.reportplugin.report.ReportRepository;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.IntStream;
import net.wesjd.anvilgui.AnvilGUI;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="report")
public final class ReportCommand
extends BaseCommand {
    private static final String CHAT_PREFIX = "\u00a7c\u00a7lReports \u00a77\u00bb ";
    private static final String CHAT_CORRECT_USAGE = "\u00a7cCorrect usage\u00a77: /report <player>";
    private static final String CHAT_NOT_AVAILABLE = "This player is currently not available.";
    private static final String REPORT_INVENTORY_NAME = "\u00a7c\u00a7lReports";
    private static final int REPORT_INVENTORY_SIZE = 27;
    private static final Collection<Player> CONTROLLING_PLAYERS = new HashSet<Player>();
    private static final Map<Player, GameMode> GAMEMODE_CACHE = new HashMap<Player, GameMode>();
    private static final Map<Player, ItemStack[]> INVENTORY_CONTENTS_CACHE = new HashMap<Player, ItemStack[]>();
    private static final Map<Player, ItemStack[]> INVENTORY_ARMOR_CONTENTS_CACHE = new HashMap<Player, ItemStack[]>();
    private static final Map<Player, Location> LOCATION_CACHE = new HashMap<Player, Location>();
    private final ReportPlugin plugin;
    private final ReportRepository repository;

    @Inject
    public ReportCommand(ReportPlugin plugin, ReportRepository repository) {
        this.plugin = plugin;
        this.repository = repository;
    }

    @Default
    @CommandCompletion(value="@players")
    @Description(value="Used to report any player and control them.")
    public void execute(Player player, String[] args) {
        if (args.length == 1) {
            Player victim = Bukkit.getPlayer((String)args[0]);
            if (victim == null) {
                player.sendMessage("\u00a7c\u00a7lReports \u00a77\u00bb This player is currently not available.");
                return;
            }
            if (!this.repository.isReported(victim.getName())) {
                this.executeReport(player, victim);
            } else {
                player.sendMessage("\u00a7c\u00a7lReports \u00a77\u00bb This player was already reported.");
            }
        } else if (args.length == 2) {
            if (!player.hasPermission("report.*")) {
                return;
            }
            Player victim = Bukkit.getPlayer((String)args[1]);
            if (victim == null) {
                player.sendMessage("\u00a7c\u00a7lReports \u00a77\u00bb This player is currently not available.");
                return;
            }
            if (args[0].equalsIgnoreCase("control")) {
                if (!this.repository.isReported(victim.getName())) {
                    player.sendMessage("\u00a7c\u00a7lReports \u00a77\u00bb This player has not been reported yet.");
                    return;
                }
                if (!CONTROLLING_PLAYERS.contains(player)) {
                    this.startControl(player, victim);
                }
            }
        } else {
            player.sendMessage(CHAT_CORRECT_USAGE);
        }
    }

    @Subcommand(value="control @")
    @CommandCompletion(value="@players")
    @CommandPermission(value="report.*")
    @Description(value="Just serves to complete the command for users with certain permission.")
    public void onTabComlete() {
    }

    @Subcommand(value="close")
    @CommandCompletion(value="close")
    @CommandPermission(value="report.*")
    @Description(value="Used to close the current controlling process.")
    public void executeReportControl(Player player) {
        if (CONTROLLING_PLAYERS.contains(player)) {
            this.closeControl(player);
        } else {
            player.sendMessage("\u00a7c\u00a7lReports \u00a77\u00bb You do not control anyone at the moment.");
        }
    }

    private void executeReport(Player player, Player victim) {
        new AnvilGUI((Plugin)this.plugin, player, "report reason", (author, reason) -> {
            author.sendMessage(this.getReportMessage((String)reason, victim));
            Bukkit.getOnlinePlayers().stream().filter(current -> current.hasPermission("report.*")).forEach(current -> current.sendMessage(this.getNotificationMessage((String)reason, (Player)author, victim)));
            Report report = new Report((String)reason, author.getName(), victim.getName());
            if (!this.repository.isReported(victim.getName())) {
                this.repository.create(report);
            }
            return null;
        });
    }

    private void startControl(Player player, Player victim) {
        GAMEMODE_CACHE.put(player, player.getGameMode());
        INVENTORY_CONTENTS_CACHE.put(player, player.getInventory().getContents());
        INVENTORY_ARMOR_CONTENTS_CACHE.put(player, player.getInventory().getArmorContents());
        LOCATION_CACHE.put(player, player.getLocation());
        player.setGameMode(GameMode.SPECTATOR);
        player.getInventory().clear();
        player.getInventory().setArmorContents(null);
        player.teleport((Entity)victim);
        CONTROLLING_PLAYERS.add(player);
        this.clearChat(player);
        player.sendMessage(this.getControlMessage(player, victim));
        Report report = this.repository.getByName(victim.getName());
        this.repository.remove(report);
    }

    private void closeControl(Player player) {
        player.setGameMode(GAMEMODE_CACHE.get(player));
        player.getInventory().setContents(INVENTORY_CONTENTS_CACHE.get(player));
        player.getInventory().setArmorContents(INVENTORY_ARMOR_CONTENTS_CACHE.get(player));
        player.teleport(LOCATION_CACHE.get(player));
        CONTROLLING_PLAYERS.remove(player);
        this.clearChat(player);
        player.sendMessage(this.getCloseMessage());
    }

    private void clearChat(Player player) {
        IntStream.range(0, 200).mapToObj(i -> " ").forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
    }

    private String getReportMessage(String reason, Player victim) {
        return "\u00a77\u00a7m---------------\u00a7c\u00a7lReports\u00a77\u00a7m---------------\n\u00a77 \n\u00a77\u00bb Thank you for your \u00a7c\u00a7lReport\u00a77!\n \n\u00a77\u00bb \u00a76Reason\u00a77: " + reason + "\n\u00a77\u00bb \u00a76Victim\u00a77: " + victim.getName() + "\n \n\u00a77\u00bb The team will take care of it within a few minutes.\n \n\u00a77\u00a7m-------------------------------------";
    }

    private String getNotificationMessage(String reason, Player author, Player victim) {
        return "\u00a77\u00a7m---------------\u00a7c\u00a7lReports\u00a77\u00a7m---------------\n\u00a77 \n\u00a77\u00bb A new \u00a7c\u00a7lreport \u00a77has been received!\n \n\u00a77\u00bb \u00a76Reason\u00a77: " + reason + "\n\u00a77\u00bb \u00a76Author\u00a77: " + author.getName() + "\n\u00a77\u00bb \u00a76Victim\u00a77: " + victim.getName() + "\n \n\u00a77\u00bb Type \u00a76/report control <victim> \u00a77to take a look.\n \n\u00a77\u00a7m-------------------------------------";
    }

    private String getControlMessage(Player player, Player victim) {
        return "\u00a77\u00a7m---------------\u00a7c\u00a7lReports\u00a77\u00a7m---------------\n\u00a77 \n\u00a77\u00bb You are controlling now " + victim.getName() + "\n\u00a77\u00bb If you're done, type \u00a76/report close\u00a77.\n \n\u00a77\u00a7m-------------------------------------";
    }

    private String getCloseMessage() {
        return "\u00a77\u00a7m---------------\u00a7c\u00a7lReports\u00a77\u00a7m---------------\n\u00a77 \n\u00a77\u00bb Your controlling process has been closed.\n\u00a77\u00bb Your previous game data has been loaded.\n \n\u00a77\u00a7m-------------------------------------";
    }
}

