/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorswieton.reportplugin;

import com.github.igorswieton.reportplugin.MySqlDataSourceConfiguration;
import com.github.igorswieton.reportplugin.ReportPlugin;
import com.github.igorswieton.reportplugin.annotation.Database;
import com.github.igorswieton.reportplugin.annotation.Host;
import com.github.igorswieton.reportplugin.annotation.Password;
import com.github.igorswieton.reportplugin.annotation.Port;
import com.github.igorswieton.reportplugin.annotation.Username;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;

public final class BinderModule
extends AbstractModule {
    private final ReportPlugin plugin;
    private final String username;
    private final Integer port;
    private final String database;
    private final String host;
    private final String password;

    BinderModule(ReportPlugin plugin) {
        this.plugin = plugin;
        this.username = plugin.getConfig().getString("MySQL.Username");
        this.port = plugin.getConfig().getInt("MySQL.Port");
        this.database = plugin.getConfig().getString("MySQL.Database");
        this.host = plugin.getConfig().getString("MySQL.Host");
        this.password = plugin.getConfig().getString("MySQL.Password");
    }

    Injector createInjector() {
        return Guice.createInjector(this);
    }

    @Override
    protected void configure() {
        this.bind(ReportPlugin.class).toInstance(this.plugin);
        this.bind(MySqlDataSourceConfiguration.class);
        this.bind(String.class).annotatedWith(Username.class).toInstance(this.username);
        this.bind(Integer.class).annotatedWith(Port.class).toInstance(this.port);
        this.bind(String.class).annotatedWith(Database.class).toInstance(this.database);
        this.bind(String.class).annotatedWith(Host.class).toInstance(this.host);
        this.bind(String.class).annotatedWith(Password.class).toInstance(this.password);
    }
}

