/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorswieton.acf;

import com.github.igorswieton.acf.ACFUtil;
import com.github.igorswieton.acf.CommandManager;
import com.github.igorswieton.acf.CommandParameter;
import com.github.igorswieton.acf.RegisteredCommand;
import com.github.igorswieton.acf.RootCommand;
import com.github.igorswieton.acf.apachecommonslang.ApacheCommonsLangUtil;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

class CommandRouter {
    private final CommandManager manager;

    CommandRouter(CommandManager manager) {
        this.manager = manager;
    }

    CommandRouteResult matchCommand(RouteSearch search, boolean completion) {
        Set<RegisteredCommand> cmds = search.commands;
        String[] args = search.args;
        if (!cmds.isEmpty()) {
            if (cmds.size() == 1) {
                return new CommandRouteResult(ACFUtil.getFirstElement(cmds), search);
            }
            Optional<RegisteredCommand> optCmd = cmds.stream().filter(c -> this.isProbableMatch((RegisteredCommand)c, args, completion)).min((c1, c2) -> {
                int a = c1.consumeInputResolvers;
                int b = c2.consumeInputResolvers;
                if (a == b) {
                    return 0;
                }
                return a < b ? 1 : -1;
            });
            if (optCmd.isPresent()) {
                return new CommandRouteResult(optCmd.get(), search);
            }
        }
        return null;
    }

    private boolean isProbableMatch(RegisteredCommand c, String[] args, boolean completion) {
        int required = c.requiredResolvers;
        int optional = c.optionalResolvers;
        return args.length <= required + optional && (completion || args.length >= required);
    }

    RouteSearch routeCommand(RootCommand command, String commandLabel, String[] args, boolean completion) {
        int argLength;
        SetMultimap<String, RegisteredCommand> subCommands = command.getSubCommands();
        for (int i = argLength = args.length; i >= 0; --i) {
            String subcommand = ApacheCommonsLangUtil.join((Object[])args, " ", 0, i).toLowerCase();
            Set<RegisteredCommand> cmds = subCommands.get(subcommand);
            if (cmds.isEmpty()) continue;
            return new RouteSearch(cmds, Arrays.copyOfRange(args, i, argLength), commandLabel, subcommand, completion);
        }
        Set<RegisteredCommand> defaultCommands = subCommands.get("__default");
        Set<RegisteredCommand> unknownCommands = subCommands.get("__catchunknown");
        if (!defaultCommands.isEmpty()) {
            HashSet<RegisteredCommand> matchedDefault = new HashSet<RegisteredCommand>();
            for (RegisteredCommand c : defaultCommands) {
                CommandParameter lastParam;
                int required = c.requiredResolvers;
                int optional = c.optionalResolvers;
                CommandParameter commandParameter = lastParam = c.parameters.length > 0 ? c.parameters[c.parameters.length - 1] : null;
                if (argLength > required + optional && (lastParam == null || lastParam.getType() != String[].class && (argLength < required || !lastParam.consumesRest))) continue;
                matchedDefault.add(c);
            }
            if (!matchedDefault.isEmpty()) {
                return new RouteSearch(matchedDefault, args, commandLabel, null, completion);
            }
        }
        if (!unknownCommands.isEmpty()) {
            return new RouteSearch(unknownCommands, args, commandLabel, null, completion);
        }
        return null;
    }

    static class RouteSearch {
        final String[] args;
        final Set<RegisteredCommand> commands;
        final String commandLabel;
        final String subcommand;

        RouteSearch(Set<RegisteredCommand> commands, String[] args, String commandLabel, String subcommand, boolean completion) {
            this.commands = commands;
            this.args = args;
            this.commandLabel = commandLabel.toLowerCase();
            this.subcommand = subcommand;
        }
    }

    static class CommandRouteResult {
        final RegisteredCommand cmd;
        final String[] args;
        final String commandLabel;
        final String subcommand;

        CommandRouteResult(RegisteredCommand cmd, RouteSearch search) {
            this(cmd, search.args, search.subcommand, search.commandLabel);
        }

        CommandRouteResult(RegisteredCommand cmd, String[] args, String subcommand, String commandLabel) {
            this.cmd = cmd;
            this.args = args;
            this.commandLabel = commandLabel;
            this.subcommand = subcommand;
        }
    }
}

