/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorswieton.acf;

import co.aikar.locales.MessageKeyProvider;
import com.github.igorswieton.acf.ACFPatterns;
import com.github.igorswieton.acf.ACFUtil;
import com.github.igorswieton.acf.CommandExecutionContext;
import com.github.igorswieton.acf.CommandHelp;
import com.github.igorswieton.acf.CommandIssuer;
import com.github.igorswieton.acf.CommandManager;
import com.github.igorswieton.acf.InvalidCommandArgument;
import com.github.igorswieton.acf.LogLevel;
import com.github.igorswieton.acf.MessageKeys;
import com.github.igorswieton.acf.annotation.Single;
import com.github.igorswieton.acf.annotation.Split;
import com.github.igorswieton.acf.annotation.Values;
import com.github.igorswieton.acf.contexts.ContextResolver;
import com.github.igorswieton.acf.contexts.IssuerAwareContextResolver;
import com.github.igorswieton.acf.contexts.IssuerOnlyContextResolver;
import com.github.igorswieton.acf.contexts.OptionalContextResolver;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CommandContexts<R extends CommandExecutionContext<?, ? extends CommandIssuer>> {
    protected final Map<Class<?>, ContextResolver<?, R>> contextMap = new HashMap();
    protected final CommandManager manager;

    CommandContexts(CommandManager manager) {
        this.manager = manager;
        this.registerIssuerOnlyContext(CommandIssuer.class, c -> c.getIssuer());
        this.registerContext(Short.class, c -> {
            try {
                return this.parseAndValidateNumber(c, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE).shortValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(Short.TYPE, c -> {
            try {
                return this.parseAndValidateNumber(c, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE).shortValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(Integer.class, c -> {
            try {
                return this.parseAndValidateNumber(c, Integer.MIN_VALUE, Integer.MAX_VALUE).intValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(Integer.TYPE, c -> {
            try {
                return this.parseAndValidateNumber(c, Integer.MIN_VALUE, Integer.MAX_VALUE).intValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(Long.class, c -> {
            try {
                return this.parseAndValidateNumber(c, Long.MIN_VALUE, Long.MAX_VALUE).longValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(Long.TYPE, c -> {
            try {
                return this.parseAndValidateNumber(c, Long.MIN_VALUE, Long.MAX_VALUE).longValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(Float.class, c -> {
            try {
                return Float.valueOf(this.parseAndValidateNumber(c, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE)).floatValue());
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(Float.TYPE, c -> {
            try {
                return Float.valueOf(this.parseAndValidateNumber(c, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE)).floatValue());
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(Double.class, c -> {
            try {
                return this.parseAndValidateNumber(c, -1.7976931348623157E308, Double.MAX_VALUE).doubleValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(Double.TYPE, c -> {
            try {
                return this.parseAndValidateNumber(c, -1.7976931348623157E308, Double.MAX_VALUE).doubleValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(Number.class, c -> {
            try {
                return this.parseAndValidateNumber(c, -1.7976931348623157E308, Double.MAX_VALUE);
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(BigDecimal.class, c -> {
            try {
                BigDecimal number = ACFUtil.parseBigNumber(c.popFirstArg(), c.hasFlag("suffixes"));
                this.validateMinMax(c, number);
                return number;
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(BigInteger.class, c -> {
            try {
                BigDecimal number = ACFUtil.parseBigNumber(c.popFirstArg(), c.hasFlag("suffixes"));
                this.validateMinMax(c, number);
                return number.toBigIntegerExact();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, "{num}", c.getFirstArg());
            }
        });
        this.registerContext(Boolean.class, c -> ACFUtil.isTruthy(c.popFirstArg()));
        this.registerContext(Boolean.TYPE, c -> ACFUtil.isTruthy(c.popFirstArg()));
        this.registerContext(Character.TYPE, c -> {
            String s = c.popFirstArg();
            if (s.length() > 1) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_MAX_LENGTH, "{max}", String.valueOf(1));
            }
            return Character.valueOf(s.charAt(0));
        });
        this.registerContext(String.class, c -> {
            if (c.hasAnnotation(Values.class)) {
                return c.popFirstArg();
            }
            String ret = c.isLastArg() && !c.hasAnnotation(Single.class) ? ACFUtil.join(c.getArgs()) : c.popFirstArg();
            Integer minLen = c.getFlagValue("minlen", (Integer)null);
            Integer maxLen = c.getFlagValue("maxlen", (Integer)null);
            if (minLen != null && ret.length() < minLen) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_MIN_LENGTH, "{min}", String.valueOf(minLen));
            }
            if (maxLen != null && ret.length() > maxLen) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_MAX_LENGTH, "{max}", String.valueOf(maxLen));
            }
            return ret;
        });
        this.registerContext(String[].class, c -> {
            List<String> args = c.getArgs();
            String val = c.isLastArg() && !c.hasAnnotation(Single.class) ? ACFUtil.join(args) : c.popFirstArg();
            String split = c.getAnnotationValue(Split.class, 8);
            if (split != null) {
                if (val.isEmpty()) {
                    throw new InvalidCommandArgument();
                }
                return ACFPatterns.getPattern(split).split(val);
            }
            if (!c.isLastArg()) {
                ACFUtil.sneaky(new IllegalStateException("Weird Command signature... String[] should be last or @Split"));
            }
            String[] result = args.toArray(new String[0]);
            args.clear();
            return result;
        });
        this.registerContext(Enum.class, c -> {
            String first = c.popFirstArg();
            Class<?> enumCls = c.getParam().getType();
            Object match = ACFUtil.simpleMatch(enumCls, first);
            if (match == null) {
                List<String> names = ACFUtil.enumNames(enumCls);
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", ACFUtil.join(names, ", "));
            }
            return match;
        });
        this.registerOptionalContext(CommandHelp.class, c -> {
            String cmd;
            String first = c.getFirstArg();
            String last = c.getLastArg();
            int page = 1;
            List<String> search = null;
            if (last != null && ACFUtil.isInteger(last)) {
                c.popLastArg();
                page = ACFUtil.parseInt(last);
                if (!c.getArgs().isEmpty()) {
                    search = c.getArgs();
                }
            } else if (first != null && ACFUtil.isInteger(first)) {
                c.popFirstArg();
                page = ACFUtil.parseInt(first);
                if (!c.getArgs().isEmpty()) {
                    search = c.getArgs();
                }
            } else if (!c.getArgs().isEmpty()) {
                search = c.getArgs();
            }
            CommandHelp commandHelp = manager.generateCommandHelp();
            commandHelp.setPage(page);
            Integer perPage = c.getFlagValue("perpage", (Integer)null);
            if (perPage != null) {
                commandHelp.setPerPage(perPage);
            }
            if (search != null && commandHelp.testExactMatch(cmd = String.join((CharSequence)" ", search))) {
                return commandHelp;
            }
            commandHelp.setSearch(search);
            return commandHelp;
        });
    }

    @NotNull
    private Number parseAndValidateNumber(R c, Number minValue, Number maxValue) throws InvalidCommandArgument {
        Number val = ACFUtil.parseNumber(((CommandExecutionContext)c).popFirstArg(), ((CommandExecutionContext)c).hasFlag("suffixes"));
        this.validateMinMax(c, val, minValue, maxValue);
        return val;
    }

    private void validateMinMax(R c, Number val) throws InvalidCommandArgument {
        this.validateMinMax(c, val, null, null);
    }

    private void validateMinMax(R c, Number val, Number minValue, Number maxValue) throws InvalidCommandArgument {
        minValue = ((CommandExecutionContext)c).getFlagValue("min", minValue);
        if ((maxValue = ((CommandExecutionContext)c).getFlagValue("max", maxValue)) != null && val.doubleValue() > maxValue.doubleValue()) {
            throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_AT_MOST, "{max}", String.valueOf(maxValue));
        }
        if (minValue != null && val.doubleValue() < minValue.doubleValue()) {
            throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_AT_LEAST, "{min}", String.valueOf(minValue));
        }
    }

    @Deprecated
    public <T> void registerSenderAwareContext(Class<T> context, IssuerAwareContextResolver<T, R> supplier) {
        this.contextMap.put(context, supplier);
    }

    public <T> void registerIssuerAwareContext(Class<T> context, IssuerAwareContextResolver<T, R> supplier) {
        this.contextMap.put(context, supplier);
    }

    public <T> void registerIssuerOnlyContext(Class<T> context, IssuerOnlyContextResolver<T, R> supplier) {
        this.contextMap.put(context, supplier);
    }

    public <T> void registerOptionalContext(Class<T> context, OptionalContextResolver<T, R> supplier) {
        this.contextMap.put(context, supplier);
    }

    public <T> void registerContext(Class<T> context, ContextResolver<T, R> supplier) {
        this.contextMap.put(context, supplier);
    }

    public ContextResolver<?, R> getResolver(Class<?> type) {
        Class<?> rootType = type;
        while (type != Object.class) {
            ContextResolver<?, R> resolver = this.contextMap.get(type);
            if (resolver != null) {
                return resolver;
            }
            if ((type = type.getSuperclass()) != null) continue;
        }
        this.manager.log(LogLevel.ERROR, "Could not find context resolver", new IllegalStateException("No context resolver defined for " + rootType.getName()));
        return null;
    }
}

