/*
 * Decompiled with CFR 0.152.
 */
package tk.bevan.twofactor;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MainPlugin
extends JavaPlugin
implements Listener {
    private ArrayList<UUID> auth_locked;
    private ArrayList<UUID> auth_locked_new_ip;
    private ArrayList<UUID> auth_locked_disable;
    private GoogleAuthenticator gAuth;
    private boolean skip_2fa_if_ip_matches;

    public void onEnable() {
        this.auth_locked = new ArrayList();
        this.auth_locked_new_ip = new ArrayList();
        this.auth_locked_disable = new ArrayList();
        this.gAuth = new GoogleAuthenticator();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.skip_2fa_if_ip_matches = this.getConfig().getBoolean("options.skip-if-ip-matches");
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (p.hasPermission("2fa.force")) {
            if (this.getConfig().contains("auth-codes." + p.getUniqueId())) {
                if (this.skip_2fa_if_ip_matches) {
                    if (p.getAddress().getHostString().equals(this.getConfig().getString("auth-codes." + p.getUniqueId() + ".last-ip"))) {
                        p.sendMessage(ChatColor.GREEN + "Your last IP matches your current IP, so you do not need to enter your 2FA code.");
                    } else {
                        this.auth_locked.add(p.getUniqueId());
                        this.auth_locked_new_ip.add(p.getUniqueId());
                        p.sendMessage(ChatColor.GRAY + "Your last IP does not match your current IP.");
                        p.sendMessage(ChatColor.GRAY + "Please enter your 2FA code from Google Authenticator to access the server.");
                    }
                } else {
                    this.auth_locked.add(p.getUniqueId());
                    p.sendMessage(ChatColor.GRAY + "Please enter your 2FA code from Google Authenticator to access the server.");
                }
            } else {
                this.auth_locked.add(p.getUniqueId());
                this.auth_locked_new_ip.add(p.getUniqueId());
                GoogleAuthenticatorKey gKey = this.gAuth.createCredentials();
                this.getConfig().set("auth-codes." + p.getUniqueId() + ".secret", (Object)gKey.getKey());
                this.getConfig().set("auth-codes." + p.getUniqueId() + ".last-ip", (Object)p.getAddress().getHostString());
                this.saveConfig();
                p.sendMessage(ChatColor.GRAY + "Your account has been forced to use 2FA, which is not set up.");
                p.sendMessage(ChatColor.GRAY + "Your 2FA secret is " + ChatColor.GREEN + gKey.getKey());
                p.sendMessage(ChatColor.GRAY + "Please enter your 2FA secret into Google Authenticator and enter the resulting code into chat.");
            }
        } else if (p.hasPermission("2fa.use") && this.getConfig().contains("auth-codes." + p.getUniqueId())) {
            if (this.skip_2fa_if_ip_matches) {
                if (p.getAddress().getHostString().equals(this.getConfig().getString("auth-codes." + p.getUniqueId() + ".last-ip"))) {
                    p.sendMessage(ChatColor.GREEN + "Your last IP matches your current IP, so you do not need to enter your 2FA code.");
                } else {
                    this.auth_locked.add(p.getUniqueId());
                    this.auth_locked_new_ip.add(p.getUniqueId());
                    p.sendMessage(ChatColor.GRAY + "Your last IP does not match your current IP.");
                    p.sendMessage(ChatColor.GRAY + "Please enter your 2FA code from Google Authenticator to access the server.");
                }
            } else {
                this.auth_locked.add(p.getUniqueId());
                p.sendMessage(ChatColor.GRAY + "Please enter your 2FA code from Google Authenticator to access the server.");
            }
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        if (this.auth_locked.contains(p.getUniqueId())) {
            int c;
            String m = e.getMessage();
            try {
                c = Integer.parseInt(m);
            }
            catch (Exception ex) {
                p.sendMessage(ChatColor.RED + "Invalid 2FA code.");
                e.setCancelled(true);
                return;
            }
            if (this.gAuth.authorize(this.getConfig().getString("auth-codes." + p.getUniqueId() + ".secret"), c)) {
                p.sendMessage(ChatColor.GREEN + "Your 2FA code is correct!");
                e.setCancelled(true);
                this.auth_locked.remove(p.getUniqueId());
                if (this.auth_locked_new_ip.contains(p.getUniqueId())) {
                    this.auth_locked_new_ip.remove(p.getUniqueId());
                    this.getConfig().set("auth-codes." + p.getUniqueId() + ".last-ip", (Object)p.getAddress().getHostString());
                    this.saveConfig();
                }
            } else {
                p.sendMessage(ChatColor.RED + "Invalid 2FA code.");
                e.setCancelled(true);
            }
        } else if (this.auth_locked_disable.contains(p.getUniqueId())) {
            int c;
            String m = e.getMessage();
            try {
                c = Integer.parseInt(m);
            }
            catch (Exception ex) {
                p.sendMessage(ChatColor.RED + "Invalid 2FA code.");
                e.setCancelled(true);
                return;
            }
            if (this.gAuth.authorize(this.getConfig().getString("auth-codes." + p.getUniqueId() + ".secret"), c)) {
                p.sendMessage(ChatColor.GREEN + "You have disabled 2FA!");
                e.setCancelled(true);
                this.auth_locked_disable.remove(p.getUniqueId());
                this.getConfig().set("auth-codes." + p.getUniqueId(), null);
                this.saveConfig();
            } else {
                p.sendMessage(ChatColor.RED + "Invalid 2FA code.");
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        if (this.auth_locked.contains(e.getPlayer().getUniqueId()) || this.auth_locked_disable.contains(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (this.auth_locked.contains(e.getPlayer().getUniqueId()) || this.auth_locked_disable.contains(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        if (this.auth_locked.contains(e.getPlayer().getUniqueId()) || this.auth_locked_disable.contains(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equals("2fa")) return false;
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can use this command!");
            return false;
        }
        Player p = (Player)sender;
        if (!(p.hasPermission("2fa.use") || p.hasPermission("2fa.force") || p.hasPermission("2fa.admin"))) {
            p.sendMessage(ChatColor.RED + "You do not have permission to use 2FA!");
            return true;
        }
        if (args.length == 0) {
            p.sendMessage(ChatColor.GRAY + "" + ChatColor.BOLD + "Bevan's 2FA" + ChatColor.RESET);
            p.sendMessage(ChatColor.GRAY + "Author: Bevan");
            p.sendMessage(ChatColor.GRAY + "Version: 1.0");
            return true;
        }
        if (args[0].equals("disable")) {
            if (!this.getConfig().contains("auth-codes." + p.getUniqueId())) {
                p.sendMessage(ChatColor.RED + "You must setup 2FA!");
                return true;
            }
            if (p.hasPermission("2fa.force")) {
                p.sendMessage(ChatColor.RED + "You have been forced to use 2FA, so you cannot disable it.");
                return false;
            }
            this.auth_locked_disable.add(p.getUniqueId());
            p.sendMessage(ChatColor.GRAY + "Type in your 2FA code into chat to disable 2FA!");
            return true;
        }
        if (!args[0].equals("setup")) {
            p.sendMessage(ChatColor.RED + "You did not specify a valid option!");
            return true;
        }
        if (this.getConfig().contains("auth-codes." + p.getUniqueId())) {
            p.sendMessage(ChatColor.RED + "You have already setup 2FA!");
            return true;
        }
        if (p.hasPermission("2fa.use")) {
            this.auth_locked.add(p.getUniqueId());
            this.auth_locked_new_ip.add(p.getUniqueId());
            GoogleAuthenticatorKey gKey = this.gAuth.createCredentials();
            this.getConfig().set("auth-codes." + p.getUniqueId() + ".secret", (Object)gKey.getKey());
            this.getConfig().set("auth-codes." + p.getUniqueId() + ".last-ip", (Object)p.getAddress().getHostString());
            this.saveConfig();
            p.sendMessage(ChatColor.GRAY + "Your 2FA secret is " + ChatColor.GREEN + gKey.getKey());
            p.sendMessage(ChatColor.GRAY + "Please enter your 2FA secret into Google Authenticator and enter the resulting code into chat to enable 2FA.");
            return true;
        }
        p.sendMessage(ChatColor.RED + "You do not have permission to setup 2FA!");
        return true;
    }
}

