/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.utils;

import me.sirrus86.s86powers.localization.LocaleString;

public class PowerTime {
    private static final byte MILLISECONDS_PER_TICK = 50;
    private static final short MILLISECONDS_PER_SECOND = 1000;
    private static final int MILLISECONDS_PER_MINUTE = 60000;
    private static final int MILLISECONDS_PER_HOUR = 3600000;
    private static final int MILLISECONDS_PER_DAY = 86400000;

    public static String asClock(long millis, boolean showDays, boolean showHours, boolean showMinutes, boolean showSeconds, boolean showMillis) {
        String tmp = "";
        long time = millis;
        long remain = 0L;
        if ((millis >= 86400000L || showDays) && time >= 86400000L) {
            remain = time / 86400000L;
            tmp = tmp + remain + ":";
            time %= 86400000L;
        }
        if (millis >= 3600000L || showHours) {
            if (time >= 3600000L) {
                remain = time / 3600000L;
                tmp = tmp + (remain > 9L ? Long.valueOf(remain) : "0" + remain) + ":";
                time %= 3600000L;
            } else {
                tmp = tmp + "00:";
            }
        }
        if (millis >= 60000L || showMinutes) {
            if (time >= 60000L) {
                remain = time / 60000L;
                tmp = tmp + (remain > 9L ? Long.valueOf(remain) : "0" + remain) + ":";
                time %= 60000L;
            } else {
                tmp = tmp + "00:";
            }
        }
        if (millis >= 1000L || showSeconds) {
            if (time >= 1000L) {
                remain = time / 1000L;
                tmp = tmp + (remain > 9L ? Long.valueOf(remain) : "0" + remain);
                time %= 1000L;
            } else {
                tmp = tmp + "00:";
            }
        }
        if (time > 0L && showMillis) {
            remain = time;
            tmp = tmp + "." + (remain > 99L ? "" : "0") + (remain > 9L ? "" : "0") + remain;
        }
        if (tmp.endsWith(":")) {
            tmp = tmp.substring(0, tmp.lastIndexOf(":"));
        }
        return tmp;
    }

    public static String asString(long millis) {
        String tmp = "";
        long time = millis;
        if (time >= 86400000L) {
            tmp = tmp + time / 86400000L + "d";
            time %= 86400000L;
        }
        if (time >= 3600000L) {
            tmp = tmp + time / 3600000L + "h";
            time %= 3600000L;
        }
        if (time >= 60000L) {
            tmp = tmp + time / 60000L + "m";
            time %= 60000L;
        }
        if (time >= 1000L) {
            tmp = tmp + time / 1000L + "s";
            time %= 1000L;
        }
        if (time > 0L) {
            tmp = tmp + time / 50L + "t";
        }
        return tmp != "" ? tmp : LocaleString.NONE.toString();
    }

    public static String asLongString(long millis) {
        String tmp = "";
        long time = millis;
        if (time >= 86400000L) {
            tmp = tmp + time / 86400000L + (time / 86400000L == 1L ? " " + LocaleString.DAY.toString() + " " : " " + LocaleString.DAYS.toString() + " ");
            time %= 86400000L;
        }
        if (time >= 3600000L) {
            tmp = tmp + time / 3600000L + (time / 3600000L == 1L ? " " + LocaleString.HOUR.toString() + " " : " " + LocaleString.HOURS.toString() + " ");
            time %= 3600000L;
        }
        if (time >= 60000L) {
            tmp = tmp + time / 60000L + (time / 60000L == 1L ? " " + LocaleString.MINUTE.toString() + " " : " " + LocaleString.MINUTES.toString() + " ");
            time %= 60000L;
        }
        if (time >= 1000L) {
            tmp = tmp + time / 1000L + (time / 1000L == 1L ? " " + LocaleString.SECOND.toString() + " " : " " + LocaleString.SECONDS.toString() + " ");
        }
        if (tmp.equalsIgnoreCase("")) {
            return LocaleString.LESS_THAN_ONE_SECOND.toString();
        }
        tmp = tmp.substring(0, tmp.lastIndexOf(" "));
        return tmp;
    }

    public static long toMillis(int ... time) {
        int millis = 0;
        for (int i = 0; i < time.length; ++i) {
            if (i == time.length - 1) {
                millis += time[i];
                continue;
            }
            if (i == time.length - 2) {
                millis += time[i] * 1000;
                continue;
            }
            if (i == time.length - 3) {
                millis += time[i] * 60000;
                continue;
            }
            if (i == time.length - 4) {
                millis += time[i] * 3600000;
                continue;
            }
            if (i != time.length - 5) continue;
            millis += time[i] * 86400000;
        }
        return millis;
    }

    public static long toMillis(String time) {
        int millis = 0;
        if (time.contains(":")) {
            String[] times = time.split(":");
            for (int i = 0; i < times.length; ++i) {
                if (i == times.length - 1) {
                    if (times[i].contains(".")) {
                        String[] secs = times[i].split(".");
                        millis += Integer.parseInt(secs[0]);
                        millis += Integer.parseInt(secs[1].substring(0, 2));
                        continue;
                    }
                    millis += Integer.parseInt(times[i]) * 1000;
                    continue;
                }
                if (i == times.length - 2) {
                    millis += Integer.parseInt(times[i]) * 60000;
                    continue;
                }
                if (i == times.length - 3) {
                    millis += Integer.parseInt(times[i]) * 3600000;
                    continue;
                }
                if (i != times.length - 4) continue;
                millis += Integer.parseInt(times[i]) * 86400000;
            }
            return millis;
        }
        return Long.parseLong(time);
    }

    public static long toTicks(long millis) {
        return millis / 50L;
    }

    public static int toTicks(int ... time) {
        return (int)PowerTime.toTicks(PowerTime.toMillis(time));
    }
}

