/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.tools.version.MCServer;
import me.sirrus86.s86powers.tools.version.MCVersion;
import me.sirrus86.s86powers.utils.IOHelper;
import me.sirrus86.s86powers.utils.PowerClassLoader;

public class PowerLoader {
    private static final String POWER_PREFIX = "me.sirrus86.s86powers.powers.internal.";
    private static final String[] TYPE_PREFIX = new String[]{"defense.", "offense.", "passive.", "utility.", ""};

    public PowerLoader(File file) {
        this.load(file);
    }

    private void load(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    String o2name;
                    int o2dot;
                    String o1name = o1.getName();
                    int o1dot = o1name.lastIndexOf(46);
                    if (o1dot == -1 == ((o2dot = (o2name = o2.getName()).lastIndexOf(46)) == -1)) {
                        o1name = o1name.substring(o1dot + 1);
                        o2name = o2name.substring(o2dot + 1);
                        return o1name.compareTo(o2name);
                    }
                    if (o1dot == -1) {
                        return -1;
                    }
                    return 1;
                }
            });
            try {
                PowerClassLoader loader = new PowerClassLoader(file.toURI().toURL());
                for (File item : files) {
                    this.load(item, (ClassLoader)loader);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (IOHelper.isJar(file)) {
            try {
                PowerClassLoader loader = new PowerClassLoader(IOHelper.getJarUrl(file));
                this.load(new JarFile(file), (ClassLoader)loader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void load(File file, ClassLoader loader) throws IOException {
        if (IOHelper.isJar(file)) {
            this.load(new JarFile(file), (ClassLoader)new PowerClassLoader(IOHelper.getJarUrl(file)));
        } else {
            if (loader == null) {
                loader = new PowerClassLoader(file.getParentFile().toURI().toURL());
            }
            this.load(file, loader, "");
        }
    }

    private void load(File file, ClassLoader loader, String prefix) {
        if (file.isDirectory()) {
            if (!file.getName().startsWith(".")) {
                for (File f : file.listFiles()) {
                    this.load(f, loader, prefix + file.getName() + ".");
                }
            }
        } else {
            String name = prefix + file.getName();
            String ext = ".class";
            if (name.endsWith(".class") && !name.startsWith(".") && !name.contains("!") && !name.contains("$")) {
                name = name.substring(0, name.length() - ".class".length());
                this.load(loader, name, file.getAbsolutePath());
            }
        }
    }

    private void load(JarFile jar, ClassLoader loader) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            String name = e.getName().replace('/', '.');
            String ext = ".class";
            if (!name.endsWith(".class") || name.contains("$")) continue;
            this.load(loader, name.substring(0, name.length() - ".class".length()), jar.getName());
        }
    }

    private void load(ClassLoader loader, String name, String path) {
        Class<?> clazz = null;
        try {
            clazz = loader.loadClass(name);
            if (clazz == null) {
                clazz = this.resolveClass(loader, name);
            }
            if (clazz != null) {
                if (clazz.isAnnotationPresent(PowerManifest.class)) {
                    PowerManifest manifest = clazz.getAnnotation(PowerManifest.class);
                    if (manifest.type() == null) {
                        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                            S86Powers.log(Level.WARNING, LocaleString.INVALID_POWER_TYPE.build(name));
                        }
                    } else if (manifest.name() == "") {
                        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                            S86Powers.log(Level.WARNING, LocaleString.INVALID_POWER_NAME.build(name));
                        }
                    } else if (manifest.version().ordinal() > MCVersion.CURRENT_VERSION.ordinal()) {
                        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                            S86Powers.log(Level.WARNING, LocaleString.INVALID_SERVER_VERSION.build(new Object[]{name, manifest.version()}));
                        }
                    } else if (manifest.server().ordinal() > MCServer.CURRENT_SERVER.ordinal()) {
                        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                            S86Powers.log(Level.WARNING, LocaleString.INVALID_SERVER_SOFTWARE.build(new Object[]{name, manifest.server()}));
                        }
                    } else if (manifest.incomplete() && !ConfigOption.Powers.LOAD_INCOMPLETE_POWERS) {
                        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                            S86Powers.log(Level.WARNING, LocaleString.INCOMPLETE_POWER.build(name));
                        }
                    } else if (manifest.usesPackets() && S86Powers.getProtocolLib() == null && !ConfigOption.Powers.BYPASS_PROTOCOLLIB_REQUIREMENT) {
                        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                            S86Powers.log(Level.WARNING, LocaleString.POWER_REQUIRES_PROTOCOLLIB.build(name));
                        }
                    } else {
                        this.load(clazz);
                    }
                } else if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                    S86Powers.log(Level.WARNING, LocaleString.INVALID_POWER_MANIFEST.build(name));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    private void load(Class<?> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (clazz.getSuperclass().equals(Power.class)) {
            if (!S86Powers.getConfigManager().isBlocked(clazz.getSimpleName())) {
                Power power = clazz.asSubclass(Power.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                    S86Powers.log(Level.INFO, LocaleString.POWER_LOAD_SUCCESS.build(power));
                }
                power.setEnabled(true);
                S86Powers.getConfigManager().addPower(power);
            } else {
                S86Powers.log(Level.WARNING, LocaleString.POWER_LOAD_BLOCKED.build(clazz));
            }
        }
    }

    private Class<?> resolveClass(ClassLoader loader, String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        for (int i = 0; i < TYPE_PREFIX.length && (clazz = loader.loadClass(POWER_PREFIX + TYPE_PREFIX[i] + name)) == null; ++i) {
        }
        return clazz;
    }
}

